#ifndef H_CDW_CONFIG_WINDOW
#define H_CDW_CONFIG_WINDOW


#include <stdbool.h>

#include "main.h"
#include "cdw_config.h"
#include "cdw_widgets.h"
#include "cdw_form.h"
#include "cdw_tabs_window.h"



typedef cdw_rv_t (* fields_builder_function_t)(cdw_form_t *, void *, int, int, int, int);


typedef struct {
	bool visible;           /* On some occasions some options pages are disabled = invisible. */
	int n_fields;           /* Number of fields in ncurses form (last field=NULL not included). */
	fields_builder_function_t fields_builder;  /* Function that defines fields description and creates the fields in the options page. */
	const char *label;      /* Text label specific to each options page. It will be passed to function creating tabs of tabbed window. */
	cdw_form_t *cdw_form;   /* Data structure built on top of ncurses fields, and combined with "tabbed windows" window and subwindow. */
} cdw_options_page_t;

cdw_rv_t cdw_config_window(void);


cdw_rv_t cdw_config_ui_tabs_window_form_draw(cdw_tabs_window_t *twindow);
int      cdw_config_ui_tabs_window_form_reader(void *twindow);


/* robwoj44 has informed me that in some setups F1 is caught by desktop
   environment or terminal emulator, so hotkeys for options window
   panels can't start with F1. */
#define CDW_CONFIG_UI_FX_START_KEY 2
/* "Safe and Close Key"; it can't be F12 because it is caught by Puppy
   menu in Puppy Linux (information from robwoj44) */
#define CDW_CONFIG_UI_SnC_KEY_A 10
/* Some terminal emulators use F10 as a hotkey for context menu;
   user can disable the feature in terminal emulator, but if he doesn't
   want to do this, or he has a bad luck, he may be stuck with F10 key
   that doesn't work in cdw.

   'bad luck':
   http://sourceforge.net/tracker/index.php?func=detail&aid=3424993&group_id=124080&atid=698428
   "Disabling menu access key has no effect - ID: 3424993"
   RoxTerm + GTK3

   This is an auxiliary SnC key
*/
#define CDW_CONFIG_UI_SnC_KEY_B 9






/* field indexes for page with hardware configuration */
enum {
	f_selected_drive_l = 0,
	f_selected_drive_dd,
	f_custom_drive_l,
	f_custom_drive_i,
	f_scsi_l,
	f_scsi_i,
	f_hw_txt_t };

/* field indexes for page with audio settings */
enum {
	f_audiodir_l = 0,
	f_audiodir_i,
	f_audiodir_b };

/* field indexes for page with UDF settings */
enum {
	f_udf_tools_t = 0,
	f_udf_options_t
};

/* field indexes for page with tool settings */
enum {
	f_ext_tools_no_save_t = 0,
	f_ext_tools_manual_selection_cb,
	f_ext_tools_manual_selection_l,
	f_ext_tools_iso9660_l,
	f_ext_tools_iso9660_dd,
	f_ext_tools_cd_handlers_l,
	f_ext_tools_cd_handlers_dd,
	f_ext_tools_dvd_handlers_l,
	f_ext_tools_dvd_handlers_dd,
	f_ext_tools_mkisofs_path_l,
	f_ext_tools_mkisofs_path_dd,
	f_ext_tools_cdrecord_path_l,
	f_ext_tools_cdrecord_path_dd,
	f_ext_tools_digest_handlers_l,
	f_ext_tools_digest_handlers_dd };


/* field indexes for page with log and other settings */
enum {
	f_log_fp_l = 0,
	f_log_fp_i,
	f_log_fp_b,
	f_showlog_cb,
	f_showlog_l,
	f_volume_size_l,
	f_volume_size_dd,
	f_cust_volume_size_l,
	f_cust_volume_size_i,
	f_cust_volume_size_l2,
	f_follow_symlinks_cb,
	f_follow_symlinks_l,
	f_fs_lynx_like_motion_cb,
	f_fs_lynx_like_motion_l,

	PAGE_OTHER_N_FIELDS
};


#endif /* H_CDW_CONFIG_WINDOW */
