#include <stdio.h>
#include <string.h>

#define MAX_PY_NUM 420
#define MAX_EACH_PY 38
#define MAX_EACH_HZ 241

/* Important,need change according to assoc.h */
#define MAX_PHRASE_LEN 6

typedef struct {
  unsigned short key;
  char py[7];
} PinYin;

PinYin pytab[26][MAX_EACH_PY];
char hztab[MAX_PY_NUM][MAX_EACH_HZ]; 

int LoadTable()
{

  FILE *stream;
  char str[250],strpy[15],strhz[241];
  int i=0,j=0;
  int tmp,curpy;
  PinYin *pyt=(PinYin *)pytab;

  if( (stream = fopen( "/usr/local/lib/pyinput.dic/table", "r" )) == NULL ){
    fprintf(stderr,"/usr/local/lib/pyinput.dic/table not found\n");
    exit(1);
  }

  while( !feof( stream )) {
    if( fgets(str,250,stream)!=NULL){
      sscanf(str,"%s %s",strpy,strhz);

      strcpy( hztab[i],strhz);

      curpy=strpy[0]-97;
      if(curpy!=tmp) {j=0;}
      strcpy( (pyt+curpy*MAX_EACH_PY+j)->py,strpy);
      (pyt+curpy*MAX_EACH_PY+j)->key=i+1;
      tmp=curpy;

      i++,j++;
    }
  }

  fclose(stream);
  return (0);
}

int lib2sim(inname,outname)
     char *inname;
     char *outname;
{
  FILE *stream,*out;
  unsigned char clen;
  int len;
  unsigned char key[MAX_PHRASE_LEN+1],str[2*MAX_PHRASE_LEN+1];
  char tab='\011';
  int i,j,k;
  PinYin *pyt=(PinYin *)pytab;
  unsigned short keyint,keytmp;

  if( (stream = fopen( inname, "r" )) == NULL ){
    fprintf(stderr,"%s cant open.\n",inname);
    exit(1);
  }

  if( (out = fopen( outname, "wb" )) == NULL ){
    fprintf(stderr,"%s cant open.\n",outname);
    exit(1);
  }

  while( !feof( stream )) {
    if(fread(&clen,sizeof(char),1,stream)){
      len=(int)clen;
      if( len > 0 && fread(key,sizeof(char),len+1,stream) &&
	  fread(str,sizeof(char),len*2,stream) ) {
	*(str+len*2)='\0';
	fprintf(out,"%s ",str);
	for(k=0;k<len;k++){
	  keyint=(unsigned short)key[0];
	  keyint=(keyint<<(8-k)) & 0x0100;
	  keyint += (unsigned short)key[k+1];
	  for(i=0;i<26;i++){
	    for(j=0;(keytmp=(pyt+i*MAX_EACH_PY+j)->key);j++){
	      if(keyint==keytmp){
		fprintf(out,"%s",(pyt+i*MAX_EACH_PY+j)->py);
		if(k!=len-1)
		  fprintf(out," ");
		else
		  fprintf(out,"\n");
	      }
	    }
	  }
	}
      }
    }
  }
  fclose(stream);
  fclose(out);
  return 1;
}

void main(argc,argv)
     int argc;
     char **argv;
{
  if(argc != 3) {
    fprintf(stderr,"usage: %s <input_name> <output_name>\n",argv[0]);
    return;
  }
  LoadTable();
  lib2sim(argv[1],argv[2]);
  return;
}
