/**********************************************************************

	--- Qt Architect generated file ---

	File: VideoTuning.cc
	Last generated: Tue Oct 17 04:10:34 2000

 *********************************************************************/

#include <qbutton.h>

#include "VideoTuning.h"

#define Inherited CVideoTuningData

CVideoTuning::CVideoTuning(CVideoDevice *_video, QWidget* parent, const char* name)
	: Inherited(parent, name)
{
   int i, s;
   QButton *pBut;
   CVideoDeviceInput *pInp;
   
   pVideo = _video;
   pInput = NULL;
   pTuner = NULL;

   /* Find number of inputs */
   MaxInputs = pVideo->GetInputs();
   if (MaxInputs > 6) MaxInputs = 6;
   s = pVideo->GetCurrentInput();
   InputSelection->setButton(-1);
   for (i = 0; i < 6; i++) {
      pBut = InputSelection->find(i);
      if (pBut != NULL) {
        if (i < MaxInputs) {
          pInp = pVideo->GetInput(i);
          if (pInp != NULL)
            pBut->setText(pInp->GetName());
          if (i == s)
            InputSelection->setButton(i);
        }
        else
          pBut->hide();
      }
   }
   DisplayFrequency(0);
}


CVideoTuning::~CVideoTuning()
{
}

// private

void CVideoTuning::DisplayFrequency(float freq)
{
   FrequencySlider->setValue(freq / 1e5);
   FrequencyShow->display(freq / 1e6);
}


// private slots

void CVideoTuning::ClickedInput(int n)
{
   int i, m, s;
   CVideoDeviceTuner *tuner;
   QButton *pBut;
   bool turn;

   turn = FALSE;
   if (pVideo->SelectInput(n)) {
     // Check to see if this input has tuners, put labels on 
     pTuner = NULL;
     pInput = pVideo->GetInput(n);
     if (pInput != NULL) {
       m = pInput->GetTuners();
       s = pInput->GetCurrentTuner();
       if (m > 3) m = 3;
       for (i = 0; i < m; i++) {
          tuner = pInput->GetTuner(i);
          pBut = TunerSelection->find(i);
          if (pBut != NULL) {
            if (tuner != NULL) {
              pBut->show();
              pBut->setText(tuner->GetName());
              if (i == s) {
                pTuner = tuner;
                TunerSelection->setButton(i);
              }
            }
            else
              pBut->hide();
          } // ..pBut
          turn = TRUE;
       } // ..for
       for (; i < 3; i++) {
          pBut = TunerSelection->find(i);
          if (pBut != NULL) pBut->hide();
       }
     }
   }

   if (turn) {
     TunerSelection->setEnabled(TRUE);
     FrequencySlider->show();
     FrequencyShow->show();
     FrequencyLabel->show();
     if (pTuner)
       DisplayFrequency(pTuner->GetFrequency());
   }
   else {
     TunerSelection->setEnabled(FALSE);
     FrequencySlider->hide();
     FrequencyShow->hide();
     FrequencyLabel->hide();
   }
}

void CVideoTuning::ClickedTuner(int n)
{
   if (pInput) {
     pInput->SelectTuner(n);
     
     pTuner = pInput->GetTuner(n);
     
     // emit...
   }
}

/**
  \param n Is the new position of the slider = frequency in MHz
*/  
void CVideoTuning::MovedSlider(int n)
{
   float f;

   f = n * 1e5;
   if (pTuner)
     pTuner->SetFrequency(f);
   DisplayFrequency(f);
}

