#include <type_traits>

template <typename Type>
concept bool Copyable()
{
    return std::is_copy_constructible<Type>::value;
}

// template <typename ...Types>
// struct Delegate;
//
// template <typename Head, typename ...Types>
// struct Delegate<Head, Types...>
// {
// //    enum {value =
//     static bool const value =
// //            std::is_copy_constructible<Head>::value &&
//             Copyable<Head>() &&
//             Delegate<Types...>::value
// //    };
//     ;
// };
//
// template <typename Head>
// struct Delegate<Head>
// {
// //    enum {value = std::is_copy_constructible<Head>::value };
//     enum {value = Copyable<Head>() };
// };

//DELEGATE
template <typename ...Types>
struct Delegate;

template <typename Head, typename ...Types>
struct Delegate<Head, Types...>
{
    static bool const value =
        std::is_copy_constructible<Head>::value
        && Delegate<Types...>::value;
};

template <typename Head>
struct Delegate<Head>
{
    static bool const value =
        std::is_copy_constructible<Head>::value;
};
//=

//MULTICOP
template <typename ...Type>
concept bool MultiCopyable()
{
    return Delegate<Type...>::value;
}
//=
//    return (true && ... && std::is_copy_constructible<Type>::value);

//MULTIFUN
template <MultiCopyable ...Types>
void multifun(Types ...params)
{}

template <typename ...Types>
    requires MultiCopyable<Types...>()
void multifun2(Types ...params)
{}
//=

struct NoCopy
{
    NoCopy() = default;
    NoCopy(NoCopy const &other) = delete;
};

int main()
{
    multifun(2, 3, 5);
//    multifun(2, 3, NoCopy{});

    multifun2(2, 3, 5);
    multifun2(2, 3, NoCopy{}, 5);
}
