from unittest import makeSuite

from bzrlib.config import LocationConfig
from bzrlib import osutils
from bzrlib.tests import TestCaseWithTransport

from bzrlib.plugins.bzrtools.cbranch import cbranch


class TestCBranch(TestCaseWithTransport):

    def test_cbranch_creates_containing_dirs(self):
        source = self.make_branch_and_tree('source')
        config = LocationConfig(osutils.abspath('target'))
        config.set_user_option('cbranch_target',
                               'directory/subdirectory/target_branch')
        cbranch('source', 'target')
        self.failUnlessExists('directory/subdirectory/target_branch')


def test_suite():
    return makeSuite(TestBzrTools)
