/******************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BSCommander is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BSCommander is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_FTPDELETER_H
#define INCLUDED_FTPDELETER_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_VIEWTABLE_H
#include "ViewTable.h"
#endif // INCLUDED_VIEWTABLE_H

#ifndef INCLUDED_FTPSERVERLIST_H
#include "FtpServersList.h"
#endif // INCLUDED_FTPSERVERLIST_H

#ifndef INCLUDED_QOBJECT_H
#include <qobject.h>
#define INCLUDED_QOBJECT_H
#endif // INCLUDED_QOBJECT_H

#ifndef INCLUDED_STAC
#include <stack>
#define INCLUDED_STACK
#endif // INCLUDED_STACK

/*------- forward declarations:
-------------------------------------------------------------------*/
class PleaseWait;
class SelectedItems;
class QFtp;

/*------- class declaration:
-------------------------------------------------------------------*/
class FTPDeleter :public QObject
{
    Q_OBJECT

// ******* TYPES *******
private:
    enum {
        CMD_NONE = 0,
        CMD_LOGIN,
        CMD_LIST,
        CMD_CDUP,
        CMD_CD,
        CMD_RMDIR,
        CMD_REMOVE,
        CMD_CLOSE
    };

// ******* CONSTRUCTION/DESTRUCTION *******
public:
    FTPDeleter( const FtpServerInfo&,  const ViewTable::SelectedItems&, PleaseWait* );
    ~FTPDeleter();
private:
    FTPDeleter( const FTPDeleter& );
    FTPDeleter& operator=( const FTPDeleter& );

// ******* CONSTANTS *******
private:
    static const char* const DeleteCaption;

// ******* MEMBERS *******
private:
    QFtp*       const   d_ftp;
    const FtpServerInfo d_fsi;
   	PleaseWait* const   d_please_wait;
	QString             d_dir_name;
	QString             d_path;
	bool                d_first_cd;
	int                 d_cmd;
    int                 d_pwd_cmd_id;
	std::stack<QString> d_dirs;
	std::stack<QString> d_files_on_dir;
	std::stack<QString> d_dirs_on_dir;

// ******* METHODS *******
public:
    void run           ();
private:
    void doit          ();
    void display       ( const QString& );
    void list          ();
    void pwd           ();
    void rmdir         ();
    void remove        ();
    void cd_up         ();
    void cd            ( const QString& );
    void close         ();
private slots:
    void done          ( bool );
    void item          ( const QUrlInfo& );
    void raw_cmd_finish( int, bool );
    void raw_cmd_reply ( int, const QString& );
signals:
    void done          ();
};

#endif // INCLUDED_FTPDELETER_H
