#include "main.ih"

void usage(string const &program_name)
{
    cout << 
    "\n" <<
    program_name << " by Frank B. Brokken (f.b.brokken@rug.nl)\n"
    "\n"
    "LALR(1) Parser Generator V "  << version << "\n"
    "Copyright (c) GPL " << year << ". NO WARRANTY.\n"
    "Designed after `bison++' (1.21.9-1) by Alain Coetmeur "
                                                "<coetmeur@icdc.fr>\n"
    "\n"
    "Usage: " << program_name << " [OPTIONS] file\n"
    "Where:\n"
    "  [OPTIONS] - zero or more optional arguments (int options between\n"
    "              parentheses. Short options require arguments if their\n"
    "              long option variants do too):\n"

    "   --analyze-only (-A): only analyze the grammar; except for possibly\n"
    "           the verbose grammar description file no files are written.\n"

    "   --baseclass-header=<header> (-b):\n"
    "           filename holding the base class definition.\n"

    "   --baseclass-preinclude=<header> (-H):\n"
    "           preinclude header in the base-class header file.\n"
    "           Use [header] to include <header>, otherwise \"header\"\n"
    "           will be included.\n"

    "   --baseclass-skeleton=<skeleton> (-B):\n"
    "           location of the baseclass header skeleton.\n"

    "   --class-header=<header> (-c):\n"
    "           filename holding the parser class definition.\n"

    "   --class-name=<name>:\n"
    "           the name of the generated C++ class.\n"

    "   --class-skeleton=<skeleton> (-C):\n"
    "           location of the class header skeleton.\n"

    "   --construction:\n"
    "           write details about the grammar analysis to stdout.\n"

    "   --debug:\n"
    "           generates debug output statements in the generated parse\n"
    "           function's source.\n"

    "   --default-actions=<off|quiet|warn|std> (-d):\n"
    "           unless 'off', add a $$ = $1 action block to production "
                                                                    "rules\n" 
    "           not defining final action blocks.\n"

    "   --error-verbose:\n"
    "           the parse function will dump the parser's state stack to "
                                                                    "stdout\n"
    "           when a syntactic error is reported\n"

    "   --filenames=<filename> (-f):\n"
    "           filename of output files (overruling the default filename).\n"

    "   --flex:\n"
    "           use the traditional `flex' interface.\n"

    "   --help (-h):\n"
    "           produce this information (and terminate).\n"

    "   --implementation-header=<header> (-i):\n"
    "           filename holding the implementation header.\n"

    "   --implementation-skeleton=<skeleton> (-I):\n"
    "           location of the implementation header skeleton.\n"

    "   --insert-stype:\n"
    "           show selected semantic values in the output generated by\n"
    "           --debug. Ignored unless --debug was specified.\n"

    "   --max-inclusion-depth=<value>:\n"
    "           sets the maximum number of nested grammar files (default: "
                                                                    "10).\n"
    "   --namespace=<namespace> (-n):\n"
    "           define the parser in the mentioned namespace.\n"

    "   --no-baseclass-header:\n"
    "           don't create the parser's base class header.\n"

    "   --no-decoration (-D):\n"
    "           do not include the user-defined actions when generating the\n"
    "           parser's tt(parse) member.\n"

    "   --no-lines:\n"
    "           don't put #line directives in generated output, overruling "
                                                                    "the \n"
    "           %lines directive.\n"

    "   --no-parse-member:\n"
    "           don't create the member parse().\n"

    "   --own-debug:\n"
    "           bisonc++ displays the actions of its parser while "
                                                                "processing\n"
    "           its input file(s) (implies --verbose).\n"

    "   --own-tokens (-T):\n"
    "           bisonc++ displays the tokens and corresponding matched "
                                                                    "text,\n"
    "           received from its lexcial scanner.\n"

    "   --parsefun-skeleton=<parserskel> (-P):\n"
    "           location of the parse function's skeleton.\n"

    "   --parsefun-source=<source> (-p):\n"
    "           filename holding the parse function's source.\n"

    "   --polymorphic-code-skeleton=<skeleton> (-L):\n"
    "           location of the non-inline polymorphic functions skeleton.\n"

    "   --polymorphic-skeleton=<skeleton> (-M):\n"
    "           location of the polymorphic semantic values skeleton.\n"

    "   --print-tokens (-t):\n"
    "           the print() member of the generated parser class displays\n"
    "           the tokens and their corresponding matched text.\n"

    "   --required-tokens=<value>:\n"
    "           minimum number of successfully processed tokens between\n"
    "           errors (default: 0).\n"

    "   --scanner=<header-file> (-s):\n"
    "           include `header-file' declaring the class Scanner, and call\n"
    "           d_scanner.yylex() from Parser::lex().\n"

    "   --scanner-class-name=<scanner class name>:\n"
    "           specifies the name of the scanner class: this option is\n"
    "           only interpreted if --scanner (or %scanner) is also used.\n"

    "   --scanner-debug:\n"
    "           extensive display of the actions of bisonc++'s scanner\n"

    "   --scanner-matched-text-function=<function call>:\n"
    "           specifies the function to call returning the text matched "
                                                                    "by\n"
    "           the lexical scanner when returning a token\n"

    "   --scanner-token-function=<scanner token function>:\n"
    "           specifies the function to call by the parser's lex() "
                                                                "function\n"
    "           returning the next token returned by the lexcial scanner\n"
    "           (by default d_scanner.yylex() when --scanner is used)\n"

    "   --show-filenames:\n"
    "           show the names of the used/generated files on the standard\n"
    "           error stream.\n"

    "   --skeleton-directory=<skeleton-directory> (-S):\n"
    "           location of the skeleton directory.\n"

    "   --tag-mismatches=<off|on>:\n"
    "           unless 'off', issue a warning if no $$ statement was "
                                                                "detected\n"
    "           in an action block, or if no default $$ = $1 action can be\n"
    "           added to a production rule without final action block, or\n"
    "           if run-time a tag-mismatch is observed.\n"

    "   --target-directory=<pathname>:\n"
    "           pathname defines the directory where generated files should "
                                                                        "be\n"
    "           written. By default this is the directory where bisonc++ is\n"
    "           called.\n"

    "   --thread-safe:\n"
    "           no static data are modified, making bisonc++'s generated\n"
    "           code thread-safe.\n"

    "   --usage: produce this information (and terminate).\n"

    "   --verbose (-V):\n"
    "           generate verbose description of the analyzed grammar.\n" 

    "   --version (-v):\n"
    "           display " << program_name << "'s version and terminate.\n"

                                                                    << endl;
}




