/*
    This program can be distributed under the terms of the GNU GPL.
    See the file COPYING.

    Author: Martin Prtel <martin.partel@gmail.com>
*/

#ifndef INC_BINDFS_PERMCHAIN_H
#define INC_BINDFS_PERMCHAIN_H


#include <config.h>

#define _GNU_SOURCE

#include <stdlib.h>
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#include <unistd.h>

struct permchain;

struct permchain *permchain_create();

/* Parses chmod arguments like 0777, a=rX, og-rwx etc.
   Multiple rules may be given, separated with commas or colons.
   Unlike the ordinary chmod command, the octal specification may be
   present in a comma/colon-separated list.
   Returns 0 on success. On failure, pc will not be modified. */
int add_chmod_rules_to_permchain(const char *rule, struct permchain *pc);

/* Links 'right' to the end of 'left'. Don't destroy 'right' after this. */
void permchain_cat(struct permchain *left, struct permchain *right);

mode_t permchain_apply(struct permchain *pc, mode_t tgtmode);

void permchain_destroy(struct permchain *pc);

#endif
