;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Ieee/output.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Jul  5 11:13:01 1992                          */
;*    Last change :  Wed Feb 22 18:49:25 2006 (serrano)                */
;*    -------------------------------------------------------------    */
;*    6.10.3 Output (page 31, r4)                                      */
;*    -------------------------------------------------------------    */
;*    This module is able to display object even if it is not          */
;*    properly initailzed. This is very important because with this    */
;*    means, error during the initialization time will be correctly    */
;*    prompted. In particular, we must be very carefull not to launch  */
;*    unexpected errors.                                               */
;*    -------------------------------------------------------------    */
;*    Source documentation:                                            */
;*       @path ../../manuals/body.texi@                                */
;*       @node Input And Output@                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_output_6_10_3

   (import  __error
	    __bexit
	    __r4_ports_6_10_1
   	    __bigloo
	    __param)
   
   (use     __type
	    __tvector
	    __structure
	    __bexit
	    __object
	    __ucs2
	    __unicode
	    __date
	    __thread
	    __foreign
	    __mmap
	    __process
	    __socket
	    __custom
	    __object
	    __bigloo

	    __r4_ports_6_10_1
	    __r4_input_6_10_2
	    __r4_numbers_6_5_fixnum
	    __r4_numbers_6_5_flonum
	    __r4_numbers_6_5
	    __r4_characters_6_6
	    __r4_strings_6_7
	    __r4_vectors_6_8
	    __r4_equivalence_6_2
	    __r4_booleans_6_1
	    __r4_symbols_6_4
	    __r4_pairs_and_lists_6_3
	    __r4_control_features_6_9
	    __r5_control_features_6_4

	    __evenv)
     
   (extern  (macro output-string-port::bool (::obj)
		   "OUTPUT_STRING_PORTP")
	    ($write-char::obj (::bchar ::output-port)
			      "bgl_write_char")
	    (macro $display-char::obj (::uchar ::output-port)
		   "BGL_DISPLAY_CHAR")
	    ($write-ucs2::obj (::bucs2 ::output-port)
				"bgl_write_ucs2")
	    ($display-ucs2::obj (::bucs2 ::output-port)
				"bgl_display_ucs2")
	    ($write-string::obj (::bstring ::bool ::output-port)
				"bgl_write_string")
	    ($display-string::obj (::bstring ::output-port)
				  "bgl_display_string")
	    ($display-substring::obj (::bstring ::long ::long ::output-port)
				  "bgl_display_substring")
	    ($display-fixnum::obj (::bint ::output-port)
				  "bgl_display_fixnum")
	    ($write-elong::obj (::elong ::output-port)
			       "bgl_write_elong")
	    ($display-elong::obj (::elong ::output-port)
				 "bgl_display_elong")
	    ($write-llong::obj (::llong ::output-port)
			       "bgl_write_llong")
	    ($display-llong::obj (::llong ::output-port)
				 "bgl_display_llong")
	    ($write-utf8string::obj (::bstring ::output-port)
				    "bgl_write_utf8string")
	    ($display-ucs2string::obj (::ucs2string ::output-port)
				      "bgl_display_ucs2string")
	    ($write-cnst::obj (::obj ::output-port)
			      "bgl_write_cnst")
	    ($write-procedure::obj (::procedure ::output-port)
				   "bgl_write_procedure")
	    ($write-output-port::obj (::output-port ::output-port)
				   "bgl_write_output_port")
	    ($write-input-port::obj (::input-port ::output-port)
				   "bgl_write_input_port")
	    ($write-binary-port::obj (::binary-port ::output-port)
				   "bgl_write_binary_port")
	    ($write-foreign::obj (::foreign ::output-port)
				 "bgl_write_foreign")
	    ($write-process::obj (::process ::output-port)
				 "bgl_write_process")
	    ($write-socket::obj (::socket ::output-port)
				 "bgl_write_socket")
	    ($write-mmap::obj (::mmap ::output-port)
				 "bgl_write_mmap")
	    ($write-opaque::obj (::obj ::output-port)
				 "bgl_write_opaque")
	    ($write-custom::obj (::obj ::output-port)
				 "bgl_write_custom")
	    ($write-unknown::obj (::obj ::output-port)
				 "bgl_write_unknown")
	    ($ill-char-rep::obj (::uchar)
				"bgl_ill_char_rep")

	    (export write-2 "bgl_write_obj")
	    (export display-2 "bgl_display_obj"))
    
   (java    (class foreign
	       (method static output-string-port::bool (::obj)
		       "OUTPUT_STRING_PORTP")
	       (method static $write-char::obj (::bchar ::output-port)
		       "write_char")
	       (method static $display-char::obj (::uchar ::output-port)
		       "display_char")
	       (method static $write-ucs2::obj (::bucs2 ::output-port)
		       "write_ucs2")
	       (method static $display-ucs2::obj (::bucs2 ::output-port)
		       "display_ucs2")
	       (method static $write-string::obj (::bstring ::bool ::output-port)
		       "write_string")
	       (method static $display-string::obj (::bstring ::output-port)
		       "display_string")
	       (method static $display-substring::obj (::bstring ::long ::long ::output-port)
		       "display_substring")
	       (method static $display-fixnum::obj (::bint ::output-port)
		       "display_fixnum")
	       (method static $write-elong::obj (::elong ::output-port)
		       "write_elong")
	       (method static $display-elong::obj (::elong ::output-port)
		       "display_elong")
	       (method static $write-llong::obj (::llong ::output-port)
		       "write_llong")
	       (method static $display-llong::obj (::llong ::output-port)
		       "display_llong")
	       (method static $write-utf8string::obj (::bstring ::output-port)
		       "write_utf8string")
	       (method static $display-ucs2string::obj (::ucs2string ::output-port)
		       "display_ucs2string")
	       (method static $write-cnst::obj (::obj ::output-port)
		       "write_object")
	       (method static $write-procedure::obj (::obj ::output-port)
		       "write_object")
	       (method static $write-output-port::obj (::obj ::output-port)
		       "write_object")
	       (method static $write-input-port::obj (::obj ::output-port)
		       "write_object")
	       (method static $write-binary-port::obj (::obj ::output-port)
		       "write_object")
	       (method static $write-foreign::obj (::obj ::output-port)
		       "write_object")
	       (method static $write-process::obj (::obj ::output-port)
		       "write_object")
	       (method static $write-socket::obj (::obj ::output-port)
		       "write_object")
	       (method static $write-mmap::obj (::obj ::output-port)
		       "write_object")
	       (method static $write-opaque::obj (::obj ::output-port)
		       "write_object")
	       (method static $write-custom::obj (::obj ::output-port)
		       "write_object")
	       (method static $write-unknown::obj (::obj ::output-port)
		       "write_object")
	       (method static $ill-char-rep::obj (::uchar)
		       "ill_char_rep")))
    
   (export  (newline . port)
	    (inline newline-1 ::output-port)
	    (write obj . port)
	    (write-2 obj ::output-port)
	    (display obj . port)
	    (display-2 obj ::output-port)
	    (write-char ::uchar . port)
	    (write-symbol ::symbol ::output-port)
	    (inline write-char-2 ::uchar ::output-port)
	    (inline display-string ::bstring ::output-port)
	    (inline display-substring ::bstring ::long ::long ::output-port)
	    (write-string ::bstring ::output-port)
	    (display-symbol ::symbol ::output-port)
	    (write-symbol ::symbol ::output-port)
	    (inline display-fixnum ::bint ::output-port)
	    (inline display-flonum ::real ::output-port)
	    (display-ucs2string ::ucs2string ::output-port)
	    (write-ucs2string ::ucs2string ::output-port)
	    (illegal-char-rep ::uchar) 
	    (display* . obj)
	    (write* . obj)
	    (print . obj)
	    (fprint ::output-port . obj)
	    (format ::bstring . obj)
	    (printf ::bstring . obj)
	    (fprintf ::output-port ::bstring . obj))

   (pragma  (output-string-port nesting args-safe)
	    ($display-char nesting)
	    ($write-char nesting)))
   
;*---------------------------------------------------------------------*/
;*    newline ...                                                      */
;*---------------------------------------------------------------------*/
(define (newline . port)
   (let ((port (match-case port
		  (()
		   (current-output-port))
		  ((?-)
		   (car port))
		  (else
		   (error "newline"
			  "wrong number of optional arguments"
			  port)))))
      (newline-1 port)))

;*---------------------------------------------------------------------*/
;*    newline-1 ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (newline-1 port::output-port)
   ($display-char #\Newline port))

;*---------------------------------------------------------------------*/
;*    display ...                                                      */
;*---------------------------------------------------------------------*/
(define (display obj . port)
   (let ((port (match-case port
		  (()
		   (current-output-port))
		  ((?-)
		   (car port))
		  (else
		   (error "display"
			  "wrong number of optional arguments"
			  port)))))
      (display-2 obj port)))

;*---------------------------------------------------------------------*/
;*    write ...                                                        */
;*---------------------------------------------------------------------*/
(define (write obj . port)
   (let ((port (match-case port
		  (()
		   (current-output-port))
		  ((?-)
		   (car port))
		  (else
		   (error "write"
			  "wrong number of optional arguments"
			  port)))))
      (write-2 obj port)))

;*---------------------------------------------------------------------*/
;*    write-char ...                                                   */
;*---------------------------------------------------------------------*/
(define (write-char char . port)
   (let ((port (match-case port
		  (()
		   (current-output-port))
		  ((?-)
		   (car port))
		  (else
		   (error "write"
			  "wrong number of optional arguments"
			  port)))))
      (write-char-2 char port)))

;*---------------------------------------------------------------------*/
;*    write-char-2 ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (write-char-2 char::uchar port::output-port)
   ($display-char char port))

;*---------------------------------------------------------------------*/
;*    illegal-char-rep ...                                             */
;*---------------------------------------------------------------------*/
(define (illegal-char-rep char)
   (if (or (char-alphabetic? char) (char-numeric? char))
       char
       (case char
	  ((#\Newline)
	   "#\Newline")
	  ((#\Return)
	   "#\Return")
	  ((#\Space)
	   "#\Space")
	  ((#\Tab)
	   "#\Tab")
	  (else
	   (let ((i (char->integer char)))
	      (if (<fx i (char->integer #\!))
		  ($ill-char-rep char)
		  char))))))

;*---------------------------------------------------------------------*/
;*    print ...                                                        */
;*---------------------------------------------------------------------*/
(define (print . obj)
   (let ((port (current-output-port)))
      (let loop ((l   obj)
		 (res '()))
	 (if (null? l)
	     (begin
		($display-char #\Newline port)
		res)
	     (let ((v (car l)))
		(display-2 v port)
		(loop (cdr l) v))))))

;*---------------------------------------------------------------------*/
;*    display* ...                                                     */
;*---------------------------------------------------------------------*/
(define (display* . obj)
   (let ((port (current-output-port)))
      (let loop ((l obj))
	 (if (null? l)
	     #unspecified
	     (let ((v (car l)))
		(display (car l) port)
		(loop (cdr l)))))))

;*---------------------------------------------------------------------*/
;*    write* ...                                                       */
;*---------------------------------------------------------------------*/
(define (write* . obj)
   (let ((port (current-output-port)))
      (let loop ((l obj))
	 (if (null? l)
	     #unspecified
	     (let ((v (car l)))
		(write-2 (car l) port)
		(loop (cdr l)))))))

;*---------------------------------------------------------------------*/
;*    fprint ...                                                       */
;*---------------------------------------------------------------------*/
(define (fprint port . obj)
   (let loop ((l    obj)
	      (res '()))
      (if (null? l)
	  (begin
	     ($display-char #\Newline port)
	     res)
	  (let ((v (car l)))
	     (display-2 (car l) port)
	     (loop (cdr l) v)))))

;*---------------------------------------------------------------------*/
;*    xprintf ...                                                      */
;*---------------------------------------------------------------------*/
(define (xprintf procname p::output-port fmt::bstring objs::pair-nil)
   (let ((len (string-length fmt)))
      (let loop ((i 0)
		 (os objs))
	 (define (next os fmt)
	    (if (null? os)
		(error procname "Insufficient number of arguments" fmt)
		(car os)))
	 (define (print-radix radix num)
	    (if (not (number? num))
		(error procname "Illegal number" num)
		(display (number->string num radix) p)))
	 (if (<fx i len)
	     (let ((c (string-ref fmt i)))
		(if (char=? c #\~)
		    (if (=fx i (-fx len 1))
			(error procname
			       "Tag not allowd here"
			       (substring fmt i len))
			(let ((f (string-ref fmt (+fx i 1))))
			   (case f
			      ((#\a #\A)
			       (display (next os f) p)
			       (loop (+fx i 2) (cdr os)))
			      ((#\s #\S)
			       (write (next os f) p)
			       (loop (+fx i 2) (cdr os)))
			      ((#\v #\V)
			       (display (next os f) p)
			       (newline p)
			       (loop (+fx i 2) (cdr os)))
			      ((#\c #\C)
			       (let ((o (next os f)))
				  (if (not (char? o))
				      (error procname "Illegal char" o)
				      (begin
					 (write-char o p)
					 (loop (+fx i 2) (cdr os))))))
			      ((#\x #\X)
			       (print-radix 16 (next os f))
			       (loop (+fx i 2) (cdr os)))
			      ((#\o #\O)
			       (print-radix 8 (next os f))
			       (loop (+fx i 2) (cdr os)))
			      ((#\b #\B)
			       (print-radix 2 (next os f))
			       (loop (+fx i 2) (cdr os)))
			      ((#\% #\n)
			       (newline p)
			       (loop (+fx i 2) os))
			      ((#\r)
			       (write-char #\return p)
			       (loop (+fx i 2) os))
			      ((#\~)
			       (write-char #\~ p)
			       (loop (+fx i 2) os))
			      (else
			       (error procname "Illegal tag" f)))))
		    (begin
		       (write-char c p)
		       (loop (+fx i 1) os))))))))
			 
;*---------------------------------------------------------------------*/
;*    format ...                                                       */
;*---------------------------------------------------------------------*/
(define (format fmt . obj)
   (let ((p (open-output-string)))
      (xprintf 'format p fmt obj)
      (close-output-port p)))

;*---------------------------------------------------------------------*/
;*    printf ...                                                       */
;*---------------------------------------------------------------------*/
(define (printf fmt . obj)
   (xprintf 'printf (current-output-port) fmt obj))

;*---------------------------------------------------------------------*/
;*    fprintf ...                                                      */
;*---------------------------------------------------------------------*/
(define (fprintf port fmt . obj)
   (xprintf 'fprintf port fmt obj))

;*---------------------------------------------------------------------*/
;*    %write/display-2 ...                                             */
;*---------------------------------------------------------------------*/
(define-macro (%write/display-2 obj port disp)
   (let ((write/display-2 (symbol-append disp (string->symbol "-2")))
	 (write/display-symbol (symbol-append disp '-symbol))
	 (write/display-string (symbol-append disp '-string))
	 ($write/display-char (symbol-append '$ disp '-char))
	 (write/display-pair (symbol-append disp '-pair))
	 ($write/display-elong (symbol-append '$ disp '-elong))
	 ($write/display-llong (symbol-append '$ disp '-llong))
	 (write/display-ucs2string (symbol-append disp '-ucs2string))
	 (write/display-2ect (symbol-append 'object- disp))
	 (write/display-date (symbol-append disp '-date))
	 ($write/display-ucs2 (symbol-append '$ disp '-ucs2)))
      `(cond
	  ((fixnum? ,obj)
	   ($display-fixnum ,obj ,port))
	  ((symbol? ,obj)
	   (,write/display-symbol ,obj ,port))
	  ((string? ,obj) 
	   (,write/display-string ,obj ,port))
	  ((char? ,obj)
	   (,$write/display-char ,obj ,port))
	  ((pair? ,obj)
	   (,write/display-pair ,obj ,port))
	  ((null? ,obj)
	   (display-string "()" ,port))
	  ((eq? ,obj #f)
	   (display-string "#f" ,port))
	  ((eq? ,obj #t)
	   (display-string "#t" ,port))
	  ((eq? ,obj #unspecified)
	   (display-string "#unspecified" ,port))
	  ((elong? ,obj)
	   (,$write/display-elong ,obj ,port))
	  ((flonum? ,obj)
	   (display-flonum ,obj ,port))
	  ((keyword? ,obj)
	   (display-keyword ,obj ,port))
	  ((class? ,obj)
	   (write-class ,obj ,port))
	  ((vector? ,obj)
	   (write/display-vector ,obj ,port ,write/display-2))
	  ((llong? ,obj)
	   (,$write/display-llong ,obj ,port))
	  ((ucs2-string? ,obj)
	   (,write/display-ucs2string ,obj ,port))
	  ((struct? ,obj)
	   (write/display-structure ,obj ,port ,write/display-2))
	  ((object? ,obj)
	   (,write/display-2ect ,obj ,port))
	  ((date? ,obj)
	   (,write/display-date ,obj ,port))
	  ((mutex? ,obj)
	   (write-mutex ,obj ,port))
	  ((condition-variable? ,obj)
	   (write-condition-variable ,obj ,port))
	  ((ucs2? ,obj)
	   (,$write/display-ucs2 ,obj ,port))
	  ((cell? ,obj)
	   (write/display-cell ,obj ,port ,write/display-2))
	  ((eof-object? ,obj)
	   (display-string "#eof-object" ,port))
	  ((eq? ,obj '#!optional)
	   (display-string "#!optional" ,port))
	  ((eq? ,obj '#!rest)
	   (display-string "#!rest" ,port))
	  ((eq? ,obj '#!key)
	   (display-string "#!key" ,port))
	  ((procedure? ,obj)
	   ($write-procedure ,obj ,port))
	  ((output-port? ,obj)
	   (if (output-string-port? ,obj)
	       (display-string "#<output_string_port>" ,port)
	       ($write-output-port ,obj ,port)))
	  ((input-port? ,obj)
	   ($write-input-port ,obj ,port))
	  ((cnst? obj)
	   ($write-cnst obj port))
	  ((tvector? ,obj)
	   (write/display-tvector ,obj ,port ,write/display-2))
	  ((foreign? ,obj)
	   ($write-foreign ,obj ,port))
	  ((process? ,obj)
	   ($write-process ,obj ,port))
	  ((socket? ,obj)
	   ($write-socket ,obj ,port))
	  ((mmap? ,obj)
	   ($write-mmap ,obj ,port))
	  ((opaque? ,obj)
	   ($write-opaque ,obj ,port))
	  ((custom? ,obj)
	   ($write-custom ,obj ,port))
	  (else
	   ($write-unknown ,obj ,port)))))

;*---------------------------------------------------------------------*/
;*    display-2 ...                                                    */
;*---------------------------------------------------------------------*/
(define (display-2 obj port::output-port)
   (%write/display-2 obj port display))

;*---------------------------------------------------------------------*/
;*    write-2 ...                                                      */
;*---------------------------------------------------------------------*/
(define (write-2 obj port::output-port)
   (%write/display-2 obj port write))

;*---------------------------------------------------------------------*/
;*    display-symbol ...                                               */
;*---------------------------------------------------------------------*/
(define (display-symbol obj port)
   (display-string (symbol->string! obj) port))

;*---------------------------------------------------------------------*/
;*    write-symbol ...                                                 */
;*---------------------------------------------------------------------*/
(define (write-symbol obj port)
   (let* ((str (symbol->string obj))
	  (len (string-length str)))
      (define (wrt)
	 (display-string "|" port)
	 (display-string (string-for-read str) port)
	 (display-string "|" port))
      (let loop ((i 0))
	 (if (=fx i len)
	     (display-string str port)
	     (let ((c (string-ref str i)))
		(case c
		   ((#\Space #\Newline #\Tab #\Return #\' #\" #\# #\\)
		    (wrt))
		   (else
		    (if (char>=? c #a127)
			(wrt)
			(loop (+fx i 1))))))))))

;*---------------------------------------------------------------------*/
;*    display-string ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (display-string obj port)
   ($display-string obj port))

;*---------------------------------------------------------------------*/
;*    display-substring ...                                            */
;*---------------------------------------------------------------------*/
(define-inline (display-substring obj start end port)
   (if (and (>=fx end start)
	    (string-bound-check? end (+fx (string-length obj) 1))
	    (>=fx start 0))
       ($display-substring obj start end port)
       (error 'display-substring
	      (format "Illegal index, start=~a end=~a" start end)
	      obj)))

;*---------------------------------------------------------------------*/
;*    write-string ...                                                 */
;*---------------------------------------------------------------------*/
(define (write-string obj port)
   (if (bigloo-strict-r5rs-strings)
       (multiple-value-bind (str esc)
	  (string-for-read obj)
	  ($write-string str esc port))
       ($write-string (string-for-read obj) #f port)))

;*---------------------------------------------------------------------*/
;*    display-keyword ...                                              */
;*---------------------------------------------------------------------*/
(define (display-keyword obj port)
   ($display-char #\: port)
   (display-string (keyword->string! obj) port))

;*---------------------------------------------------------------------*/
;*    display-fixnum ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (display-fixnum obj port)
   ($display-fixnum obj port))

;*---------------------------------------------------------------------*/
;*    display-flonum ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (display-flonum obj port)
   (display-string (real->string obj) port))

;*---------------------------------------------------------------------*/
;*    display-ucs2string ...                                           */
;*---------------------------------------------------------------------*/
(define (display-ucs2string obj port)
   ($display-ucs2string obj port))

;*---------------------------------------------------------------------*/
;*    write-ucs2string ...                                             */
;*---------------------------------------------------------------------*/
(define (write-ucs2string obj port)
   ($write-utf8string (string-for-read (ucs2-string->utf8-string obj))
		      port))

;*---------------------------------------------------------------------*/
;*    display-date ...                                                 */
;*---------------------------------------------------------------------*/
(define (display-date obj port)
   (display-string (date->string obj) port))
   
;*---------------------------------------------------------------------*/
;*    write-date ...                                                   */
;*---------------------------------------------------------------------*/
(define (write-date obj port)
   (display-string "#<date:" port)
   (display-string (date->string obj) port)
   (display-string ">" port))

;*---------------------------------------------------------------------*/
;*    write-mutex ...                                                  */
;*---------------------------------------------------------------------*/
(define (write-mutex obj port)
   (display-string "#<mutex:" port)
   (display (mutex-name obj) port)
   (display-string ">" port))

;*---------------------------------------------------------------------*/
;*    write-condition-variable ...                                     */
;*---------------------------------------------------------------------*/
(define (write-condition-variable obj port)
   (display-string "#<condition-variable:" port)
   (display (condition-variable-name obj) port)
   (display-string ">" port))
 
;*---------------------------------------------------------------------*/
;*    write-class ...                                                  */
;*---------------------------------------------------------------------*/
(define (write-class obj port)
   (display-string "#<class:" port)
   (display-symbol (class-name obj) port)
   (display-string ">" port))
   
;*---------------------------------------------------------------------*/
;*    write/display-cell ...                                           */
;*---------------------------------------------------------------------*/
(define (write/display-cell obj port disp)
   (display-string "#<cell:" port)
   (disp (cell-ref obj) port)
   (display-string ">" port))

;*---------------------------------------------------------------------*/
;*    write/display-structure ...                                      */
;*---------------------------------------------------------------------*/
(define (write/display-structure obj port disp)
   ($display-char #\# port)
   ($display-char #\{ port)
   (disp (struct-key obj) port)
   (if (=fx 0 (struct-length obj))
       ($display-char #\} port)
       (let ((len (-fx (struct-length obj) 1)))
	  ($display-char #\space port)
	  (let loop ((i 0))
	     (cond
		((=fx i len)
		 (disp (struct-ref obj i) port)
		 ($display-char #\} port))
		(else
		 (disp (struct-ref obj i) port)
		 ($display-char #\space port)
		 (loop (+fx 1 i))))))))

;*---------------------------------------------------------------------*/
;*    write/display-vector ...                                         */
;*---------------------------------------------------------------------*/
(define (write/display-vector obj port disp)
   ($display-char #\# port)
   (let ((tag (vector-tag obj)))
      (if (>fx tag 0)
	  (begin
	     (if (>=fx tag 100)
		 (disp tag port)
		 (begin
		    ($display-char #\0 port)
		    (if (>=fx tag 10)
			(disp tag port)
			(begin
			   ($display-char #\0 port)
			   (disp tag port))))))))
   ($display-char #\( port)
   (if (=fx 0 (vector-length obj))
       ($display-char #\) port)
       (let ((len (-fx (vector-length obj) 1)))
	  (let loop ((i 0))
	     (cond
		((=fx i len)
		 (disp (vector-ref obj i) port)
		 ($display-char #\) port))
		(else
		 (disp (vector-ref obj i) port)
		 ($display-char #\space port)
		 (loop (+fx 1 i))))))))
 
;*---------------------------------------------------------------------*/
;*    write/display-tvector ...                                        */
;*---------------------------------------------------------------------*/
(define (write/display-tvector tvec port disp)
   (let ((tvector-ref (tvector-ref tvec))
	 (id (tvector-id tvec)))
      ($display-char #\# port)
      (disp id port)
      ($display-char #\( port)
      (if (not tvector-ref)
	  (begin
	     (display-string "...)" port)
	     tvec)
	  (begin
	     (if (=fx 0 (tvector-length tvec))
		 ($display-char #\) port)
		 (let ((len (-fx (tvector-length tvec) 1)))
		    (let loop ((i 0))
		       (cond
			  ((=fx i len)
			   (disp (tvector-ref tvec i) port)
			   ($display-char #\) port))
			  (else
			   (disp (tvector-ref tvec i) port)
			   ($display-char #\space port)
			   (loop (+fx 1 i)))))))))))

;*---------------------------------------------------------------------*/
;*    %write/display-pair ...                                          */
;*---------------------------------------------------------------------*/
(define-macro (%write/display-pair obj port disp)
   `(begin
       ($display-char #\( ,port)
       (let loop ((l ,obj))
	  (cond
	     ((null? (cdr l))
	      (,disp (car l) ,port)
	      ($display-char #\) ,port))
	     ((not (pair? (cdr l)))
	      (,disp (car l) ,port)
	      ($display-char #\space ,port)
	      ($display-char #\. ,port)
	      ($display-char #\space ,port)
	      (,disp (cdr l) ,port)
	      ($display-char #\) ,port))
	     (else
	      (,disp (car l) ,port)
	      ($display-char #\space ,port)
	      (loop (cdr l)))))))

;*---------------------------------------------------------------------*/
;*    display-pair ...                                                 */
;*---------------------------------------------------------------------*/
(define (display-pair obj port)
   (%write/display-pair obj port display-2))

;*---------------------------------------------------------------------*/
;*    write-pair ...                                                   */
;*---------------------------------------------------------------------*/
(define (write-pair obj port)
   (%write/display-pair obj port write-2))

