/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Clib/cinit-obj.c             */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Jan 29 09:19:48 2002                          */
/*    Last change :  Sat Jun 17 09:30:47 2006 (serrano)                */
/*    Copyright   :  2002-06 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    Bootstrap of pre-allocated objects.                              */
/*=====================================================================*/
#include <stdio.h>
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    Les objects vitaux ...                                           */
/*---------------------------------------------------------------------*/
obj_t an_object;

obj_t quote;
obj_t *c_allocated_char;
BGL_RUNTIME_DEF obj_t _exit_value_;

obj_t bprof_port = BUNSPEC;

BGL_RUNTIME_DEF header_t bgl_opaque_nil = MAKE_HEADER( OPAQUE_TYPE, 0 );

/*---------------------------------------------------------------------*/
/*    Global mutex                                                     */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF obj_t bigloo_mutex = BUNSPEC;
DEFINE_STRING( bigloo_mutex_name, _1, "bigloo-mutex", 12 );

BGL_RUNTIME_DEF obj_t bigloo_socket_mutex = BUNSPEC;
DEFINE_STRING( bigloo_socket_mutex_name, _2, "socket-mutex", 12 );

/*---------------------------------------------------------------------*/
/*    Importations                                                     */
/*---------------------------------------------------------------------*/
extern obj_t string_to_obj();
extern void bgl_init_dynamic_env();
extern void bgl_init_symbol_table();
extern void bgl_init_signal();
extern void bgl_init_keyword_table();
extern void bgl_init_io();
extern void bgl_init_trace();
extern void bgl_init_process_table();
extern void bgl_init_dload();

/*---------------------------------------------------------------------*/
/*    init_objects ...                                                 */
/*---------------------------------------------------------------------*/
void bgl_init_objects() {
   bgl_init_dynamic_env();
   bgl_init_trace();
   bgl_init_symbol_table();
   bgl_init_signal();
   bgl_init_io();
   bgl_init_keyword_table();
   bgl_init_process_table();
   bgl_init_dload();

   bigloo_mutex = bgl_make_mutex( bigloo_mutex_name );
   bigloo_socket_mutex = bgl_make_mutex( bigloo_socket_mutex_name );
   quote = string_to_symbol( "QUOTE" );
}
