/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Jlib/stack_trace.java        */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Mon Dec 11 12:49:28 2000                          */
/*    Last change :  Fri Jul  6 15:40:17 2001 (serrano)                */
/*    Copyright   :  2000-01 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    Stack trace JVM implementation                                   */
/*=====================================================================*/
package bigloo;
import java.io.*;

/*---------------------------------------------------------------------*/
/*    STACK_TRACE                                                      */
/*    -------------------------------------------------------------    */
/*    This class is only used for debugging purpose. It enables        */
/*    error handlers to display the current Scheme stack when an       */
/*    error is raised.                                                 */
/*---------------------------------------------------------------------*/
public class stack_trace {
    public static stack_trace top_of_stack = null;
    Object symbol;
    stack_trace link;

    public stack_trace( Object s ) {
	symbol = s;
	link = top_of_stack;
	top_of_stack = this;
    }

    public static Object pop_trace() {
	top_of_stack = top_of_stack.link;
	return( unspecified.unspecified );
    }

    public static Object dump( output_port port, int depth ) 
	throws IOException {
	stack_trace runner = top_of_stack;
	int recursion = 0;
	int level = 0;
	Object old = null;

	while( (level < depth) && (runner != null) ) {
	    if( bigloo.foreign.SYMBOLP( runner.symbol ) ) {
		if( (runner.symbol == old) ) {
		    recursion++;
		    depth++;
		} else {
		    if( recursion > 0 ) {
			port.write( " (%" );
			port.write( Integer.toString( 1 + recursion ) );
			port.write( " times)" );
			port.write( "\n" );
		    } else {
			if( level > 0 )
			    port.write( "\n" );
		    }
	    
		    port.write( "  " );
		    port.write( Integer.toString( level ) );
		    port.write( ". " );
		    port.write( ((symbol)(runner.symbol)).string );
		    recursion = 0;
		}

		old = runner.symbol;
		level++; 
	    }
	  
	    runner = runner.link;
	}
	port.write( "\n" );
       
	return(unspecified.unspecified);
    }
}
