/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Jlib/server_socket.java      */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Dec  5 10:53:03 2000                          */
/*    Last change :  Sat Jul 14 06:53:01 2001 (serrano)                */
/*    Copyright   :  2000-01 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    The Server Socket implementation for the JVM back-end.           */
/*=====================================================================*/
package bigloo;

import java.io.*;
import java.net.*;

/*---------------------------------------------------------------------*/
/*    SOCKET ...                                                       */
/*---------------------------------------------------------------------*/
public class server_socket extends socket {
/*--- public fields ---------------------------------------------------*/
    ServerSocket socket;

/*--- constructors ----------------------------------------------------*/
    public server_socket( int port ) {
	super();

	try {
	    socket = new ServerSocket( port );
	} 
	catch( IOException e ) {
	    socket_error( "make-server-socket", 
			  "cannot create socket", 
			  new bint( port ) );
	}
    }

/*--- private methods -------------------------------------------------*/
    protected void socket_error( String s1, String s2, Object o ) {
	foreign.fail( s1, s2, o );
    }

    protected void set_socket_io_ports( Socket client, boolean b ) 
	throws IOException {
	input = new input_socket_port( client.getInputStream(), b );
	output = new output_port( client.getOutputStream() );
    }

/*--- public methods --------------------------------------------------*/
    public byte[] HOSTNAME() {
	return socket.getInetAddress().getHostName().getBytes();
    }

    public byte[] HOSTIP() {
	return socket.getInetAddress().getAddress();
    }
   
    public Object accept_connection( boolean b ) 
	throws IOException, SecurityException {
	Socket client = socket.accept();
	set_socket_io_ports( client, b );
	    
	return bigloo.foreign.BUNSPEC;
    }

    public Object shutdown(boolean close_socket) throws IOException {
	socket.close();
	down = true;
	return bigloo.foreign.BUNSPEC;
    }

    public int PORT() {
	return socket.getLocalPort();
    }
}
