;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Eval/expdargs.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Apr  1 06:28:06 2000                          */
;*    Last change :  Wed Nov 28 09:56:59 2001 (serrano)                */
;*    Copyright   :  2001 Manuel Serrano                               */
;*    -------------------------------------------------------------    */
;*    args-parse expansion.                                            */
;*    -------------------------------------------------------------    */
;*    Source documentation:                                            */
;*       @path ../../manuals/cmdline.texi@                             */
;*       @node Command Line Parsing@                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __expander_args
   
   (import  __error
	    __bigloo
	    __tvector
	    __structure
	    __tvector
	    __bexit
	    
	    __match_normalize
	     
	    __r4_numbers_6_5
	    __r4_numbers_6_5_fixnum
	    __r4_numbers_6_5_flonum
	    __r4_characters_6_6
	    __r4_equivalence_6_2
	    __r4_booleans_6_1
	    __r4_symbols_6_4
	    __r4_strings_6_7
	    __r4_pairs_and_lists_6_3
	    __r4_input_6_10_2
	    __r4_control_features_6_9
	    __r4_vectors_6_8
	    __r4_ports_6_10_1
	    __r4_output_6_10_3
	    
	    __progn)
   
   (use     __type
	    __evenv
	    __bit)
   
   (export  (expand-args-parse x e)))

;*---------------------------------------------------------------------*/
;*    args-case ...                                                    */
;*---------------------------------------------------------------------*/
(define (expand-args-parse x e)
   ;; produce compile-time (expand-time) errors
   (define (expand-time-error)
      (error "args-case" "Illegal `args-case' syntax" x))
   (define (expand-time-error-clause clause)
      (error "args-case" "Illegal `args-case' clause" clause))
   ;; we parse the arguments of the macro
   (match-case x
      ((?- ?exp . ?src-clauses)
       (let* ((args           (gensym 'argv))
	      (a-runner       (gensym 'runner))
	      (bstring        (string->symbol "::bstring"))
	      (arg            (gensym 'arg))
	      (a-arg          (gensym 'arg))
	      (a-loop         (gensym 'loop))
	      (a-done         (gensym 'done))
	      (ill-opt        'args-parse-error)
	      (usage          'args-parse-usage)
	      (option-marker1 (gensym 'parse-args))
	      (option-marker2 (gensym 'parse-args))
	      (mark-option!   (lambda (str mode)
				 (case mode
				    ((1)
				     (putprop! (string->symbol str)
					       option-marker1
					       #t))
				    (else
				     (putprop! (string->symbol str)
					       option-marker2
					       #t)))))
	      (marked-option? (lambda (str mode)
				 (case mode
				    ((1)
				     (getprop (string->symbol str)
					      option-marker1))
				    (else
				     (getprop (string->symbol str)
					      option-marker2)))))
	      (bind-option    (lambda (opt mode)
				 (if (marked-option? opt mode)
				     (warning
				      "parse-args"
				      "Option overriding (ignoring) -- "
				      opt)
				     (mark-option! opt mode)))))
	  ;; checks an option arguments list in order to see
	  ;; if all are symbols beginning with #\?. If they are return
	  ;; the symbol-sans-? list otherwise return #f.
	  (define (get-opt-args-name-list args)
	     (let loop ((args args)
			(res  '()))
		(cond
		   ((null? args)
		    (reverse! res))
		   ((symbol? (car args))
		    (let* ((str (symbol->string (car args)))
			   (len (string-length str)))
		       (if (or (=fx (string-length str) 0)
			       (not (char=? (string-ref str 0) #\?)))
			   #f
			   (loop (cdr args)
				 (cons (string->symbol
					(substring str 1 len))
				       res)))))
		   (else
		    #f))))
	  ;; extract the argument of a line (?top ??args (synopsis))
	  (define (get-args runner end)
	     (let loop ((runner runner)
			(res    '()))
		(if (or (null? runner)
			(eq? (car runner) end))
		    (reverse! res)
		    (loop (cdr runner)
			  (cons (car runner) res)))))
	  ;; extract argument name from an option name (i.e. -I?dir)
	  (define (get-opt-arg-name-one opt)
	     (let ((len (-fx (string-length opt) 1)))
		(let loop ((i 0))
		   (cond
		      ((>=fx i len)
		       #f)
		      ((char=? (string-ref opt i) #\?)
		       (cons (substring opt 0 i)
			     (substring opt (+fx 1 i) (+fx len 1))))
		      (else
		       (loop (+fx i 1)))))))
	  ;; let-binding, a variable destructuration
	  (define (let-binding larg arg)
	     (let loop ((larg   larg)
			(access `(cdr ,arg))
			(res    '()))
		(if (null? larg)
		    (cons access (reverse! res))
		    (loop (cdr larg)
			  `(cdr ,access)
			  (cons (list (car larg)
				      `(car ,access)) res)))))
	  ;; make synopsis name when no specified
	  (define (make-synopsis-name opt args::pair-nil clause::pair)
	     (let* ((opt (if (string? opt)
			     opt
			     (let rec ((opt opt))
				(if (null? (cdr opt))
				    (car opt)
				    (string-append (car opt)
						   ","
						   (rec (cdr opt)))))))
		    (oarg (get-opt-arg-name-one opt))
		    (larg (get-opt-args-name-list args)))
		(cond
		   ((and oarg (pair? larg))
		    (expand-time-error-clause clause))
		   ((not (or oarg (pair? larg)))
		    opt)
		   (oarg
		    (let* ((opt-name (car oarg))
			   (opt-arg  (cdr oarg)))
		       (string-append opt-name "<" opt-arg ">")))
		   (else
		    (string-append
		     opt
		     (let loop ((larg larg))
			(if (null? larg)
			    ""
			    (string-append " <"
					   (string-downcase
					    (symbol->string
					     (car larg)))
					   ">"
					   (loop (cdr larg))))))))))
	  ;; make one args-case clause
	  (define (make-clause clause::pair opt::bstring args::pair-nil actions::pair-nil)
	     (let ((oarg (get-opt-arg-name-one opt))
		   (larg (get-opt-args-name-list args)))
		(cond
		   ((and oarg (pair? larg))
		    (expand-time-error-clause clause))
		   ((not (or oarg (pair? larg)))
		    (bind-option opt 1)
		    `((string=? ,arg ,opt)
		      (let* ((the-args  ,a-runner)
			     (the-remaining-args (cdr ,a-runner))
			     (action (begin ,@actions)))
			 (,a-loop the-remaining-args
				  action))))
		   (oarg
		    (let* ((opt-name (car oarg))
			   (opt-len  (string-length opt-name))
			   (opt-arg  (cdr oarg))
			   (opt-sarg (string->symbol opt-arg)))
		       (bind-option opt-name 2)
		       `((and (>=fx (string-length ,arg) ,opt-len)
			      (string=? (substring ,arg 0 ,opt-len)
					,opt-name))
			 (let* ((,opt-sarg (substring ,arg
						      ,opt-len
						      (string-length ,arg)))
				(the-args  ,a-runner)
				(the-remaining-args (cdr ,a-runner))
				(action (begin ,@actions)))
			    (,a-loop the-remaining-args
				     action)))))
		   (else
		    (bind-option opt 1)
		    (let ((next&bdg (let-binding larg a-runner)))
		       `((string=? ,arg ,opt)
			 (let ,(cdr next&bdg)
			    (let* ((the-args ,a-runner)
				   (the-remaining-args ,(car next&bdg))
				   (action (begin ,@actions)))
			       (,a-loop the-remaining-args
					action)))))))))
	  ;; the main job
	  (let loop ((runner  src-clauses)
		     (clauses '())
		     (descrs  '())
		     (else    #f))
	     (if (null? runner)
		 (e `(let* ((,args    ,exp)
			    (,ill-opt (lambda (culprit) 
					 (error "Illegal option"
						"see `-help' option"
						culprit)))
			    (,usage   ,(make-usage-body descrs)))
			(cond
			   ((and (not (pair? ,args))
				 (not (null? ,args)))
			    (,ill-opt ,args))
			   (else
			    (let ((,a-arg ,args))
			       (try
				(let ,a-loop ((,a-runner ,args)
					      (,a-done   #f))
				     (cond
					((null? ,a-runner)
					 'parsing-done)
					((eq? ,a-done 'usage-done)
					 ,a-done)
					((not (pair? ,a-runner))
					 (,ill-opt ,a-runner))
					(else
					 (let* ((,(symbol-append arg bstring)
						 (car ,a-runner))
						(the-arg::bstring ,arg))
					    (set! ,a-arg ,a-runner)
					    (cond
					       ,@(reverse! clauses)
					       (else
						(let ((else ,arg))
						   (,a-loop
						    (cdr ,a-runner)
						    ,(if (pair? else)
							 `(begin ,@else)
							 `(,ill-opt
							   ,a-runner))))))))))
				(lambda (esc proc mes obj)
				   (,ill-opt ,a-arg)))))))
		    e)
		 (let ((run (car runner)))
		    (match-case run
		       ((section ?section)
			;; (section section)
			(if (not (string? section))
			    (expand-time-error-clause run)
			    (loop (cdr runner)
				  clauses
				  (cons (cons 'section section) descrs)
				  #f)))
		       ((else . ?actions)
			;; (else act1 act2...)
			(if (null? (cdr runner))
			    (loop (cdr runner)
				  clauses
				  descrs
				  actions)
			    (expand-time-error-clause run)))
		       ((?option . ?actions)
			;; (option act1 act2 ...)
			(let* ((option
				(let ((o (e option e)))
				   (if (pair? o)
				       o
				       (expand-time-error-clause run))))
			       (opt (car option)))
			   (cond
			      ((not (or (string? opt)
					(and (list? opt)
					     (let loop ((opt opt))
						(cond
						   ((null? opt)
						    #t)
						   ((string? (car opt))
						    (loop (cdr opt)))
						   (else
						    #f))))))
			       (expand-time-error-clause run))
			      ((null? (cdr option))
			       (let ((args (get-args (cdr (car run)) '())))
				  (if (pair? opt)
				      (loop (cdr runner)
					    (append (map (lambda (o)
							    (make-clause run
									 o
									 args
									 actions))
							 opt)
						    clauses)
					    descrs
					    #f)
				      (loop (cdr runner)
					    (cons (make-clause run opt args actions)
						  clauses)
					    descrs
					    #f))))
			      (else
			       (let ((syn (car (last-pair option))))
				  (match-case syn
				     ((?synopsis ?name ?msg)
				      ;; (?opt ?args (synopsis ?name ?descr))
				      (if (not (synopsis? synopsis))
					  (expand-time-error-clause run)
					  (let ((args (get-args (cdr option) syn)))
					     (if (pair? opt)
						 (loop (cdr runner)
						       (append (map (lambda (o)
								       (make-clause run (car opt)
										    args actions))
								    opt)
							       clauses)
						       (cons (cons name msg) descrs)
						       #f)
						 (loop (cdr runner)
						       (cons (make-clause run opt args actions)
							     clauses)
						       (cons (cons name msg) descrs)
						       #f)))))
				     ((?synopsis ?msg)
				      ;; (?opt ?args (synopsis ?descr))
				      (if (not (synopsis? synopsis))
					  (expand-time-error-clause run)
					  (let ((args (get-args (cdr option) syn)))
					     (if (pair? opt)
						 (loop (cdr runner)
						       (append (map (lambda (o)
								       (make-clause run o args actions))
								    opt)
							       clauses)
						       (cons (cons
							      (make-synopsis-name opt args run)
							      msg)
							     descrs)
						       #f)
						 (loop (cdr runner)
						       (cons (make-clause run opt args actions)
							     clauses)
						       (cons (cons
							      (make-synopsis-name opt args run)
							      msg)
							     descrs)
						       #f)))))
				     (else
				      ;; (?opt ?args)
				      (let ((args (get-args (cdr (car run)) '())))
					 (if (pair? opt)
					     (loop (cdr runner)
						   (append (map (lambda (o)
								   (make-clause run o args actions))
								opt)
							   clauses)
						   descrs
						   #f)
					     (loop (cdr runner)
						   (cons (make-clause run opt args actions)
							 clauses)
						   descrs
						   #f))))))))))
		       (else
			(expand-time-error-clause run))))))))
      (else
       (expand-time-error))))

;*---------------------------------------------------------------------*/
;*    make-usage-body ...                                              */
;*---------------------------------------------------------------------*/
(define (make-usage-body descrs)
   (let ((descrs (list 'quasiquote
		       (reverse
			(map
			 (lambda (opt)
			    (cons (car opt) (list 'unquote (cdr opt))))
			 descrs))))
	 (descrs-sym (gensym 'descrs))
	 (mlen-sym   (gensym 'mlen)))
      `(lambda (manual?)
	  (if manual? (print "("))
	  (let ((,descrs-sym ,descrs)
		(,mlen-sym 0))
	     (for-each
	      (lambda (opt)
		 (let ((name(car opt)))
		    (cond ((string? name)
			   (let ((len (string-length name)))
			      (if (>fx len ,mlen-sym)
				  (set! ,mlen-sym len)))))))
	      ,descrs-sym)
	     (for-each
	      (lambda (opt)
		 (let ((name (car opt)))
		    (cond
		       ((string? name)
			(let* ((name (car opt))
			       (len  (string-length name))
			       (desc (cdr opt))
			       (tab  (make-string (-fx ,mlen-sym len)
						  #\space)))
			   (if manual?
			       (begin
				  (write `(,name ,desc))
				  (newline))
			       (print "   " name tab " --  " desc))))
		       ((eq? name 'section)
			(print #\Newline (cdr opt) ":")))))
	      ,descrs-sym)
	     'usage-done)
	  (if manual? (print ")")))))

;*---------------------------------------------------------------------*/
;*    synopsis? ...                                                    */
;*---------------------------------------------------------------------*/
(define (synopsis? sym)
   (or (eq? sym 'help) (eq? sym 'synopsis)))
