;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Engine/engine.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 17 10:13:23 1993                          */
;*    Last change :  Mon May 15 07:42:19 2000 (serrano)                */
;*    Copyright   :  1993-2000 Manuel Serrano, see LICENSE file        */
;*    -------------------------------------------------------------    */
;*    The system's engine (some kind of dispatcher between the linker, */
;*    the interpreter and the compiler).                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module engine_engine
   (export (engine)
	   (hello-world))
   (import tools_speek
	   tools_trace
	   tools_error
	   write_version
           engine_param
	   engine_compiler
	   engine_interp
	   engine_link))

;*---------------------------------------------------------------------*/
;*    engine ...                                                       */
;*---------------------------------------------------------------------*/
(define (engine)
   (cond
      ((and (pair? *src-files*) (not *interpreter*))
       (profile comp (compiler)))
      ((pair? *c-files*)
       (if (pair? (cdr *c-files*))
	   (user-warning "engine" "Ignoring addition files" (cdr *c-files*)))
       (set! *rm-c-files* #f)
       (profile ccomp (cc-compiler (prefix (car *c-files*)))))
      ((null? *o-files*)
       (profile interp (interp version
			       *verbose*
			       *src-files*
			       *startup-file*
			       (string-append (car *lib-dir*) "/scheme-files")
			       *bigloo-args*)))
      (else
       (link))))

;*---------------------------------------------------------------------*/
;*    hello-world ...                                                  */
;*---------------------------------------------------------------------*/
(define (hello-world)
   ;; aller, on dit bonjour
   (if *hello*
       (let loop ((src (reverse! *src-files*))
		  (str ""))
	  (if (null? src)
	      (begin
		 (string-set! str (-fx (string-length str) 1) #\:)
		 (verbose 0 str #\Newline))
	      (loop (cdr src) (string-append (car src) " " str))))))
