;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Effect/walk.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jul 13 10:25:23 1995                          */
;*    Last change :  Mon May 15 07:41:56 2000 (serrano)                */
;*    Copyright   :  1995-2000 Manuel Serrano, see LICENSE file        */
;*    -------------------------------------------------------------    */
;*    The computation of the effect property.                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module effect_walk
   (include "Engine/pass.sch"
	    "Tools/trace.sch")
   (import  tools_error
	    type_type
	    ast_var
	    ast_node
	    effect_cgraph
	    effect_spread)
   (export  (effect-walk! globals)))

;*---------------------------------------------------------------------*/
;*    effect-walk! ...                                                 */
;*---------------------------------------------------------------------*/
(define (effect-walk! globals)
   (pass-prelude "Effect")
   ;; we compute the inversed call-graph
   (trace effect "cgraph..." #\Newline)
   (for-each (lambda (global)
		(fun-call-graph! global))
	     globals)
   ;; then we iterate to mark all function/side-effect
   (trace effect "fix point..." #\Newline)
   (iterate-to-fix-point! (get-var/side-effect))
   ;; we mark function which are known to not make side effect
   (for-each (lambda (var)
		(let ((fun (variable-value var)))
		   (if (eq? (fun-side-effect? fun) #unspecified)
		       (fun-side-effect?-set! fun #f))))
	     (get-var/all))
   ;; we spread the effect properties
   (trace effect "spread..." #\Newline)
   (for-each (lambda (global)
		(spread-side-effect! (sfun-body (global-value global))))
	     globals)
   ;; we are done now.
   (trace effect "Effect done." #\Newline)
   (pass-postlude globals reset-effect-tables!))
	   
;*---------------------------------------------------------------------*/
;*    iterate-to-fix-point! ...                                        */
;*---------------------------------------------------------------------*/
(define (iterate-to-fix-point! W)
   (if (null? W)
       'done
       (for-each
	(lambda (var)
	   (let ((fun (variable-value var)))
	      (if (not (eq? (fun-side-effect? fun) #t))
		  (begin
		     (fun-side-effect?-set! fun #t)
		     (cond
			((local/from? var)
			 (iterate-to-fix-point! (local/from-from var)))
			((global/from? var)
			 (iterate-to-fix-point! (global/from-from var))))))))
	W)))

					
