;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Cc/exec.scm                 */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Apr 29 09:09:34 1995                          */
;*    Last change :  Fri Dec 29 09:36:06 2000 (serrano)                */
;*    Copyright   :  1995-2000 Manuel Serrano, see LICENSE file        */
;*    -------------------------------------------------------------    */
;*    When we don't need to make any action after invoking the C       */
;*    compiler (i.e. when the C compiler is called in a tail           */
;*    call position), rather than invoking it with the `system'        */
;*    we use the `execp' command. This module implements a             */
;*    private version of `exec' which take  parameters that            */
;*    tells if the command must return or not.                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cc_exec
   (include "Tools/trace.sch")
   (extern  (macro execl::int (::string ::string ::string ::string ::long)
		   "execl"))
   (import  tools_error
	    engine_param
	    init_main)
   (export  (exec ::bstring ::bool ::bstring)))

;*---------------------------------------------------------------------*/
;*    exec-fname ...                                                   */
;*---------------------------------------------------------------------*/
(define (exec-fname)
   "$myselfx1001")

;*---------------------------------------------------------------------*/
;*    exec ...                                                         */
;*---------------------------------------------------------------------*/
(define (exec cmd flag name)
   (if (or flag (not (string? *shell*)))
       (begin
	  (trace cc "system: " cmd #\Newline)
	  (let ((res (system cmd)))
	     (if (not (=fx res 0))
		 (exit-bigloo 1)
		 res)))
       (begin
	  (trace cc "system/kill: " cmd #\Newline)
	  (system/kill cmd))))

;*---------------------------------------------------------------------*/
;*    system/kill ...                                                  */
;*---------------------------------------------------------------------*/
(define (system/kill cmd)
   (cond-expand
      (bigloo-jvm (system cmd))
      (bigloo-c (print (execl *shell* *shell* "-c" cmd 0))))
   (internal-error "system/kill" "Can't execute cmd" cmd))
 
   


