;*=====================================================================*/
;*    serrano/prgm/project/ude/ude/ude-paren.el                        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Nov 12 21:15:52 1998                          */
;*    Last change :  Sun Nov 22 07:41:46 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Ude paren handling                                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'ude-paren)
(require 'mic-paren)

;*---------------------------------------------------------------------*/
;*    ude-paren-initialized-p ...                                      */
;*---------------------------------------------------------------------*/
(defvar ude-paren-initialized-p nil)

;*---------------------------------------------------------------------*/
;*    ude-paren-init ...                                               */
;*---------------------------------------------------------------------*/
(defun ude-paren-init ()
  (if (not ude-paren-initialized-p)
      (progn
	(setq ude-paren-initialized-p t)
	(setq paren-delay nil)
	(setq paren-face
	      (if (and (fboundp 'x-display-color-p)
		       (x-display-color-p))
		  (let ((fn 'paren-face))
		    (copy-face 'default fn)
		    (set-face-background fn "green")
		    fn)
		'modeline))
	(setq paren-mismatch-face
	      (if (and (fboundp 'x-display-color-p)
		       (x-display-color-p))
		  (let ((fn 'paren-mismatch-face))
		    (copy-face 'default fn)
		    (set-face-background fn "red")
		    fn)
		'modeline))
	(setq paren-no-match-face
	      (if (x-display-color-p)
		  (let ((fn 'paren-no-match-face))
		    (copy-face 'default fn)
		    (set-face-background fn "darkorange1")
		    fn)
		'default)))))


	 
