;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bmacs/bee/bee-flock.el               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon May 25 08:00:32 1998                          */
;*    Last change :  Mon Mar 26 13:06:50 2001 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The Bee font-lockification                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'bee-flock)
(require 'ude-config)
(require 'ude-custom)
(require 'ude-autoload)

;*---------------------------------------------------------------------*/
;*    bee font-lock regexps ...                                        */
;*---------------------------------------------------------------------*/
(defvar bee-font-lock-keywords
  (list
   (list (concat "^\(\\(\\(?:define\\|define-inline\\|define-struct"
		 "\\|define-macro\\|define-generic\\|define-method"
		 "\\|define-syntax\\|define-expander\\|define-record-type"
		 "\\|define-command\\)[ ]+\\(\(.*\)\\|[^ \n]+\\)\\)[ \n]")
	 1
	 'font-lock-function-name-face)
   (list "\(\\(\\(?:module\\|directives\\)[ ]+[^ \n]+\\)[ \t\n]"
         1
	 'ude-font-lock-face-1)
   (cons "\\(?:::[^ \n)]+\\|#![a-zA-Z]+\\)"
	 'ude-font-lock-face-4)
   (list (concat "\(\\(type\\|export\\|import\\|option\\|eval\\|main"
		 "\\|from\\|static\\|use\\|library"
		 "\\|include\\|foreign\\|extern\\|java\\|Cforeign\\)[ \t\n]")
	 1
	 'font-lock-type-face)
   (list (concat "\(\\(class\\|wide-class\\|final-class\\|abstract-class"
		 "\\|generic\\|inline\\|macro\\|infix[ ]macro\\)[ \t\n]")
	 1
	 'ude-font-lock-face-3)
   (list (concat "\(\\(let\\|let[*]\\|letrec\\|co-instantiate\\|define"
		 "\\|set[!]\\|with-access\\|instantiate\\|duplicate"
		 "\\|widen[!]\\|shrink!\\|lambda\\|labels"
		 "\\|let-syntax\\|letrec-syntax"
		 "\\|regular-grammar\\|lalr-grammar"
		 "\\|if\\|begin\\|case\\|cond\\|else"
		 "\\|multiple-value-bind\\|values"
		 "\\|match-case\\|match-lambda\\|event-case\\|on-event"
		 "\\|string-case\\|syntax-rules\\)[ :\n\t]")
	 1
	 'font-lock-keyword-face)
   (cons "\\[assert[^\]]*\\]\\|\(assert[^\)]*\)"
	 'ude-font-lock-face-2)
   (list (concat "\(\\(error\\|warning\\|pragma\\|trace\\|"
		 "bind-exit\\|call/cc\\|try\\|\unwind-protect\\|cond-expand\\|"
		 "profile\\|profile/gc\\|delay\\|force\\)"
		 "[ \n\t:]")
	 1
	 'ude-font-lock-face-2)))

;*---------------------------------------------------------------------*/
;*    bee-font-lock-get-info-keywords ...                              */
;*    -------------------------------------------------------------    */
;*    The Bee font lock keyword list for xinfo.                        */
;*---------------------------------------------------------------------*/
(defun bee-font-lock-get-info-keywords ()
  (append
   (list (cons "^[ ]+- \\(?:essential \\|optional \\|library \\|bigloo \\|[CR][^ ]+ \\)?\\(?:\\(?:rgc \\)?procedure\\|generic\\|variable\\|Name\\|Class\\): .*$"
	       'font-lock-function-name-face)
	 (cons "^ - \\(?:essential \\|library \\|bigloo \\)?syntax: .*$"
	       'ude-font-lock-face-2)
	 (cons "^ - bigloo module clause: .*$"
	       'ude-font-lock-face-3)
	 (cons ":^[*] [^:]+:" 'font-lock-keyword-face)
	 (cons "\\([^=]=>\\|-|\\) .+$" 'ude-italic-face)
	 (cons "^ - bigloo class: .*$"
	       'ude-font-lock-face-4)
	 (cons "`\\([^' ]+\\)'" 'ude-invisible-face)
	 (list "`\\([^' ]+\\)'" 1 'ude-italic-face t)
	 (cons ";;.*$" 'font-lock-comment-face)
	 (cons "\"[^\"]+\"" 'font-lock-string-face))
   bee-font-lock-keywords))
  
;*---------------------------------------------------------------------*/
;*    bee-html-fontify-html-buffer ...                                 */
;*---------------------------------------------------------------------*/
(defun bee-html-fontify-html-buffer ()
  (interactive)
  (ude-html-fontify-html-buffer 'bee-mode
				'(lambda (beg end)
				   (save-excursion
				     (goto-char beg)
				     (looking-at "[ \n\t]*[;(]"))))
  (save-buffer)
  (set-buffer-modified-p nil))
  
