//  appconf.hh for bbappconf - an tool to display new mail in X11.
//
//  this program is free software; you can redistribute it and/or modify
//  it under the terms of the gnu general public license as published by
//  the free software foundation; either version 2 of the license, or
//  (at your option) any later version.
//
//  this program is distributed in the hope that it will be useful,
//  but without any warranty; without even the implied warranty of
//  merchantability or fitness for a particular purpose.  see the
//  gnu general public license for more details.
//
//  you should have received a copy of the gnu general public license
//  along with this program; if not, write to the free software
//  foundation, inc., 675 mass ave, cambridge, ma 02139, usa.
//
// (see the included file copying / gpl-2.0)
//


#ifndef __APPCONF_HH
#define __APPCONF_HH

#include "bbappconf.hh"

class AppConf  {

public:
	AppConf(void);
	~AppConf(void);

	void LoadAppName(char *);
	void LoadAppClass(char *);

  bool getSticky(void) { return sticky;}
  bool getDecorless(void) { return decorless;}
  unsigned int getStartOnDesktop(void) { return start_on_desktop;}
  bool getMaxHoriz(void) { return max_horiz;}
  bool getMaxVert(void) {return max_vert;}
	int getPositionX(void) {return position_x;}
	int getPositionY(void) {return position_y;}
 	int getWidth(void) {return width;}
	int getHeight(void) {return height;}
 
  char *getName(void) { return appname;}
  char *getClass(void) { return appclass;}

  void setSticky(bool _sticky) {sticky=_sticky;}
  void setDecorless(bool _decorless) {decorless=_decorless;}
  void setMaxVert(bool _max_vert) {max_vert=_max_vert;}
  void setMaxHoriz(bool _max_horiz) {max_horiz=_max_horiz;}
  void setStartOnDesktop(unsigned int _start_on_desktop) 
                       {start_on_desktop=_start_on_desktop;}
	void setPositionX(int _position_x) {position_x=_position_x;}
	void setPositionY(int _position_y) {position_y=_position_y;}
	void setWidth(int _width) {width=_width;}
	void setHeight(int _height) {height=_height;}
private:
  
  bool sticky;
  bool decorless;
  bool max_horiz;
  bool max_vert;
  unsigned int start_on_desktop;
	int position_x, position_y;
 	int width, height;
	char *appname;
	char *appclass;
};

#endif /* __APPCONF_H */
