#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# Simple tagging tests
# Copyright © 2003 Colin Walters <walters@verbum.org>
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

setup_with_trivial_archives

test_class "tag baz archives"

begin_test "creating tag from new version"
tla branch jane@example.com--2003/hello-world--mainline--1.0 jane@example.com--2003/hello-world--mainline--1.1
tla get jane@example.com--2003/hello-world--mainline--1.1 hello-world
test -f hello-world/hello-world.c
test -f hello-world/README
end_test 

begin_test "creating tag from new branch"
tla branch jane@example.com--2003/hello-world--mainline--1.0 jane@example.com--2003/hello-world--foobranch--3
tla get jane@example.com--2003/hello-world--foobranch--3 foobranch
test -f foobranch/hello-world.c
test -f foobranch/README
end_test 

begin_test "creating tag from new category"
tla branch jane@example.com--2003/hello-world--mainline--1.0 jane@example.com--2003/hi-world--mainline--1.3
tla get jane@example.com--2003/hi-world--mainline--1.3 hi-world
test -f hi-world/hello-world.c
test -f hi-world/README
end_test 

begin_test "creating tag from different archive"
tla branch jane@example.com--2003/hello-world--mainline--1.0 foo@example.org--2003/hello-world--devo--1.3
tla get foo@example.org--2003/hello-world--devo--1.3 foo-hello-world
test -f foo-hello-world/hello-world.c
test -f foo-hello-world/README
test -f $(tla whereis-archive foo@example.org--2003|sed s/cached://)/hello-world--devo--1.3/base-0/ancestry.gz || test_fail "Missing ancestry data file"
test -f $(tla whereis-archive foo@example.org--2003|sed s/cached://)/hello-world--devo--1.3/base-0/ancestry.gz.checksum || test_fail "Missing ancestry checksum"
test "$(gunzip -c $(tla whereis-archive foo@example.org--2003|sed s/cached://)/hello-world--devo--1.3/base-0/ancestry.gz)" = "$(echo -e 'arch ancestry version 1\narch:patch:foo@example.org--2003/hello-world--devo--1.3--base-0\narch:patch:jane@example.com--2003/hello-world--mainline--1.0--base-0')" 
end_test 

clean_workdir
