/* cmdutils.h:
 *
 ****************************************************************
 * Copyright (C) 2004 Tom Lord
 * 
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__LIBARCH__CMDUTILS_H
#define INCLUDE__LIBARCH__CMDUTILS_H

#include "libarch/namespace.h"
#include "libarch/archive.h"

#if !defined(__GNUC__)
#  undef __attribute__
#  define __attribute__(X)
#endif

extern t_uchar * arch_fqrvsn_from_tree_and_input (t_uchar *cmd,
                                                  t_uchar * string,
                                                  t_uchar * dir);
extern void arch_check_for (struct arch_archive * arch,
                            enum arch_valid_package_name_types type,
                            t_uchar * package);
extern void arch_print_missing (struct arch_archive * arch,
                                enum arch_valid_package_name_types type,
                                enum arch_valid_package_name_types supplied_type,
                                t_uchar * spec);
extern void arch_check_library_for_revision (t_uchar * archive,
                                             t_uchar * revision);
extern t_uchar * arch_determine_fqrevision_next (struct arch_archive ** arch,
                                          t_uchar * default_archive,
                                          t_uchar * revision_spec,
                                          t_uchar * cmd_name);
extern t_uchar * arch_determine_fqrevision (struct arch_archive ** arch,
                                          t_uchar * default_archive,
                                          t_uchar * revision_spec,
                                          t_uchar * cmd_name);
extern t_uchar * arch_determine_revision (struct arch_archive ** arch,
                                          t_uchar * default_archive,
                                          t_uchar * revision_spec,
                                          t_uchar * cmd_name);
extern t_uchar * arch_determine_revision_next (struct arch_archive ** arch,
                                          t_uchar * default_archive,
                                          t_uchar * revision_spec,
                                          t_uchar * cmd_name);
extern void arch_check_directory (t_uchar *path, int check_write);
extern void arch_check_uri (t_uchar * uri);
extern void arch_check_revision_local (t_uchar * archive, t_uchar * revision);
extern t_uchar *arch_project_tree_revision (t_uchar const * name, t_uchar const * tree_root);
/* TODO add attribute noreturn here */
extern void arch_cmd_fail (t_uchar const *name, char const * format, ...)
     __attribute__((format (printf, 2, 3)));
extern void arch_check_arch (struct arch_archive *arch);
extern t_uchar * safe_tree_version (t_uchar * cmd_name);
extern t_uchar * arch_archive_last_level (struct arch_archive * arch, t_uchar *version);
extern t_uchar * arch_next_revision (t_uchar * version, t_uchar * last_level, int seal, int fix, t_uchar * cmd_name);
extern t_uchar * arch_version_spec_to_fq_version(t_uchar * version_spec);
extern void arch_assert_in_tree(t_uchar * program_name, t_uchar * dir);
extern t_uchar *
arch_interpret_delta_path (t_uchar ** arch, t_uchar ** rev, t_uchar * scratch_dir, t_uchar * default_archive, t_uchar * spec, t_uchar * cache_dir);
int arch_category_exists (struct arch_archive * arch, t_uchar * package);
int arch_package_exists (struct arch_archive * arch, t_uchar * package);
int arch_version_exists (struct arch_archive * arch, t_uchar * version_spec);
int arch_any_local_changes (t_uchar * program_name, t_uchar * dir);

#endif  /* INCLUDE__LIBARCH__CMDUTILS_H */


/* tag: Tom Lord Fri Jan  9 20:27:20 2004 (cmdutils.h)
 */
