/* Generated by GOB (v1.0.10) on Sat Jan 19 12:16:45 2002
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 1
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 10

#include "balsa-druid-page-directory.h"


#line 32 "balsa-druid-page-directory.gob"

enum __ed_types {
	INBOX,
	OUTBOX,
	SENTBOX,
	DRAFTBOX,
	TRASH,
	NUM_EDs
};

#line 25 "balsa-druid-page-directory.c"

#line 43 "balsa-druid-page-directory.gob"

#include "balsa-app.h"
#include "save-restore.h"
#include "balsa-druid-page-error.h"
#include "misc.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>

/*
ISPRIME9)
*/

static gchar *init_mbnames[NUM_EDs] = { N_("Inbox:"), N_("Outbox:"), N_("Sentbox:"), N_("Draftbox:"), N_("Trash:") };

static void unconditional_mailbox( const gchar *path, const gchar *prettyname,
				   LibBalsaMailbox **box, gchar **error );

static void unconditional_mailbox(const gchar *path, const gchar *prettyname,
				  LibBalsaMailbox **box, gchar **error )
{
	gchar *dup;
	gchar *index;

	if( (*error) != NULL )
		return;

	dup = g_strdup( path );
	index = g_basename( dup );

	if( index == NULL ) {
	  (*error) = g_strdup_printf( _("The pathname \"%s\" must be specified"
					" canonically -- it must start with a \'/\'."), dup );
	  g_free( dup );
	  return;
	}

	index[-1] = '\0'; /*Split off the dirs from the file.*/

	if( balsa_init_create_to_directory( dup, error ) ) {
		/*TRUE->error*/
		g_free( dup );
		return;
	}

	index[-1] = '/';
	g_free ( dup );

	/* The mailbox currently may not be IMAP or POP3 */
	/* Due to the above test for a / at the start of the filename */

	*box = (LibBalsaMailbox*)libbalsa_mailbox_local_new(path, TRUE);

	if( *box == NULL ) {
	  if(strcmp( "/var/spool/mail/", path )) {
	    (*error) = g_strdup_printf( _("The mailbox \"%s\" does not appear to be valid.\n"
					  "Your system does not allow for creation of mailboxes\n"
					  "in /var/spool/mail. Balsa wouldn't function properly\n"
					  "until the system created the mailboxes. Please change\n"
					  "the mailbox path or check your system configuration."),
					path );
	  } else {
	    (*error) = g_strdup_printf( _("The mailbox \"%s\" does not appear to be valid."),
					path );
	  }
	  return;
	}

	(*box)->name = g_strdup( gettext( prettyname ) );

	config_mailbox_add( *box, (char *) prettyname );
}


#line 106 "balsa-druid-page-directory.c"
/* self casting macros */
#define SELF(x) BALSA_DRUID_PAGE_DIRECTORY(x)
#define SELF_CONST(x) BALSA_DRUID_PAGE_DIRECTORY_CONST(x)
#define IS_SELF(x) BALSA_IS_DRUID_PAGE_DIRECTORY(x)
#define TYPE_SELF BALSA_TYPE_DRUID_PAGE_DIRECTORY
#define SELF_CLASS(x) BALSA_DRUID_PAGE_DIRECTORY_CLASS(x)

#define SELF_GET_CLASS(x) BALSA_DRUID_PAGE_DIRECTORY_GET_CLASS(x)

/* self typedefs */
typedef BalsaDruidPageDirectory Self;
typedef BalsaDruidPageDirectoryClass SelfClass;

/* GTK_CLASS_TYPE for 1.2<->1.3/2.0 GTK+ compatibility */
#ifndef GTK_CLASS_TYPE
#define GTK_CLASS_TYPE(x) (GTK_OBJECT_CLASS(x)->type)
#endif /* GTK_CLASS_TYPE */

struct _BalsaDruidPageDirectoryPrivate {
#line 123 "balsa-druid-page-directory.gob"
	GtkWidget * inbox;
#line 124 "balsa-druid-page-directory.gob"
	GtkWidget * outbox;
#line 125 "balsa-druid-page-directory.gob"
	GtkWidget * sentbox;
#line 126 "balsa-druid-page-directory.gob"
	GtkWidget * draftbox;
#line 127 "balsa-druid-page-directory.gob"
	GtkWidget * trash;
#line 128 "balsa-druid-page-directory.gob"
	gboolean paths_locked;
#line 131 "balsa-druid-page-directory.gob"
	EntryMaster emaster;
#line 132 "balsa-druid-page-directory.gob"
	EntryData ed[NUM_EDs];
#line 142 "balsa-druid-page-directory.c"
};
/* here are local prototypes */
static void balsa_druid_page_directory_class_init (BalsaDruidPageDirectoryClass * c) G_GNUC_UNUSED;
static void balsa_druid_page_directory_init (BalsaDruidPageDirectory * self) G_GNUC_UNUSED;
static void ___3_balsa_druid_page_directory_construct (BalsaDruidPage * self) G_GNUC_UNUSED;
static void ___4_balsa_druid_page_directory_prepare (GnomeDruidPage * _self, GtkWidget * druid) G_GNUC_UNUSED;
static gboolean ___5_balsa_druid_page_directory_next (GnomeDruidPage * _self, GtkWidget * druid) G_GNUC_UNUSED;
static gboolean ___6_balsa_druid_page_directory_back (GnomeDruidPage * _self, GtkWidget * druid) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static BalsaDruidPageClass *parent_class = NULL;

GtkType
balsa_druid_page_directory_get_type (void)
{
	static GtkType type = 0;

	if (type == 0) {
		static const GtkTypeInfo info = {
			"BalsaDruidPageDirectory",
			sizeof (BalsaDruidPageDirectory),
			sizeof (BalsaDruidPageDirectoryClass),
			(GtkClassInitFunc) balsa_druid_page_directory_class_init,
			(GtkObjectInitFunc) balsa_druid_page_directory_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL
		};

		type = gtk_type_unique (balsa_druid_page_get_type(), &info);
	}

	return type;
}

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define new(args...) balsa_druid_page_directory_new(args)
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static GtkObject * (* const new) (BalsaInitDruid * druid) = balsa_druid_page_directory_new;

/* a macro for creating a new object of our type */
#define GET_NEW ((BalsaDruidPageDirectory *)gtk_type_new(balsa_druid_page_directory_get_type()))


#ifdef G_OBJECT_CLASS
static void
___finalize(GObject *obj_self)
#else /* !G_OBJECT_CLASS */
static void
___finalize(GtkObject *obj_self)
#endif /* G_OBJECT_CLASS */
{
#define __GOB_FUNCTION__ "Balsa:Druid:Page:Directory::finalize"
	BalsaDruidPageDirectory *self = BALSA_DRUID_PAGE_DIRECTORY (obj_self);
	gpointer priv = self->_priv;
#ifdef G_OBJECT_CLASS
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#else /* !G_OBJECT_CLASS */
	if(GTK_OBJECT_CLASS(parent_class)->finalize) \
		(* GTK_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#endif /* G_OBJECT_CLASS */
	g_free(priv);
}
#undef __GOB_FUNCTION__

static void 
balsa_druid_page_directory_class_init (BalsaDruidPageDirectoryClass * c)
{
#define __GOB_FUNCTION__ "Balsa:Druid:Page:Directory::class_init"
	GtkObjectClass *gtk_object_class = (GtkObjectClass*) c;
#ifdef G_OBJECT_CLASS
	GObjectClass *g_object_class = (GObjectClass*) c;
#endif /* G_OBJECT_CLASS */
	BalsaDruidPageClass *balsa_druid_page_class = (BalsaDruidPageClass *)c;
	GnomeDruidPageClass *gnome_druid_page_class = (GnomeDruidPageClass *)c;

	parent_class = gtk_type_class (balsa_druid_page_get_type ());

#line 200 "balsa-druid-page-directory.gob"
	balsa_druid_page_class->construct = ___3_balsa_druid_page_directory_construct;
#line 211 "balsa-druid-page-directory.gob"
	gnome_druid_page_class->prepare = ___4_balsa_druid_page_directory_prepare;
#line 253 "balsa-druid-page-directory.gob"
	gnome_druid_page_class->next = ___5_balsa_druid_page_directory_next;
#line 286 "balsa-druid-page-directory.gob"
	gnome_druid_page_class->back = ___6_balsa_druid_page_directory_back;
#line 233 "balsa-druid-page-directory.c"
#ifdef G_OBJECT_CLASS
	g_object_class->finalize = ___finalize;
#else /* !G_OBJECT_CLASS */
	gtk_object_class->finalize = ___finalize;
#endif /* G_OBJECT_CLASS */
	return;
	c = NULL;
	gtk_object_class = NULL;
#ifdef G_OBJECT_CLASS
	g_object_class = NULL;
#endif /* G_OBJECT_CLASS */
}
#undef __GOB_FUNCTION__
#line 143 "balsa-druid-page-directory.gob"
static void 
balsa_druid_page_directory_init (BalsaDruidPageDirectory * self)
#line 250 "balsa-druid-page-directory.c"
{
#define __GOB_FUNCTION__ "Balsa:Druid:Page:Directory::init"
	self->_priv = g_new0 (BalsaDruidPageDirectoryPrivate, 1);
 {
#line 144 "balsa-druid-page-directory.gob"

		GtkTable *table;
		GtkLabel *label;
		int i;
		GtkWidget **init_widgets[NUM_EDs];
		gchar *init_presets[NUM_EDs] = { NULL, NULL, NULL, NULL, NULL };

		self->_priv->paths_locked = FALSE;

		self->_priv->emaster.setbits = 0;
		self->_priv->emaster.numentries = 0;
		self->_priv->emaster.donemask = 0;

		table = GTK_TABLE( gtk_table_new( NUM_EDs + 1, 2, FALSE ) );
	
		label = GTK_LABEL( gtk_label_new( _(
			"Please verify the locations of your default mail files.\n"
			"These will be created if necessary." ) ) );
		gtk_label_set_justify( label, GTK_JUSTIFY_RIGHT );
		gtk_label_set_line_wrap( label, TRUE );

		gtk_table_attach( table, GTK_WIDGET( label ), 0, 2, 0, 1,
			GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL,
			8, 4 );

		init_presets[INBOX] = libbalsa_guess_mail_spool();

		init_widgets[INBOX] = &( self->_priv->inbox );
		init_widgets[OUTBOX] = &( self->_priv->outbox );
		init_widgets[SENTBOX] = &( self->_priv->sentbox );
		init_widgets[DRAFTBOX] = &( self->_priv->draftbox );
		init_widgets[TRASH] = &( self->_priv->trash );

		for( i = 0; i < NUM_EDs; i++ ) {
			gchar *preset;

			self->_priv->ed[i].master = &( self->_priv->emaster );

			init_mbnames[i] = _(init_mbnames[i]);

			if( init_presets[i] )
				preset = init_presets[i];
			else
				preset = g_strdup( "[Dummy value]" );

			balsa_init_add_table_entry( table, i, init_mbnames[i], preset,
				&( self->_priv->ed[i] ), GTK_WIDGET( self ), init_widgets[i] );

			g_free( preset );
		}

		gtk_box_pack_start( GTK_BOX( (GNOME_DRUID_PAGE_STANDARD( self ))->vbox ),
			GTK_WIDGET( table ), TRUE, TRUE, 8 );
		gtk_widget_show_all( GTK_WIDGET( table ) );
	
#line 311 "balsa-druid-page-directory.c"
 }
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__


#line 134 "balsa-druid-page-directory.gob"
GtkObject * 
balsa_druid_page_directory_new (BalsaInitDruid * druid)
#line 322 "balsa-druid-page-directory.c"
{
#define __GOB_FUNCTION__ "Balsa:Druid:Page:Directory::new"
#line 134 "balsa-druid-page-directory.gob"
	g_return_val_if_fail (!(druid) || BALSA_IS_INITDRUID (druid), (GtkObject * )0);
#line 134 "balsa-druid-page-directory.gob"
	g_return_val_if_fail (druid != NULL, (GtkObject * )0);
#line 329 "balsa-druid-page-directory.c"
{
#line 135 "balsa-druid-page-directory.gob"
	 
		GtkObject *self = GTK_OBJECT( GET_NEW );
		(BALSA_DRUID_PAGE( self ))->druid = GNOME_DRUID( druid );
		if( BALSA_DRUID_PAGE_CLASS( (GTK_OBJECT( self ))->klass )->construct )
			BALSA_DRUID_PAGE_CLASS( (GTK_OBJECT( self ))->klass )->construct( BALSA_DRUID_PAGE( self ) );
		return self;
	}}
#line 339 "balsa-druid-page-directory.c"
#undef __GOB_FUNCTION__


#line 200 "balsa-druid-page-directory.gob"
static void 
___3_balsa_druid_page_directory_construct (BalsaDruidPage * self)
#line 346 "balsa-druid-page-directory.c"
#define PARENT_HANDLER(___self) \
	{ if(BALSA_DRUID_PAGE_CLASS(parent_class)->construct) \
		(* BALSA_DRUID_PAGE_CLASS(parent_class)->construct)(___self); }
{
#define __GOB_FUNCTION__ "Balsa:Druid:Page:Directory::construct"
{
#line 202 "balsa-druid-page-directory.gob"
	
		(GNOME_DRUID_PAGE_STANDARD( self ))->title = g_strdup( _("Mail Files" ) );

		g_return_if_fail( (BALSA_DRUID_PAGE( self ))->druid != NULL );
		(GNOME_DRUID_PAGE_STANDARD( self ))->logo_image = (BALSA_INITDRUID( (BALSA_DRUID_PAGE( self ))->druid ))->default_logo;

		PARENT_HANDLER( self );
	}}
#line 362 "balsa-druid-page-directory.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 211 "balsa-druid-page-directory.gob"
static void 
___4_balsa_druid_page_directory_prepare (GnomeDruidPage * _self, GtkWidget * druid)
#line 369 "balsa-druid-page-directory.c"
#define PARENT_HANDLER(____self,___druid) \
	{ if(GNOME_DRUID_PAGE_CLASS(parent_class)->prepare) \
		(* GNOME_DRUID_PAGE_CLASS(parent_class)->prepare)(____self,___druid); }
{
#define __GOB_FUNCTION__ "Balsa:Druid:Page:Directory::prepare"
#line 211 "balsa-druid-page-directory.gob"
	g_return_if_fail (!(druid) || GTK_IS_WIDGET (druid));
#line 211 "balsa-druid-page-directory.gob"
	g_return_if_fail (druid != NULL);
#line 379 "balsa-druid-page-directory.c"
{
#line 213 "balsa-druid-page-directory.gob"
	
		gchar *buf;
		BalsaDruidPageDirectory *self = BALSA_DRUID_PAGE_DIRECTORY( _self );

		/* We want a change in the local mailroot to be reflected in the directories
		 * here, but we don't want to trash user's custom settings if needed. Hence
		 * the paths_locked variable; it should work pretty well, because only a movement
		 * backwards should change the mailroot; going forward should not lock the paths:
		 * envision an error occurring; upon return to the Dir page the entries should be
		 * the same. 
		 */

		if( !self->_priv->paths_locked ) {
			buf = g_strconcat( balsa_app.local_mail_directory, "/outbox", NULL );
			gtk_entry_set_text( GTK_ENTRY( self->_priv->outbox ), buf );
			g_free( buf );

			buf = g_strconcat( balsa_app.local_mail_directory, "/sentbox", NULL );
			gtk_entry_set_text( GTK_ENTRY( self->_priv->sentbox ), buf );
			g_free( buf );

			buf = g_strconcat( balsa_app.local_mail_directory, "/draftbox", NULL );
			gtk_entry_set_text( GTK_ENTRY( self->_priv->draftbox ), buf );
			g_free( buf );

			buf = g_strconcat( balsa_app.local_mail_directory, "/trash", NULL );
			gtk_entry_set_text( GTK_ENTRY( self->_priv->trash ), buf );
			g_free( buf );
		}

		/* Don't let them continue unless all entries have something. */
		if( ENTRY_MASTER_DONE( self->_priv->emaster ) ) {
			gnome_druid_set_buttons_sensitive( GNOME_DRUID( druid ), TRUE, TRUE, TRUE );
		} else {
			gnome_druid_set_buttons_sensitive( GNOME_DRUID( druid ), TRUE, FALSE, TRUE );
		}

		gnome_druid_set_show_finish( GNOME_DRUID( druid ), FALSE );
	}}
#line 421 "balsa-druid-page-directory.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 253 "balsa-druid-page-directory.gob"
static gboolean 
___5_balsa_druid_page_directory_next (GnomeDruidPage * _self, GtkWidget * druid)
#line 428 "balsa-druid-page-directory.c"
#define PARENT_HANDLER(____self,___druid) \
	((GNOME_DRUID_PAGE_CLASS(parent_class)->next)? \
		(* GNOME_DRUID_PAGE_CLASS(parent_class)->next)(____self,___druid): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "Balsa:Druid:Page:Directory::next"
#line 253 "balsa-druid-page-directory.gob"
	g_return_val_if_fail (!(druid) || GTK_IS_WIDGET (druid), (gboolean )0);
#line 253 "balsa-druid-page-directory.gob"
	g_return_val_if_fail (druid != NULL, (gboolean )0);
#line 439 "balsa-druid-page-directory.c"
{
#line 255 "balsa-druid-page-directory.gob"
	
		gchar *error = NULL;
		BalsaDruidPageDirectory *self = BALSA_DRUID_PAGE_DIRECTORY( _self );	

		unconditional_mailbox( gtk_entry_get_text( GTK_ENTRY( self->_priv->inbox ) ),
			"Inbox", &balsa_app.inbox, &error );
		unconditional_mailbox( gtk_entry_get_text( GTK_ENTRY( self->_priv->outbox ) ),
			"Outbox", &balsa_app.outbox, &error );
		unconditional_mailbox( gtk_entry_get_text( GTK_ENTRY( self->_priv->sentbox ) ),
			"Sentbox", &balsa_app.sentbox, &error );
		unconditional_mailbox( gtk_entry_get_text( GTK_ENTRY( self->_priv->draftbox ) ),
			"Draftbox", &balsa_app.draftbox, &error );
		unconditional_mailbox( gtk_entry_get_text( GTK_ENTRY( self->_priv->trash ) ),
			"Trash", &balsa_app.trash, &error );

		self->_priv->paths_locked = TRUE;

		if( error ) {
			BalsaDruidPageError *ep;

			ep = BALSA_DRUID_PAGE_ERROR( balsa_druid_page_error_new_after( BALSA_DRUID_PAGE( self ),
				_("Problem Creating Mailboxes"), error ) );
			g_free( error );
			balsa_druid_page_error_goto_me( ep );
		} else {
			PARENT_HANDLER( _self, druid );
		}

		return TRUE;
	}}
#line 472 "balsa-druid-page-directory.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 286 "balsa-druid-page-directory.gob"
static gboolean 
___6_balsa_druid_page_directory_back (GnomeDruidPage * _self, GtkWidget * druid)
#line 479 "balsa-druid-page-directory.c"
#define PARENT_HANDLER(____self,___druid) \
	((GNOME_DRUID_PAGE_CLASS(parent_class)->back)? \
		(* GNOME_DRUID_PAGE_CLASS(parent_class)->back)(____self,___druid): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "Balsa:Druid:Page:Directory::back"
#line 286 "balsa-druid-page-directory.gob"
	g_return_val_if_fail (!(druid) || GTK_IS_WIDGET (druid), (gboolean )0);
#line 286 "balsa-druid-page-directory.gob"
	g_return_val_if_fail (druid != NULL, (gboolean )0);
#line 490 "balsa-druid-page-directory.c"
{
#line 288 "balsa-druid-page-directory.gob"
	
		BalsaDruidPageDirectory *self = BALSA_DRUID_PAGE_DIRECTORY( _self );	
		
		self->_priv->paths_locked = FALSE;
		PARENT_HANDLER( _self, druid );
		return TRUE;
	}}
#line 500 "balsa-druid-page-directory.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___balsa_druid_page_directory_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))new)();
	___balsa_druid_page_directory_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */

