------------------------------------------------------------------------------
--                                                                          --
--                            GNATPP COMPONENTS                             --
--                                                                          --
--                        G N A T P P . D R I V E R                         --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            1.2
--                                                                          --
--                   Copyright (C) 2001-2002, ACT Europe                    --
--                                                                          --
-- GNATPP is free software; you can redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNATPP is  distributed in the  hope that it will  be  useful, but --
-- WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABI- --
-- LITY or  FITNESS  FOR A  PARTICULAR  PURPOSE. See the GNU General Public --
-- License  for more details. You  should  have  received a copy of the GNU --
-- General Public License  distributed with GNAT; see file COPYING. If not, --
-- write  to  the Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston,                                                                  --
--                                                                          --
-- GNATPP is maintained by ACT Europe (http://www.act-europe.fr).           --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Command_Line;

with GNATPP.Common;
with GNATPP.Environment;
with GNATPP.Processing;

procedure GNATPP.Driver is
begin
   GNATPP.Environment.Init;
   GNATPP.Processing.Main;
   GNATPP.Environment.Clean_Up;
exception
   when GNATPP.Common.Fatal_Error =>
      Ada.Command_Line.Set_Exit_Status (Ada.Command_Line.Failure);
      GNATPP.Environment.Clean_Up;
      --  Just a trap. Fatal_Error is the only exception which can come out of
      --  the main processing steps
end GNATPP.Driver;
