#ifndef protocolhttph
#define protocolhttph
#include <glib.h>

struct _ProtocolHttpClient;
typedef struct _ProtocolHttpClient ProtocolHttpClient;

struct _ProtocolHttpRequest;
typedef struct _ProtocolHttpRequest ProtocolHttpRequest;

struct _ProtocolHttpHandler;
typedef struct _ProtocolHttpHandler ProtocolHttpHandler;

// Return: 0 close; 0 no-close 
typedef gint (*ProtocolHttpHandlerProc) (ProtocolHttpClient *client, ProtocolHttpRequest *request); 

struct _ProtocolHttpHandler
{
  guint method; // 0 dontcare, 1 GET, 2 POST
  gchar *res;
  gchar *description;
  ProtocolHttpHandlerProc proc;
};

struct _ProtocolHttpClient
{
  int fd;
  guint32 id;
};

struct _ProtocolHttpRequest
{
  guint method;
  gchar *res;
  gchar *query;
  int http_version;
  gboolean auth;
};

gchar *protocol_http_lookup_status_code(int i);
gboolean protocol_http_read_line(ProtocolHttpClient *client, gchar* ln, guint len);
gboolean protocol_http_write(ProtocolHttpClient *client, gchar *ln);
gboolean protocol_http_write_line(ProtocolHttpClient *client, gchar *ln);
gboolean protocol_http_response(ProtocolHttpClient *client, guint i, gchar *text);
gboolean protocol_http_header(ProtocolHttpClient *client, gchar *field, gchar* value);
gboolean protocol_http_header_Server(ProtocolHttpClient *client);
void protocol_http_error(ProtocolHttpClient *client, guint i, gchar *text);
gint protocol_http_execute(ProtocolHttpClient *client, ProtocolHttpRequest *request);
void protocol_http_dispatch(int fd);
void protocol_http_new_socket(int fd);
void protocol_http_read_header(ProtocolHttpClient *client, ProtocolHttpRequest *request);

typedef struct {
  gchar *field;
  gchar *value;
} ProtocolHttpParseQueryItem;

void protocol_http_parse_query(ProtocolHttpClient *client, gchar *query, ProtocolHttpParseQueryItem *items);

#endif
