// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package costexplorer

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opGetCostAndUsage = "GetCostAndUsage"

// GetCostAndUsageRequest generates a "aws/request.Request" representing the
// client's request for the GetCostAndUsage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCostAndUsage for more information on using the GetCostAndUsage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCostAndUsageRequest method.
//    req, resp := client.GetCostAndUsageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostAndUsage
func (c *CostExplorer) GetCostAndUsageRequest(input *GetCostAndUsageInput) (req *request.Request, output *GetCostAndUsageOutput) {
	op := &request.Operation{
		Name:       opGetCostAndUsage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCostAndUsageInput{}
	}

	output = &GetCostAndUsageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCostAndUsage API operation for AWS Cost Explorer Service.
//
// Retrieves cost and usage metrics for your account. You can specify which
// cost and usage-related metric, such as BlendedCosts or UsageQuantity, that
// you want the request to return. You can also filter and group your data by
// various dimensions, such as SERVICE or AZ, in a specific time range. For
// a complete list of valid dimensions, see the GetDimensionValues (http://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html)
// operation. Master accounts in an organization in AWS Organizations have access
// to all member accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetCostAndUsage for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You made too many calls in a short period of time. Try again later.
//
//   * ErrCodeBillExpirationException "BillExpirationException"
//   The requested report expired. Update the date interval and try again.
//
//   * ErrCodeDataUnavailableException "DataUnavailableException"
//   The requested data is unavailable.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The pagination token is invalid. Try again without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostAndUsage
func (c *CostExplorer) GetCostAndUsage(input *GetCostAndUsageInput) (*GetCostAndUsageOutput, error) {
	req, out := c.GetCostAndUsageRequest(input)
	return out, req.Send()
}

// GetCostAndUsageWithContext is the same as GetCostAndUsage with the addition of
// the ability to pass a context and additional request options.
//
// See GetCostAndUsage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetCostAndUsageWithContext(ctx aws.Context, input *GetCostAndUsageInput, opts ...request.Option) (*GetCostAndUsageOutput, error) {
	req, out := c.GetCostAndUsageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDimensionValues = "GetDimensionValues"

// GetDimensionValuesRequest generates a "aws/request.Request" representing the
// client's request for the GetDimensionValues operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDimensionValues for more information on using the GetDimensionValues
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDimensionValuesRequest method.
//    req, resp := client.GetDimensionValuesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetDimensionValues
func (c *CostExplorer) GetDimensionValuesRequest(input *GetDimensionValuesInput) (req *request.Request, output *GetDimensionValuesOutput) {
	op := &request.Operation{
		Name:       opGetDimensionValues,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDimensionValuesInput{}
	}

	output = &GetDimensionValuesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDimensionValues API operation for AWS Cost Explorer Service.
//
// Retrieves all available filter values for a specific filter over a period
// of time. You can search the dimension values for an arbitrary string.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetDimensionValues for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You made too many calls in a short period of time. Try again later.
//
//   * ErrCodeBillExpirationException "BillExpirationException"
//   The requested report expired. Update the date interval and try again.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The pagination token is invalid. Try again without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetDimensionValues
func (c *CostExplorer) GetDimensionValues(input *GetDimensionValuesInput) (*GetDimensionValuesOutput, error) {
	req, out := c.GetDimensionValuesRequest(input)
	return out, req.Send()
}

// GetDimensionValuesWithContext is the same as GetDimensionValues with the addition of
// the ability to pass a context and additional request options.
//
// See GetDimensionValues for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetDimensionValuesWithContext(ctx aws.Context, input *GetDimensionValuesInput, opts ...request.Option) (*GetDimensionValuesOutput, error) {
	req, out := c.GetDimensionValuesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReservationCoverage = "GetReservationCoverage"

// GetReservationCoverageRequest generates a "aws/request.Request" representing the
// client's request for the GetReservationCoverage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReservationCoverage for more information on using the GetReservationCoverage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetReservationCoverageRequest method.
//    req, resp := client.GetReservationCoverageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationCoverage
func (c *CostExplorer) GetReservationCoverageRequest(input *GetReservationCoverageInput) (req *request.Request, output *GetReservationCoverageOutput) {
	op := &request.Operation{
		Name:       opGetReservationCoverage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetReservationCoverageInput{}
	}

	output = &GetReservationCoverageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReservationCoverage API operation for AWS Cost Explorer Service.
//
// Retrieves the reservation coverage for your account. This allows you to see
// how much of your Amazon Elastic Compute Cloud, Amazon ElastiCache, Amazon
// Relational Database Service, or Amazon Redshift usage is covered by a reservation.
// An organization's master account can see the coverage of the associated member
// accounts. For any time period, you can filter data about reservation usage
// by the following dimensions:
//
//    * AZ
//
//    * INSTANCE_TYPE
//
//    * LINKED_ACCOUNT
//
//    * PLATFORM
//
//    * REGION
//
//    * TENANCY
//
// To determine valid values for a dimension, use the GetDimensionValues operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetReservationCoverage for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You made too many calls in a short period of time. Try again later.
//
//   * ErrCodeDataUnavailableException "DataUnavailableException"
//   The requested data is unavailable.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The pagination token is invalid. Try again without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationCoverage
func (c *CostExplorer) GetReservationCoverage(input *GetReservationCoverageInput) (*GetReservationCoverageOutput, error) {
	req, out := c.GetReservationCoverageRequest(input)
	return out, req.Send()
}

// GetReservationCoverageWithContext is the same as GetReservationCoverage with the addition of
// the ability to pass a context and additional request options.
//
// See GetReservationCoverage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetReservationCoverageWithContext(ctx aws.Context, input *GetReservationCoverageInput, opts ...request.Option) (*GetReservationCoverageOutput, error) {
	req, out := c.GetReservationCoverageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReservationPurchaseRecommendation = "GetReservationPurchaseRecommendation"

// GetReservationPurchaseRecommendationRequest generates a "aws/request.Request" representing the
// client's request for the GetReservationPurchaseRecommendation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReservationPurchaseRecommendation for more information on using the GetReservationPurchaseRecommendation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetReservationPurchaseRecommendationRequest method.
//    req, resp := client.GetReservationPurchaseRecommendationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationPurchaseRecommendation
func (c *CostExplorer) GetReservationPurchaseRecommendationRequest(input *GetReservationPurchaseRecommendationInput) (req *request.Request, output *GetReservationPurchaseRecommendationOutput) {
	op := &request.Operation{
		Name:       opGetReservationPurchaseRecommendation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetReservationPurchaseRecommendationInput{}
	}

	output = &GetReservationPurchaseRecommendationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReservationPurchaseRecommendation API operation for AWS Cost Explorer Service.
//
// Gets recommendations for which reservations to purchase. These recommendations
// could help you reduce your costs. Reservations provide a discounted hourly
// rate (up to 75%) compared to On-Demand pricing.
//
// AWS generates your recommendations by identifying your On-Demand usage during
// a specific time period and collecting your usage into categories that are
// eligible for a reservation. After AWS has these categories, it simulates
// every combination of reservations in each category of usage to identify the
// best number of each type of RI to purchase to maximize your estimated savings.
//
// For example, AWS automatically aggregates your EC2 Linux, shared tenancy,
// and c4 family usage in the US West (Oregon) Region and recommends that you
// buy size-flexible regional reservations to apply to the c4 family usage.
// AWS recommends the smallest size instance in an instance family. This makes
// it easier to purchase a size-flexible RI. AWS also shows the equal number
// of normalized units so that you can purchase any instance size that you want.
// For this example, your RI recommendation would be for c4.large, because that
// is the smallest size instance in the c4 instance family.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetReservationPurchaseRecommendation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You made too many calls in a short period of time. Try again later.
//
//   * ErrCodeDataUnavailableException "DataUnavailableException"
//   The requested data is unavailable.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The pagination token is invalid. Try again without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationPurchaseRecommendation
func (c *CostExplorer) GetReservationPurchaseRecommendation(input *GetReservationPurchaseRecommendationInput) (*GetReservationPurchaseRecommendationOutput, error) {
	req, out := c.GetReservationPurchaseRecommendationRequest(input)
	return out, req.Send()
}

// GetReservationPurchaseRecommendationWithContext is the same as GetReservationPurchaseRecommendation with the addition of
// the ability to pass a context and additional request options.
//
// See GetReservationPurchaseRecommendation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetReservationPurchaseRecommendationWithContext(ctx aws.Context, input *GetReservationPurchaseRecommendationInput, opts ...request.Option) (*GetReservationPurchaseRecommendationOutput, error) {
	req, out := c.GetReservationPurchaseRecommendationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReservationUtilization = "GetReservationUtilization"

// GetReservationUtilizationRequest generates a "aws/request.Request" representing the
// client's request for the GetReservationUtilization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReservationUtilization for more information on using the GetReservationUtilization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetReservationUtilizationRequest method.
//    req, resp := client.GetReservationUtilizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationUtilization
func (c *CostExplorer) GetReservationUtilizationRequest(input *GetReservationUtilizationInput) (req *request.Request, output *GetReservationUtilizationOutput) {
	op := &request.Operation{
		Name:       opGetReservationUtilization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetReservationUtilizationInput{}
	}

	output = &GetReservationUtilizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReservationUtilization API operation for AWS Cost Explorer Service.
//
// You can retrieve the reservation utilization for your account. Master accounts
// in an organization in AWS Organizations have access to their associated member
// accounts. You can filter data by dimensions in a time period. You can use
// GetDimensionValues to determine the possible dimension values. Currently,
// you can group only by SUBSCRIPTION_ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetReservationUtilization for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You made too many calls in a short period of time. Try again later.
//
//   * ErrCodeDataUnavailableException "DataUnavailableException"
//   The requested data is unavailable.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The pagination token is invalid. Try again without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationUtilization
func (c *CostExplorer) GetReservationUtilization(input *GetReservationUtilizationInput) (*GetReservationUtilizationOutput, error) {
	req, out := c.GetReservationUtilizationRequest(input)
	return out, req.Send()
}

// GetReservationUtilizationWithContext is the same as GetReservationUtilization with the addition of
// the ability to pass a context and additional request options.
//
// See GetReservationUtilization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetReservationUtilizationWithContext(ctx aws.Context, input *GetReservationUtilizationInput, opts ...request.Option) (*GetReservationUtilizationOutput, error) {
	req, out := c.GetReservationUtilizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTags = "GetTags"

// GetTagsRequest generates a "aws/request.Request" representing the
// client's request for the GetTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTags for more information on using the GetTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTagsRequest method.
//    req, resp := client.GetTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetTags
func (c *CostExplorer) GetTagsRequest(input *GetTagsInput) (req *request.Request, output *GetTagsOutput) {
	op := &request.Operation{
		Name:       opGetTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTagsInput{}
	}

	output = &GetTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTags API operation for AWS Cost Explorer Service.
//
// You can query for available tag keys and tag values for a specified period.
// You can search the tag values for an arbitrary string.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You made too many calls in a short period of time. Try again later.
//
//   * ErrCodeBillExpirationException "BillExpirationException"
//   The requested report expired. Update the date interval and try again.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The pagination token is invalid. Try again without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetTags
func (c *CostExplorer) GetTags(input *GetTagsInput) (*GetTagsOutput, error) {
	req, out := c.GetTagsRequest(input)
	return out, req.Send()
}

// GetTagsWithContext is the same as GetTags with the addition of
// the ability to pass a context and additional request options.
//
// See GetTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetTagsWithContext(ctx aws.Context, input *GetTagsInput, opts ...request.Option) (*GetTagsOutput, error) {
	req, out := c.GetTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The amount of instance usage that a reservation covered.
type Coverage struct {
	_ struct{} `type:"structure"`

	// The amount of instance usage that a reservation covered, in hours.
	CoverageHours *CoverageHours `type:"structure"`
}

// String returns the string representation
func (s Coverage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Coverage) GoString() string {
	return s.String()
}

// SetCoverageHours sets the CoverageHours field's value.
func (s *Coverage) SetCoverageHours(v *CoverageHours) *Coverage {
	s.CoverageHours = v
	return s
}

// Reservation coverage for a specified period, in hours.
type CoverageByTime struct {
	_ struct{} `type:"structure"`

	// The groups of instances that are covered by a reservation.
	Groups []*ReservationCoverageGroup `type:"list"`

	// The period over which this coverage was used.
	TimePeriod *DateInterval `type:"structure"`

	// The total reservation coverage, in hours.
	Total *Coverage `type:"structure"`
}

// String returns the string representation
func (s CoverageByTime) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CoverageByTime) GoString() string {
	return s.String()
}

// SetGroups sets the Groups field's value.
func (s *CoverageByTime) SetGroups(v []*ReservationCoverageGroup) *CoverageByTime {
	s.Groups = v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *CoverageByTime) SetTimePeriod(v *DateInterval) *CoverageByTime {
	s.TimePeriod = v
	return s
}

// SetTotal sets the Total field's value.
func (s *CoverageByTime) SetTotal(v *Coverage) *CoverageByTime {
	s.Total = v
	return s
}

// How long a running instance either used a reservation or was On-Demand.
type CoverageHours struct {
	_ struct{} `type:"structure"`

	// The percentage of instance hours that are covered by a reservation.
	CoverageHoursPercentage *string `type:"string"`

	// The number of instance running hours that are covered by On-Demand Instances.
	OnDemandHours *string `type:"string"`

	// The number of instance running hours that are covered by reservations.
	ReservedHours *string `type:"string"`

	// The total instance usage, in hours.
	TotalRunningHours *string `type:"string"`
}

// String returns the string representation
func (s CoverageHours) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CoverageHours) GoString() string {
	return s.String()
}

// SetCoverageHoursPercentage sets the CoverageHoursPercentage field's value.
func (s *CoverageHours) SetCoverageHoursPercentage(v string) *CoverageHours {
	s.CoverageHoursPercentage = &v
	return s
}

// SetOnDemandHours sets the OnDemandHours field's value.
func (s *CoverageHours) SetOnDemandHours(v string) *CoverageHours {
	s.OnDemandHours = &v
	return s
}

// SetReservedHours sets the ReservedHours field's value.
func (s *CoverageHours) SetReservedHours(v string) *CoverageHours {
	s.ReservedHours = &v
	return s
}

// SetTotalRunningHours sets the TotalRunningHours field's value.
func (s *CoverageHours) SetTotalRunningHours(v string) *CoverageHours {
	s.TotalRunningHours = &v
	return s
}

// The time period that you want the usage and costs for.
type DateInterval struct {
	_ struct{} `type:"structure"`

	// The end of the time period that you want the usage and costs for. The end
	// date is exclusive. For example, if end is 2017-05-01, AWS retrieves cost
	// and usage data from the start date up to, but not including, 2017-05-01.
	//
	// End is a required field
	End *string `type:"string" required:"true"`

	// The beginning of the time period that you want the usage and costs for. The
	// start date is inclusive. For example, if start is 2017-01-01, AWS retrieves
	// cost and usage data starting at 2017-01-01 up to the end date.
	//
	// Start is a required field
	Start *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DateInterval) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DateInterval) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DateInterval) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DateInterval"}
	if s.End == nil {
		invalidParams.Add(request.NewErrParamRequired("End"))
	}
	if s.Start == nil {
		invalidParams.Add(request.NewErrParamRequired("Start"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnd sets the End field's value.
func (s *DateInterval) SetEnd(v string) *DateInterval {
	s.End = &v
	return s
}

// SetStart sets the Start field's value.
func (s *DateInterval) SetStart(v string) *DateInterval {
	s.Start = &v
	return s
}

// The metadata that you can use to filter and group your results. You can use
// GetDimensionValues to find specific values.
type DimensionValues struct {
	_ struct{} `type:"structure"`

	// The names of the metadata types that you can use to filter and group your
	// results. For example, AZ returns a list of Availability Zones.
	Key *string `type:"string" enum:"Dimension"`

	// The metadata values that you can use to filter and group your results. You
	// can use GetDimensionValues to find specific values.
	Values []*string `type:"list"`
}

// String returns the string representation
func (s DimensionValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DimensionValues) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *DimensionValues) SetKey(v string) *DimensionValues {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *DimensionValues) SetValues(v []*string) *DimensionValues {
	s.Values = v
	return s
}

// The metadata of a specific type that you can use to filter and group your
// results. You can use GetDimensionValues to find specific values.
type DimensionValuesWithAttributes struct {
	_ struct{} `type:"structure"`

	// The attribute that applies to a specific Dimension.
	Attributes map[string]*string `type:"map"`

	// The value of a dimension with a specific attribute.
	Value *string `type:"string"`
}

// String returns the string representation
func (s DimensionValuesWithAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DimensionValuesWithAttributes) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *DimensionValuesWithAttributes) SetAttributes(v map[string]*string) *DimensionValuesWithAttributes {
	s.Attributes = v
	return s
}

// SetValue sets the Value field's value.
func (s *DimensionValuesWithAttributes) SetValue(v string) *DimensionValuesWithAttributes {
	s.Value = &v
	return s
}

// Details about the EC2 instances that AWS recommends that you purchase.
type EC2InstanceDetails struct {
	_ struct{} `type:"structure"`

	// The Availability Zone of the recommended reservation.
	AvailabilityZone *string `type:"string"`

	// Whether the recommendation is for a current generation instance.
	CurrentGeneration *bool `type:"boolean"`

	// The instance family of the recommended reservation.
	Family *string `type:"string"`

	// The type of instance that AWS recommends.
	InstanceType *string `type:"string"`

	// The platform of the recommended reservation. The platform is the specific
	// combination of operating system, license model, and software on an instance.
	Platform *string `type:"string"`

	// The AWS Region of the recommended reservation.
	Region *string `type:"string"`

	// Whether the recommended reservation is size flexible.
	SizeFlexEligible *bool `type:"boolean"`

	// Whether the recommended reservation is dedicated or shared.
	Tenancy *string `type:"string"`
}

// String returns the string representation
func (s EC2InstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EC2InstanceDetails) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *EC2InstanceDetails) SetAvailabilityZone(v string) *EC2InstanceDetails {
	s.AvailabilityZone = &v
	return s
}

// SetCurrentGeneration sets the CurrentGeneration field's value.
func (s *EC2InstanceDetails) SetCurrentGeneration(v bool) *EC2InstanceDetails {
	s.CurrentGeneration = &v
	return s
}

// SetFamily sets the Family field's value.
func (s *EC2InstanceDetails) SetFamily(v string) *EC2InstanceDetails {
	s.Family = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *EC2InstanceDetails) SetInstanceType(v string) *EC2InstanceDetails {
	s.InstanceType = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *EC2InstanceDetails) SetPlatform(v string) *EC2InstanceDetails {
	s.Platform = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *EC2InstanceDetails) SetRegion(v string) *EC2InstanceDetails {
	s.Region = &v
	return s
}

// SetSizeFlexEligible sets the SizeFlexEligible field's value.
func (s *EC2InstanceDetails) SetSizeFlexEligible(v bool) *EC2InstanceDetails {
	s.SizeFlexEligible = &v
	return s
}

// SetTenancy sets the Tenancy field's value.
func (s *EC2InstanceDetails) SetTenancy(v string) *EC2InstanceDetails {
	s.Tenancy = &v
	return s
}

// The EC2 hardware specifications that you want AWS to provide recommendations
// for.
type EC2Specification struct {
	_ struct{} `type:"structure"`

	// Whether you want a recommendation for standard or convertible reservations.
	OfferingClass *string `type:"string" enum:"OfferingClass"`
}

// String returns the string representation
func (s EC2Specification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EC2Specification) GoString() string {
	return s.String()
}

// SetOfferingClass sets the OfferingClass field's value.
func (s *EC2Specification) SetOfferingClass(v string) *EC2Specification {
	s.OfferingClass = &v
	return s
}

// Use Expression to filter by cost or by usage. There are two patterns:
//
//    * Simple dimension values - You can set the dimension name and values
//    for the filters that you plan to use. For example, you can filter for
//    INSTANCE_TYPE==m4.xlarge OR INSTANCE_TYPE==c4.large. The Expression for
//    that looks like this:
//
// { "Dimensions": { "Key": "INSTANCE_TYPE", "Values": [ "m4.xlarge", “c4.large”
//    ] } }
//
// The list of dimension values are OR'd together to retrieve cost or usage
//    data. You can create Expression and DimensionValues objects using either
//    with* methods or set* methods in multiple lines.
//
//    * Compound dimension values with logical operations - You can use multiple
//    Expression types and the logical operators AND/OR/NOT to create a list
//    of one or more Expression objects. This allows you to filter on more advanced
//    options. For example, you can filter on ((INSTANCE_TYPE == m4.large OR
//    INSTANCE_TYPE == m3.large) OR (TAG.Type == Type1)) AND (USAGE_TYPE !=
//    DataTransfer). The Expression for that looks like this:
//
// { "And": [ {"Or": [ {"Dimensions": { "Key": "INSTANCE_TYPE", "Values": [
//    "m4.x.large", "c4.large" ] }}, {"Tag": { "Key": "TagName", "Values": ["Value1"]
//    } } ]}, {"Not": {"dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"]
//    }}} ] }
//
// Because each Expression can have only one operator, the service returns an
//    error if more than one is specified. The following example shows an Expression
//    object that creates an error.
//
//  { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values":
//    [ "DataTransfer" ] } }
type Expression struct {
	_ struct{} `type:"structure"`

	// Return results that match both Dimension objects.
	And []*Expression `type:"list"`

	// The specific Dimension to use for Expression.
	Dimensions *DimensionValues `type:"structure"`

	// Return results that don't match a Dimension object.
	Not *Expression `type:"structure"`

	// Return results that match either Dimension object.
	Or []*Expression `type:"list"`

	// The specific Tag to use for Expression.
	Tags *TagValues `type:"structure"`
}

// String returns the string representation
func (s Expression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Expression) GoString() string {
	return s.String()
}

// SetAnd sets the And field's value.
func (s *Expression) SetAnd(v []*Expression) *Expression {
	s.And = v
	return s
}

// SetDimensions sets the Dimensions field's value.
func (s *Expression) SetDimensions(v *DimensionValues) *Expression {
	s.Dimensions = v
	return s
}

// SetNot sets the Not field's value.
func (s *Expression) SetNot(v *Expression) *Expression {
	s.Not = v
	return s
}

// SetOr sets the Or field's value.
func (s *Expression) SetOr(v []*Expression) *Expression {
	s.Or = v
	return s
}

// SetTags sets the Tags field's value.
func (s *Expression) SetTags(v *TagValues) *Expression {
	s.Tags = v
	return s
}

type GetCostAndUsageInput struct {
	_ struct{} `type:"structure"`

	// Filters AWS costs by different dimensions. For example, you can specify SERVICE
	// and LINKED_ACCOUNT and get the costs that are associated with that account's
	// usage of that service. You can nest Expression objects to define any combination
	// of dimension filters. For more information, see Expression (http://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html).
	Filter *Expression `type:"structure"`

	// Sets the AWS cost granularity to MONTHLY or DAILY. If Granularity isn't set,
	// the response object doesn't include the Granularity, either MONTHLY or DAILY.
	Granularity *string `type:"string" enum:"Granularity"`

	// You can group AWS costs using up to two different groups, either dimensions,
	// tag keys, or both.
	//
	// When you group by tag key, you get all tag values, including empty strings.
	//
	// Valid values are AZ, INSTANCE_TYPE, LEGAL_ENTITY_NAME, LINKED_ACCOUNT, OPERATION,
	// PLATFORM, PURCHASE_TYPE, SERVICE, TAGS, TENANCY, and USAGE_TYPE.
	GroupBy []*GroupDefinition `type:"list"`

	// Which metrics are returned in the query. For more information about blended
	// and unblended rates, see Why does the "blended" annotation appear on some
	// line items in my bill? (https://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/).
	//
	// Valid values are BlendedCost, UnblendedCost, and UsageQuantity.
	//
	// If you return the UsageQuantity metric, the service aggregates all usage
	// numbers without taking into account the units. For example, if you aggregate
	// usageQuantity across all of EC2, the results aren't meaningful because EC2
	// compute hours and data transfer are measured in different units (for example,
	// hours vs. GB). To get more meaningful UsageQuantity metrics, filter by UsageType
	// or UsageTypeGroups.
	//
	// Metrics is required for GetCostAndUsage requests.
	Metrics []*string `type:"list"`

	// The token to retrieve the next set of results. AWS provides the token when
	// the response from a previous call has more results than the maximum page
	// size.
	NextPageToken *string `type:"string"`

	// Sets the start and end dates for retrieving AWS costs. The start date is
	// inclusive, but the end date is exclusive. For example, if start is 2017-01-01
	// and end is 2017-05-01, then the cost and usage data is retrieved from 2017-01-01
	// up to and including 2017-04-30 but not including 2017-05-01.
	TimePeriod *DateInterval `type:"structure"`
}

// String returns the string representation
func (s GetCostAndUsageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCostAndUsageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCostAndUsageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCostAndUsageInput"}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *GetCostAndUsageInput) SetFilter(v *Expression) *GetCostAndUsageInput {
	s.Filter = v
	return s
}

// SetGranularity sets the Granularity field's value.
func (s *GetCostAndUsageInput) SetGranularity(v string) *GetCostAndUsageInput {
	s.Granularity = &v
	return s
}

// SetGroupBy sets the GroupBy field's value.
func (s *GetCostAndUsageInput) SetGroupBy(v []*GroupDefinition) *GetCostAndUsageInput {
	s.GroupBy = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *GetCostAndUsageInput) SetMetrics(v []*string) *GetCostAndUsageInput {
	s.Metrics = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetCostAndUsageInput) SetNextPageToken(v string) *GetCostAndUsageInput {
	s.NextPageToken = &v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetCostAndUsageInput) SetTimePeriod(v *DateInterval) *GetCostAndUsageInput {
	s.TimePeriod = v
	return s
}

type GetCostAndUsageOutput struct {
	_ struct{} `type:"structure"`

	// The groups that are specified by the Filter or GroupBy parameters in the
	// request.
	GroupDefinitions []*GroupDefinition `type:"list"`

	// The token for the next set of retrievable results. AWS provides the token
	// when the response from a previous call has more results than the maximum
	// page size.
	NextPageToken *string `type:"string"`

	// The time period that is covered by the results in the response.
	ResultsByTime []*ResultByTime `type:"list"`
}

// String returns the string representation
func (s GetCostAndUsageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCostAndUsageOutput) GoString() string {
	return s.String()
}

// SetGroupDefinitions sets the GroupDefinitions field's value.
func (s *GetCostAndUsageOutput) SetGroupDefinitions(v []*GroupDefinition) *GetCostAndUsageOutput {
	s.GroupDefinitions = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetCostAndUsageOutput) SetNextPageToken(v string) *GetCostAndUsageOutput {
	s.NextPageToken = &v
	return s
}

// SetResultsByTime sets the ResultsByTime field's value.
func (s *GetCostAndUsageOutput) SetResultsByTime(v []*ResultByTime) *GetCostAndUsageOutput {
	s.ResultsByTime = v
	return s
}

type GetDimensionValuesInput struct {
	_ struct{} `type:"structure"`

	// The context for the call to GetDimensionValues. This can be RESERVATIONS
	// or COST_AND_USAGE. The default value is COST_AND_USAGE. If the context is
	// set to RESERVATIONS, the resulting dimension values can be used in the GetReservationUtilization
	// operation. If the context is set to COST_AND_USAGE the resulting dimension
	// values can be used in the GetCostAndUsage operation.
	//
	// If you set the context to CostAndUsage, you can use the following dimensions
	// for searching:
	//
	//    * AZ - The Availability Zone. An example is us-east-1a.
	//
	//    * INSTANCE_TYPE - The type of instance. An example is an EC2 m4.xlarge.
	//
	//    * LINKED_ACCOUNT - The description in the attribute map that includes
	//    the full name of the member account. The value field contains the AWS
	//    ID of the member account.
	//
	//    * OPERATION - The action performed. Examples include RunInstance and CreateBucket.
	//
	//    * PURCHASE_TYPE - The reservation type of the purchase to which this usage
	//    is related. Examples include On-Demand Instances and Standard Reserved
	//    Instances.
	//
	//    * SERVICE - The AWS service such as DynamoDB.
	//
	//    * USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes.
	//    The response for the GetDimensionValues operation includes a unit attribute,
	//    examples of which include GB and Hrs.
	//
	//    * USAGE_TYPE_GROUP - The grouping of common usage types. An example is
	//    EC2: CloudWatch – Alarms. The response for this operation includes a unit
	//    attribute.
	//
	//    * RECORD_TYPE - The different types of charges such as RI fees, usage
	//    costs, tax refunds, and credits.
	//
	// If you set the context to RESERVATIONS, you can use the following dimensions
	// for searching:
	//
	//    * AZ - The Availability Zone. An example is us-east-1a.
	//
	//    * INSTANCE_TYPE - The type of instance. An example is an EC2 m4.xlarge.
	//
	//    * LINKED_ACCOUNT - The description in the attribute map that includes
	//    the full name of the member account. The value field contains the AWS
	//    ID of the member account.
	//
	//    * PLATFORM - The specific combination of operating system, license model,
	//    and software on an instance. For example, a Windows instance with SQL
	//    Server Web and no license, or a Red Hat Enterprise Linux instance.
	//
	//    * REGION - The AWS Region.
	//
	//    * SCOPE - The scope of a Reserved Instance (RI). Values are regional or
	//    a single Availability Zone.
	//
	//    * TENANCY - The tenancy of a resource. Examples are shared or dedicated.
	Context *string `type:"string" enum:"Context"`

	// The name of the dimension. Each Dimension is available for different a Context.
	// For more information, see Context.
	//
	// Dimension is a required field
	Dimension *string `type:"string" required:"true" enum:"Dimension"`

	// The token to retrieve the next set of results. AWS provides the token when
	// the response from a previous call has more results than the maximum page
	// size.
	NextPageToken *string `type:"string"`

	// The value that you want to search the filter values for.
	SearchString *string `type:"string"`

	// The start and end dates for retrieving the dimension values. The start date
	// is inclusive, but the end date is exclusive. For example, if start is 2017-01-01
	// and end is 2017-05-01, then the cost and usage data is retrieved from 2017-01-01
	// up to and including 2017-04-30 but not including 2017-05-01.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetDimensionValuesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDimensionValuesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDimensionValuesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDimensionValuesInput"}
	if s.Dimension == nil {
		invalidParams.Add(request.NewErrParamRequired("Dimension"))
	}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContext sets the Context field's value.
func (s *GetDimensionValuesInput) SetContext(v string) *GetDimensionValuesInput {
	s.Context = &v
	return s
}

// SetDimension sets the Dimension field's value.
func (s *GetDimensionValuesInput) SetDimension(v string) *GetDimensionValuesInput {
	s.Dimension = &v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetDimensionValuesInput) SetNextPageToken(v string) *GetDimensionValuesInput {
	s.NextPageToken = &v
	return s
}

// SetSearchString sets the SearchString field's value.
func (s *GetDimensionValuesInput) SetSearchString(v string) *GetDimensionValuesInput {
	s.SearchString = &v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetDimensionValuesInput) SetTimePeriod(v *DateInterval) *GetDimensionValuesInput {
	s.TimePeriod = v
	return s
}

type GetDimensionValuesOutput struct {
	_ struct{} `type:"structure"`

	// The filters that you used to filter your request. Some dimensions are available
	// only for a specific context:
	//
	// If you set the context to CostAndUsage, you can use the following dimensions
	// for searching:
	//
	//    * AZ - The Availability Zone. An example is us-east-1a.
	//
	//    * INSTANCE_TYPE - The type of instance. An example is an EC2 m4.xlarge.
	//
	//    * LINKED_ACCOUNT - The description in the attribute map that includes
	//    the full name of the member account. The value field contains the AWS
	//    ID of the member account.
	//
	//    * OPERATION - The action performed. Examples include RunInstance and CreateBucket.
	//
	//    * PURCHASE_TYPE - The reservation type of the purchase to which this usage
	//    is related. Examples include On-Demand Instances and Standard Reserved
	//    Instances.
	//
	//    * SERVICE - The AWS service such as DynamoDB.
	//
	//    * USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes.
	//    The response for the GetDimensionValues operation includes a unit attribute,
	//    examples of which include GB and Hrs.
	//
	//    * USAGE_TYPE_GROUP - The grouping of common usage types. An example is
	//    EC2: CloudWatch – Alarms. The response for this operation includes a unit
	//    attribute.
	//
	//    * RECORD_TYPE - The different types of charges such as RI fees, usage
	//    costs, tax refunds, and credits.
	//
	// If you set the context to RESERVATIONS, you can use the following dimensions
	// for searching:
	//
	//    * AZ - The Availability Zone. An example is us-east-1a.
	//
	//    * INSTANCE_TYPE - The type of instance. An example is an EC2 m4.xlarge.
	//
	//    * LINKED_ACCOUNT - The description in the attribute map that includes
	//    the full name of the member account. The value field contains the AWS
	//    ID of the member account.
	//
	//    * PLATFORM - The specific combination of operating system, license model,
	//    and software on an instance. For example, a Windows instance with SQL
	//    Server Web and no license, or a Red Hat Enterprise Linux instance.
	//
	//    * REGION - The AWS Region.
	//
	//    * SCOPE - The scope of a Reserved Instance (RI). Values are regional or
	//    a single Availability Zone.
	//
	//    * TENANCY - The tenancy of a resource. Examples are shared or dedicated.
	//
	// DimensionValues is a required field
	DimensionValues []*DimensionValuesWithAttributes `type:"list" required:"true"`

	// The token for the next set of retrievable results. AWS provides the token
	// when the response from a previous call has more results than the maximum
	// page size.
	NextPageToken *string `type:"string"`

	// The number of results that AWS returned at one time.
	//
	// ReturnSize is a required field
	ReturnSize *int64 `type:"integer" required:"true"`

	// The total number of search results.
	//
	// TotalSize is a required field
	TotalSize *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s GetDimensionValuesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDimensionValuesOutput) GoString() string {
	return s.String()
}

// SetDimensionValues sets the DimensionValues field's value.
func (s *GetDimensionValuesOutput) SetDimensionValues(v []*DimensionValuesWithAttributes) *GetDimensionValuesOutput {
	s.DimensionValues = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetDimensionValuesOutput) SetNextPageToken(v string) *GetDimensionValuesOutput {
	s.NextPageToken = &v
	return s
}

// SetReturnSize sets the ReturnSize field's value.
func (s *GetDimensionValuesOutput) SetReturnSize(v int64) *GetDimensionValuesOutput {
	s.ReturnSize = &v
	return s
}

// SetTotalSize sets the TotalSize field's value.
func (s *GetDimensionValuesOutput) SetTotalSize(v int64) *GetDimensionValuesOutput {
	s.TotalSize = &v
	return s
}

// You can use the following request parameters to query for how much of your
// instance usage is covered by a reservation.
type GetReservationCoverageInput struct {
	_ struct{} `type:"structure"`

	// Filters utilization data by dimensions. You can filter by the following dimensions:
	//
	//    * AZ
	//
	//    * INSTANCE_TYPE
	//
	//    * LINKED_ACCOUNT
	//
	//    * PLATFORM
	//
	//    * REGION
	//
	//    * TENANCY
	//
	// GetReservationCoverage uses the same Expression (http://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
	// object as the other operations, but only AND is supported among each dimension.
	// You can nest only one level deep. If there are multiple values for a dimension,
	// they are OR'd together.
	Filter *Expression `type:"structure"`

	// The granularity of the AWS cost data for the reservation. Valid values are
	// MONTHLY and DAILY.
	//
	// If GroupBy is set, Granularity can't be set. If Granularity isn't set, the
	// response object doesn't include the Granularity, either MONTHLY or DAILY.
	Granularity *string `type:"string" enum:"Granularity"`

	// You can group the data by the following attributes:
	//
	//    * AZ
	//
	//    * INSTANCE_TYPE
	//
	//    * LINKED_ACCOUNT
	//
	//    * PLATFORM
	//
	//    * REGION
	//
	//    * TENANCY
	GroupBy []*GroupDefinition `type:"list"`

	// The token to retrieve the next set of results. AWS provides the token when
	// the response from a previous call has more results than the maximum page
	// size.
	NextPageToken *string `type:"string"`

	// The start and end dates of the period for which you want to retrieve data
	// about reservation coverage. You can retrieve data for a maximum of 13 months:
	// the last 12 months and the current month. The start date is inclusive, but
	// the end date is exclusive. For example, if start is 2017-01-01 and end is
	// 2017-05-01, then the cost and usage data is retrieved from 2017-01-01 up
	// to and including 2017-04-30 but not including 2017-05-01.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetReservationCoverageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReservationCoverageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReservationCoverageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReservationCoverageInput"}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *GetReservationCoverageInput) SetFilter(v *Expression) *GetReservationCoverageInput {
	s.Filter = v
	return s
}

// SetGranularity sets the Granularity field's value.
func (s *GetReservationCoverageInput) SetGranularity(v string) *GetReservationCoverageInput {
	s.Granularity = &v
	return s
}

// SetGroupBy sets the GroupBy field's value.
func (s *GetReservationCoverageInput) SetGroupBy(v []*GroupDefinition) *GetReservationCoverageInput {
	s.GroupBy = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetReservationCoverageInput) SetNextPageToken(v string) *GetReservationCoverageInput {
	s.NextPageToken = &v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetReservationCoverageInput) SetTimePeriod(v *DateInterval) *GetReservationCoverageInput {
	s.TimePeriod = v
	return s
}

type GetReservationCoverageOutput struct {
	_ struct{} `type:"structure"`

	// The amount of time that your reservations covered.
	//
	// CoveragesByTime is a required field
	CoveragesByTime []*CoverageByTime `type:"list" required:"true"`

	// The token for the next set of retrievable results. AWS provides the token
	// when the response from a previous call has more results than the maximum
	// page size.
	NextPageToken *string `type:"string"`

	// The total amount of instance usage that is covered by a reservation.
	Total *Coverage `type:"structure"`
}

// String returns the string representation
func (s GetReservationCoverageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReservationCoverageOutput) GoString() string {
	return s.String()
}

// SetCoveragesByTime sets the CoveragesByTime field's value.
func (s *GetReservationCoverageOutput) SetCoveragesByTime(v []*CoverageByTime) *GetReservationCoverageOutput {
	s.CoveragesByTime = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetReservationCoverageOutput) SetNextPageToken(v string) *GetReservationCoverageOutput {
	s.NextPageToken = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *GetReservationCoverageOutput) SetTotal(v *Coverage) *GetReservationCoverageOutput {
	s.Total = v
	return s
}

type GetReservationPurchaseRecommendationInput struct {
	_ struct{} `type:"structure"`

	// The account ID that is associated with the recommendation.
	AccountId *string `type:"string"`

	// The account scope that you want recommendations for. The only valid value
	// is Payer. This means that AWS includes the master account and any member
	// accounts when it calculates its recommendations.
	AccountScope *string `type:"string" enum:"AccountScope"`

	// The number of previous days that you want AWS to consider when it calculates
	// your recommendations.
	LookbackPeriodInDays *string `type:"string" enum:"LookbackPeriodInDays"`

	// The pagination token that indicates the next set of results that you want
	// to retrieve.
	NextPageToken *string `type:"string"`

	// The number of recommendations that you want returned in a single response
	// object.
	PageSize *int64 `type:"integer"`

	// The reservation purchase option that you want recommendations for.
	PaymentOption *string `type:"string" enum:"PaymentOption"`

	// The specific service that you want recommendations for.
	//
	// Service is a required field
	Service *string `type:"string" required:"true"`

	// The specific service, such as EC2, that you want recommendations for.
	ServiceSpecification *ServiceSpecification `type:"structure"`

	// The reservation term that you want recommendations for.
	TermInYears *string `type:"string" enum:"TermInYears"`
}

// String returns the string representation
func (s GetReservationPurchaseRecommendationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReservationPurchaseRecommendationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReservationPurchaseRecommendationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReservationPurchaseRecommendationInput"}
	if s.Service == nil {
		invalidParams.Add(request.NewErrParamRequired("Service"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetReservationPurchaseRecommendationInput) SetAccountId(v string) *GetReservationPurchaseRecommendationInput {
	s.AccountId = &v
	return s
}

// SetAccountScope sets the AccountScope field's value.
func (s *GetReservationPurchaseRecommendationInput) SetAccountScope(v string) *GetReservationPurchaseRecommendationInput {
	s.AccountScope = &v
	return s
}

// SetLookbackPeriodInDays sets the LookbackPeriodInDays field's value.
func (s *GetReservationPurchaseRecommendationInput) SetLookbackPeriodInDays(v string) *GetReservationPurchaseRecommendationInput {
	s.LookbackPeriodInDays = &v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetReservationPurchaseRecommendationInput) SetNextPageToken(v string) *GetReservationPurchaseRecommendationInput {
	s.NextPageToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetReservationPurchaseRecommendationInput) SetPageSize(v int64) *GetReservationPurchaseRecommendationInput {
	s.PageSize = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *GetReservationPurchaseRecommendationInput) SetPaymentOption(v string) *GetReservationPurchaseRecommendationInput {
	s.PaymentOption = &v
	return s
}

// SetService sets the Service field's value.
func (s *GetReservationPurchaseRecommendationInput) SetService(v string) *GetReservationPurchaseRecommendationInput {
	s.Service = &v
	return s
}

// SetServiceSpecification sets the ServiceSpecification field's value.
func (s *GetReservationPurchaseRecommendationInput) SetServiceSpecification(v *ServiceSpecification) *GetReservationPurchaseRecommendationInput {
	s.ServiceSpecification = v
	return s
}

// SetTermInYears sets the TermInYears field's value.
func (s *GetReservationPurchaseRecommendationInput) SetTermInYears(v string) *GetReservationPurchaseRecommendationInput {
	s.TermInYears = &v
	return s
}

type GetReservationPurchaseRecommendationOutput struct {
	_ struct{} `type:"structure"`

	// Information about this specific recommendation call, such as the time stamp
	// for when Cost Explorer generated this recommendation.
	Metadata *ReservationPurchaseRecommendationMetadata `type:"structure"`

	// The pagination token for the next set of retrievable results.
	NextPageToken *string `type:"string"`

	// Recommendations for reservations to purchase.
	Recommendations []*ReservationPurchaseRecommendation `type:"list"`
}

// String returns the string representation
func (s GetReservationPurchaseRecommendationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReservationPurchaseRecommendationOutput) GoString() string {
	return s.String()
}

// SetMetadata sets the Metadata field's value.
func (s *GetReservationPurchaseRecommendationOutput) SetMetadata(v *ReservationPurchaseRecommendationMetadata) *GetReservationPurchaseRecommendationOutput {
	s.Metadata = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetReservationPurchaseRecommendationOutput) SetNextPageToken(v string) *GetReservationPurchaseRecommendationOutput {
	s.NextPageToken = &v
	return s
}

// SetRecommendations sets the Recommendations field's value.
func (s *GetReservationPurchaseRecommendationOutput) SetRecommendations(v []*ReservationPurchaseRecommendation) *GetReservationPurchaseRecommendationOutput {
	s.Recommendations = v
	return s
}

type GetReservationUtilizationInput struct {
	_ struct{} `type:"structure"`

	// Filters utilization data by using different dimensions. GetReservationUtilization
	// uses the same Expression (http://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
	// object as the other operations, but only AND is supported among each dimension,
	// and nesting is supported to only one level deep. If there are multiple values
	// for a dimension, they are OR'd together.
	Filter *Expression `type:"structure"`

	// If GroupBy is set, Granularity can't be set. If Granularity isn't set, the
	// response object doesn't include the Granularity, either MONTHLY or DAILY.
	// If both GroupBy and Granularity aren't set, GetReservationUtilization defaults
	// to DAILY.
	Granularity *string `type:"string" enum:"Granularity"`

	// Groups only by SUBSCRIPTION_ID. Metadata is included.
	GroupBy []*GroupDefinition `type:"list"`

	// The token to retrieve the next set of results. AWS provides the token when
	// the response from a previous call has more results than the maximum page
	// size.
	NextPageToken *string `type:"string"`

	// Sets the start and end dates for retrieving reserve instance (RI) utilization.
	// The start date is inclusive, but the end date is exclusive. For example,
	// if start is 2017-01-01 and end is 2017-05-01, then the cost and usage data
	// is retrieved from 2017-01-01 up to and including 2017-04-30 but not including
	// 2017-05-01.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetReservationUtilizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReservationUtilizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReservationUtilizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReservationUtilizationInput"}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *GetReservationUtilizationInput) SetFilter(v *Expression) *GetReservationUtilizationInput {
	s.Filter = v
	return s
}

// SetGranularity sets the Granularity field's value.
func (s *GetReservationUtilizationInput) SetGranularity(v string) *GetReservationUtilizationInput {
	s.Granularity = &v
	return s
}

// SetGroupBy sets the GroupBy field's value.
func (s *GetReservationUtilizationInput) SetGroupBy(v []*GroupDefinition) *GetReservationUtilizationInput {
	s.GroupBy = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetReservationUtilizationInput) SetNextPageToken(v string) *GetReservationUtilizationInput {
	s.NextPageToken = &v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetReservationUtilizationInput) SetTimePeriod(v *DateInterval) *GetReservationUtilizationInput {
	s.TimePeriod = v
	return s
}

type GetReservationUtilizationOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of retrievable results. AWS provides the token
	// when the response from a previous call has more results than the maximum
	// page size.
	NextPageToken *string `type:"string"`

	// The total amount of time that you utilized your RIs.
	Total *ReservationAggregates `type:"structure"`

	// The amount of time that you utilized your RIs.
	//
	// UtilizationsByTime is a required field
	UtilizationsByTime []*UtilizationByTime `type:"list" required:"true"`
}

// String returns the string representation
func (s GetReservationUtilizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReservationUtilizationOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetReservationUtilizationOutput) SetNextPageToken(v string) *GetReservationUtilizationOutput {
	s.NextPageToken = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *GetReservationUtilizationOutput) SetTotal(v *ReservationAggregates) *GetReservationUtilizationOutput {
	s.Total = v
	return s
}

// SetUtilizationsByTime sets the UtilizationsByTime field's value.
func (s *GetReservationUtilizationOutput) SetUtilizationsByTime(v []*UtilizationByTime) *GetReservationUtilizationOutput {
	s.UtilizationsByTime = v
	return s
}

type GetTagsInput struct {
	_ struct{} `type:"structure"`

	// The token to retrieve the next set of results. AWS provides the token when
	// the response from a previous call has more results than the maximum page
	// size.
	NextPageToken *string `type:"string"`

	// The value that you want to search for.
	SearchString *string `type:"string"`

	// The key of the tag that you want to return values for.
	TagKey *string `type:"string"`

	// The start and end dates for retrieving the dimension values. The start date
	// is inclusive, but the end date is exclusive. For example, if start is 2017-01-01
	// and end is 2017-05-01, then the cost and usage data is retrieved from 2017-01-01
	// up to and including 2017-04-30 but not including 2017-05-01.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTagsInput"}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetTagsInput) SetNextPageToken(v string) *GetTagsInput {
	s.NextPageToken = &v
	return s
}

// SetSearchString sets the SearchString field's value.
func (s *GetTagsInput) SetSearchString(v string) *GetTagsInput {
	s.SearchString = &v
	return s
}

// SetTagKey sets the TagKey field's value.
func (s *GetTagsInput) SetTagKey(v string) *GetTagsInput {
	s.TagKey = &v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetTagsInput) SetTimePeriod(v *DateInterval) *GetTagsInput {
	s.TimePeriod = v
	return s
}

type GetTagsOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of retrievable results. AWS provides the token
	// when the response from a previous call has more results than the maximum
	// page size.
	NextPageToken *string `type:"string"`

	// The number of query results that AWS returns at a time.
	//
	// ReturnSize is a required field
	ReturnSize *int64 `type:"integer" required:"true"`

	// The tags that match your request.
	//
	// Tags is a required field
	Tags []*string `type:"list" required:"true"`

	// The total number of query results.
	//
	// TotalSize is a required field
	TotalSize *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s GetTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTagsOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetTagsOutput) SetNextPageToken(v string) *GetTagsOutput {
	s.NextPageToken = &v
	return s
}

// SetReturnSize sets the ReturnSize field's value.
func (s *GetTagsOutput) SetReturnSize(v int64) *GetTagsOutput {
	s.ReturnSize = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetTagsOutput) SetTags(v []*string) *GetTagsOutput {
	s.Tags = v
	return s
}

// SetTotalSize sets the TotalSize field's value.
func (s *GetTagsOutput) SetTotalSize(v int64) *GetTagsOutput {
	s.TotalSize = &v
	return s
}

// One level of grouped data within the results.
type Group struct {
	_ struct{} `type:"structure"`

	// The keys that are included in this group.
	Keys []*string `type:"list"`

	// The metrics that are included in this group.
	Metrics map[string]*MetricValue `type:"map"`
}

// String returns the string representation
func (s Group) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Group) GoString() string {
	return s.String()
}

// SetKeys sets the Keys field's value.
func (s *Group) SetKeys(v []*string) *Group {
	s.Keys = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *Group) SetMetrics(v map[string]*MetricValue) *Group {
	s.Metrics = v
	return s
}

// Represents a group when you specify a group by criteria, or in the response
// to a query with a specific grouping.
type GroupDefinition struct {
	_ struct{} `type:"structure"`

	// The string that represents a key for a specified group.
	Key *string `type:"string"`

	// The string that represents the type of group.
	Type *string `type:"string" enum:"GroupDefinitionType"`
}

// String returns the string representation
func (s GroupDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupDefinition) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *GroupDefinition) SetKey(v string) *GroupDefinition {
	s.Key = &v
	return s
}

// SetType sets the Type field's value.
func (s *GroupDefinition) SetType(v string) *GroupDefinition {
	s.Type = &v
	return s
}

// Details about the instances that AWS recommends that you purchase.
type InstanceDetails struct {
	_ struct{} `type:"structure"`

	// The EC2 instances that AWS recommends that you purchase.
	EC2InstanceDetails *EC2InstanceDetails `type:"structure"`
}

// String returns the string representation
func (s InstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceDetails) GoString() string {
	return s.String()
}

// SetEC2InstanceDetails sets the EC2InstanceDetails field's value.
func (s *InstanceDetails) SetEC2InstanceDetails(v *EC2InstanceDetails) *InstanceDetails {
	s.EC2InstanceDetails = v
	return s
}

// The aggregated value for a metric.
type MetricValue struct {
	_ struct{} `type:"structure"`

	// The actual number that represents the metric.
	Amount *string `type:"string"`

	// The unit that the metric is given in.
	Unit *string `type:"string"`
}

// String returns the string representation
func (s MetricValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricValue) GoString() string {
	return s.String()
}

// SetAmount sets the Amount field's value.
func (s *MetricValue) SetAmount(v string) *MetricValue {
	s.Amount = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *MetricValue) SetUnit(v string) *MetricValue {
	s.Unit = &v
	return s
}

// The aggregated numbers for your RI usage.
type ReservationAggregates struct {
	_ struct{} `type:"structure"`

	// How many RI hours that you purchased.
	PurchasedHours *string `type:"string"`

	// The total number of RI hours that you used.
	TotalActualHours *string `type:"string"`

	// The number of RI hours that you didn't use.
	UnusedHours *string `type:"string"`

	// The percentage of RI time that you used.
	UtilizationPercentage *string `type:"string"`
}

// String returns the string representation
func (s ReservationAggregates) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservationAggregates) GoString() string {
	return s.String()
}

// SetPurchasedHours sets the PurchasedHours field's value.
func (s *ReservationAggregates) SetPurchasedHours(v string) *ReservationAggregates {
	s.PurchasedHours = &v
	return s
}

// SetTotalActualHours sets the TotalActualHours field's value.
func (s *ReservationAggregates) SetTotalActualHours(v string) *ReservationAggregates {
	s.TotalActualHours = &v
	return s
}

// SetUnusedHours sets the UnusedHours field's value.
func (s *ReservationAggregates) SetUnusedHours(v string) *ReservationAggregates {
	s.UnusedHours = &v
	return s
}

// SetUtilizationPercentage sets the UtilizationPercentage field's value.
func (s *ReservationAggregates) SetUtilizationPercentage(v string) *ReservationAggregates {
	s.UtilizationPercentage = &v
	return s
}

// A group of reservations that share a set of attributes.
type ReservationCoverageGroup struct {
	_ struct{} `type:"structure"`

	// The attributes for this group of reservations.
	Attributes map[string]*string `type:"map"`

	// How much instance usage this group of reservations covered.
	Coverage *Coverage `type:"structure"`
}

// String returns the string representation
func (s ReservationCoverageGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservationCoverageGroup) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *ReservationCoverageGroup) SetAttributes(v map[string]*string) *ReservationCoverageGroup {
	s.Attributes = v
	return s
}

// SetCoverage sets the Coverage field's value.
func (s *ReservationCoverageGroup) SetCoverage(v *Coverage) *ReservationCoverageGroup {
	s.Coverage = v
	return s
}

// A specific reservation that AWS recommends for purchase.
type ReservationPurchaseRecommendation struct {
	_ struct{} `type:"structure"`

	// The account scope that AWS recommends that you purchase this instance for.
	// For example, you can purchase this reservation for an entire organization
	// in AWS Organizations.
	AccountScope *string `type:"string" enum:"AccountScope"`

	// How many days of previous usage that AWS takes into consideration when making
	// this recommendation.
	LookbackPeriodInDays *string `type:"string" enum:"LookbackPeriodInDays"`

	// The payment option for the reservation. For example, AllUpfront or NoUpfront.
	PaymentOption *string `type:"string" enum:"PaymentOption"`

	// Details about the recommended purchases.
	RecommendationDetails []*ReservationPurchaseRecommendationDetail `type:"list"`

	// A summary about the recommended purchase.
	RecommendationSummary *ReservationPurchaseRecommendationSummary `type:"structure"`

	// Hardware specifications for the service that you want recommendations for.
	ServiceSpecification *ServiceSpecification `type:"structure"`

	// The term of the reservation that you want recommendations for, in years.
	TermInYears *string `type:"string" enum:"TermInYears"`
}

// String returns the string representation
func (s ReservationPurchaseRecommendation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservationPurchaseRecommendation) GoString() string {
	return s.String()
}

// SetAccountScope sets the AccountScope field's value.
func (s *ReservationPurchaseRecommendation) SetAccountScope(v string) *ReservationPurchaseRecommendation {
	s.AccountScope = &v
	return s
}

// SetLookbackPeriodInDays sets the LookbackPeriodInDays field's value.
func (s *ReservationPurchaseRecommendation) SetLookbackPeriodInDays(v string) *ReservationPurchaseRecommendation {
	s.LookbackPeriodInDays = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *ReservationPurchaseRecommendation) SetPaymentOption(v string) *ReservationPurchaseRecommendation {
	s.PaymentOption = &v
	return s
}

// SetRecommendationDetails sets the RecommendationDetails field's value.
func (s *ReservationPurchaseRecommendation) SetRecommendationDetails(v []*ReservationPurchaseRecommendationDetail) *ReservationPurchaseRecommendation {
	s.RecommendationDetails = v
	return s
}

// SetRecommendationSummary sets the RecommendationSummary field's value.
func (s *ReservationPurchaseRecommendation) SetRecommendationSummary(v *ReservationPurchaseRecommendationSummary) *ReservationPurchaseRecommendation {
	s.RecommendationSummary = v
	return s
}

// SetServiceSpecification sets the ServiceSpecification field's value.
func (s *ReservationPurchaseRecommendation) SetServiceSpecification(v *ServiceSpecification) *ReservationPurchaseRecommendation {
	s.ServiceSpecification = v
	return s
}

// SetTermInYears sets the TermInYears field's value.
func (s *ReservationPurchaseRecommendation) SetTermInYears(v string) *ReservationPurchaseRecommendation {
	s.TermInYears = &v
	return s
}

// Details about your recommended reservation purchase.
type ReservationPurchaseRecommendationDetail struct {
	_ struct{} `type:"structure"`

	// The average number of normalized units that you used in an hour during the
	// historical period. AWS uses this to calculate your recommended reservation
	// purchases.
	AverageNormalizedUnitsUsedPerHour *string `type:"string"`

	// The average number of instances that you used in an hour during the historical
	// period. AWS uses this to calculate your recommended reservation purchases.
	AverageNumberOfInstancesUsedPerHour *string `type:"string"`

	// The average utilization of your instances. AWS uses this to calculate your
	// recommended reservation purchases.
	AverageUtilization *string `type:"string"`

	// The currency code that AWS used to calculate the costs for this instance.
	CurrencyCode *string `type:"string"`

	// How long AWS estimates that it takes for this instance to start saving you
	// money, in months.
	EstimatedBreakEvenInMonths *string `type:"string"`

	// How much AWS estimates that you spend on On-Demand Instances in a month.
	EstimatedMonthlyOnDemandCost *string `type:"string"`

	// How much AWS estimates that this specific recommendation could save you in
	// a month.
	EstimatedMonthlySavingsAmount *string `type:"string"`

	// How much AWS estimates that this specific recommendation could save you in
	// a month, as a percentage of your overall costs.
	EstimatedMonthlySavingsPercentage *string `type:"string"`

	// How much AWS estimates that you spent on Reserved Instances during the specified
	// historical period.
	EstimatedReservationCostForLookbackPeriod *string `type:"string"`

	// Details about the instances that AWS recommends that you purchase.
	InstanceDetails *InstanceDetails `type:"structure"`

	// The maximum number of normalized units that you used in an hour during the
	// historical period. AWS uses this to calculate your recommended reservation
	// purchases.
	MaximumNormalizedUnitsUsedPerHour *string `type:"string"`

	// The maximum number of instances that you used in an hour during the historical
	// period. AWS uses this to calculate your recommended reservation purchases.
	MaximumNumberOfInstancesUsedPerHour *string `type:"string"`

	// The minimum number of hours that you used in an hour during the historical
	// period. AWS uses this to calculate your recommended reservation purchases.
	MinimumNormalizedUnitsUsedPerHour *string `type:"string"`

	// The minimum number of instances that you used in an hour during the historical
	// period. AWS uses this to calculate your recommended reservation purchases.
	MinimumNumberOfInstancesUsedPerHour *string `type:"string"`

	// The number of normalized units that AWS recommends that you purchase.
	RecommendedNormalizedUnitsToPurchase *string `type:"string"`

	// The number of instances that AWS recommends that you purchase.
	RecommendedNumberOfInstancesToPurchase *string `type:"string"`

	// How much purchasing this instance costs you on a monthly basis.
	RecurringStandardMonthlyCost *string `type:"string"`

	// How much purchasing this instance costs you upfront.
	UpfrontCost *string `type:"string"`
}

// String returns the string representation
func (s ReservationPurchaseRecommendationDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservationPurchaseRecommendationDetail) GoString() string {
	return s.String()
}

// SetAverageNormalizedUnitsUsedPerHour sets the AverageNormalizedUnitsUsedPerHour field's value.
func (s *ReservationPurchaseRecommendationDetail) SetAverageNormalizedUnitsUsedPerHour(v string) *ReservationPurchaseRecommendationDetail {
	s.AverageNormalizedUnitsUsedPerHour = &v
	return s
}

// SetAverageNumberOfInstancesUsedPerHour sets the AverageNumberOfInstancesUsedPerHour field's value.
func (s *ReservationPurchaseRecommendationDetail) SetAverageNumberOfInstancesUsedPerHour(v string) *ReservationPurchaseRecommendationDetail {
	s.AverageNumberOfInstancesUsedPerHour = &v
	return s
}

// SetAverageUtilization sets the AverageUtilization field's value.
func (s *ReservationPurchaseRecommendationDetail) SetAverageUtilization(v string) *ReservationPurchaseRecommendationDetail {
	s.AverageUtilization = &v
	return s
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *ReservationPurchaseRecommendationDetail) SetCurrencyCode(v string) *ReservationPurchaseRecommendationDetail {
	s.CurrencyCode = &v
	return s
}

// SetEstimatedBreakEvenInMonths sets the EstimatedBreakEvenInMonths field's value.
func (s *ReservationPurchaseRecommendationDetail) SetEstimatedBreakEvenInMonths(v string) *ReservationPurchaseRecommendationDetail {
	s.EstimatedBreakEvenInMonths = &v
	return s
}

// SetEstimatedMonthlyOnDemandCost sets the EstimatedMonthlyOnDemandCost field's value.
func (s *ReservationPurchaseRecommendationDetail) SetEstimatedMonthlyOnDemandCost(v string) *ReservationPurchaseRecommendationDetail {
	s.EstimatedMonthlyOnDemandCost = &v
	return s
}

// SetEstimatedMonthlySavingsAmount sets the EstimatedMonthlySavingsAmount field's value.
func (s *ReservationPurchaseRecommendationDetail) SetEstimatedMonthlySavingsAmount(v string) *ReservationPurchaseRecommendationDetail {
	s.EstimatedMonthlySavingsAmount = &v
	return s
}

// SetEstimatedMonthlySavingsPercentage sets the EstimatedMonthlySavingsPercentage field's value.
func (s *ReservationPurchaseRecommendationDetail) SetEstimatedMonthlySavingsPercentage(v string) *ReservationPurchaseRecommendationDetail {
	s.EstimatedMonthlySavingsPercentage = &v
	return s
}

// SetEstimatedReservationCostForLookbackPeriod sets the EstimatedReservationCostForLookbackPeriod field's value.
func (s *ReservationPurchaseRecommendationDetail) SetEstimatedReservationCostForLookbackPeriod(v string) *ReservationPurchaseRecommendationDetail {
	s.EstimatedReservationCostForLookbackPeriod = &v
	return s
}

// SetInstanceDetails sets the InstanceDetails field's value.
func (s *ReservationPurchaseRecommendationDetail) SetInstanceDetails(v *InstanceDetails) *ReservationPurchaseRecommendationDetail {
	s.InstanceDetails = v
	return s
}

// SetMaximumNormalizedUnitsUsedPerHour sets the MaximumNormalizedUnitsUsedPerHour field's value.
func (s *ReservationPurchaseRecommendationDetail) SetMaximumNormalizedUnitsUsedPerHour(v string) *ReservationPurchaseRecommendationDetail {
	s.MaximumNormalizedUnitsUsedPerHour = &v
	return s
}

// SetMaximumNumberOfInstancesUsedPerHour sets the MaximumNumberOfInstancesUsedPerHour field's value.
func (s *ReservationPurchaseRecommendationDetail) SetMaximumNumberOfInstancesUsedPerHour(v string) *ReservationPurchaseRecommendationDetail {
	s.MaximumNumberOfInstancesUsedPerHour = &v
	return s
}

// SetMinimumNormalizedUnitsUsedPerHour sets the MinimumNormalizedUnitsUsedPerHour field's value.
func (s *ReservationPurchaseRecommendationDetail) SetMinimumNormalizedUnitsUsedPerHour(v string) *ReservationPurchaseRecommendationDetail {
	s.MinimumNormalizedUnitsUsedPerHour = &v
	return s
}

// SetMinimumNumberOfInstancesUsedPerHour sets the MinimumNumberOfInstancesUsedPerHour field's value.
func (s *ReservationPurchaseRecommendationDetail) SetMinimumNumberOfInstancesUsedPerHour(v string) *ReservationPurchaseRecommendationDetail {
	s.MinimumNumberOfInstancesUsedPerHour = &v
	return s
}

// SetRecommendedNormalizedUnitsToPurchase sets the RecommendedNormalizedUnitsToPurchase field's value.
func (s *ReservationPurchaseRecommendationDetail) SetRecommendedNormalizedUnitsToPurchase(v string) *ReservationPurchaseRecommendationDetail {
	s.RecommendedNormalizedUnitsToPurchase = &v
	return s
}

// SetRecommendedNumberOfInstancesToPurchase sets the RecommendedNumberOfInstancesToPurchase field's value.
func (s *ReservationPurchaseRecommendationDetail) SetRecommendedNumberOfInstancesToPurchase(v string) *ReservationPurchaseRecommendationDetail {
	s.RecommendedNumberOfInstancesToPurchase = &v
	return s
}

// SetRecurringStandardMonthlyCost sets the RecurringStandardMonthlyCost field's value.
func (s *ReservationPurchaseRecommendationDetail) SetRecurringStandardMonthlyCost(v string) *ReservationPurchaseRecommendationDetail {
	s.RecurringStandardMonthlyCost = &v
	return s
}

// SetUpfrontCost sets the UpfrontCost field's value.
func (s *ReservationPurchaseRecommendationDetail) SetUpfrontCost(v string) *ReservationPurchaseRecommendationDetail {
	s.UpfrontCost = &v
	return s
}

// Information about this specific recommendation, such as the time stamp for
// when AWS made a specific recommendation.
type ReservationPurchaseRecommendationMetadata struct {
	_ struct{} `type:"structure"`

	// The time stamp for when AWS made this recommendation.
	GenerationTimestamp *string `type:"string"`

	// The ID for this specific recommendation.
	RecommendationId *string `type:"string"`
}

// String returns the string representation
func (s ReservationPurchaseRecommendationMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservationPurchaseRecommendationMetadata) GoString() string {
	return s.String()
}

// SetGenerationTimestamp sets the GenerationTimestamp field's value.
func (s *ReservationPurchaseRecommendationMetadata) SetGenerationTimestamp(v string) *ReservationPurchaseRecommendationMetadata {
	s.GenerationTimestamp = &v
	return s
}

// SetRecommendationId sets the RecommendationId field's value.
func (s *ReservationPurchaseRecommendationMetadata) SetRecommendationId(v string) *ReservationPurchaseRecommendationMetadata {
	s.RecommendationId = &v
	return s
}

// A summary about this recommendation, such as the currency code, the amount
// that AWS estimates you could save, and the total amount of reservation to
// purchase.
type ReservationPurchaseRecommendationSummary struct {
	_ struct{} `type:"structure"`

	// The currency code used for this recommendation.
	CurrencyCode *string `type:"string"`

	// The total amount that AWS estimates that this recommendation could save you
	// in a month.
	TotalEstimatedMonthlySavingsAmount *string `type:"string"`

	// The total amount that AWS estimates that this recommendation could save you
	// in a month, as a percentage of your costs.
	TotalEstimatedMonthlySavingsPercentage *string `type:"string"`
}

// String returns the string representation
func (s ReservationPurchaseRecommendationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservationPurchaseRecommendationSummary) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *ReservationPurchaseRecommendationSummary) SetCurrencyCode(v string) *ReservationPurchaseRecommendationSummary {
	s.CurrencyCode = &v
	return s
}

// SetTotalEstimatedMonthlySavingsAmount sets the TotalEstimatedMonthlySavingsAmount field's value.
func (s *ReservationPurchaseRecommendationSummary) SetTotalEstimatedMonthlySavingsAmount(v string) *ReservationPurchaseRecommendationSummary {
	s.TotalEstimatedMonthlySavingsAmount = &v
	return s
}

// SetTotalEstimatedMonthlySavingsPercentage sets the TotalEstimatedMonthlySavingsPercentage field's value.
func (s *ReservationPurchaseRecommendationSummary) SetTotalEstimatedMonthlySavingsPercentage(v string) *ReservationPurchaseRecommendationSummary {
	s.TotalEstimatedMonthlySavingsPercentage = &v
	return s
}

// A group of RIs that share a set of attributes.
type ReservationUtilizationGroup struct {
	_ struct{} `type:"structure"`

	// The attributes for this group of RIs.
	Attributes map[string]*string `type:"map"`

	// The key for a specific RI attribute.
	Key *string `type:"string"`

	// How much you used this group of RIs.
	Utilization *ReservationAggregates `type:"structure"`

	// The value of a specific RI attribute.
	Value *string `type:"string"`
}

// String returns the string representation
func (s ReservationUtilizationGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservationUtilizationGroup) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *ReservationUtilizationGroup) SetAttributes(v map[string]*string) *ReservationUtilizationGroup {
	s.Attributes = v
	return s
}

// SetKey sets the Key field's value.
func (s *ReservationUtilizationGroup) SetKey(v string) *ReservationUtilizationGroup {
	s.Key = &v
	return s
}

// SetUtilization sets the Utilization field's value.
func (s *ReservationUtilizationGroup) SetUtilization(v *ReservationAggregates) *ReservationUtilizationGroup {
	s.Utilization = v
	return s
}

// SetValue sets the Value field's value.
func (s *ReservationUtilizationGroup) SetValue(v string) *ReservationUtilizationGroup {
	s.Value = &v
	return s
}

// The result that is associated with a time period.
type ResultByTime struct {
	_ struct{} `type:"structure"`

	// Whether this result is estimated.
	Estimated *bool `type:"boolean"`

	// The groups that are included in this time period.
	Groups []*Group `type:"list"`

	// The time period covered by a result.
	TimePeriod *DateInterval `type:"structure"`

	// The total amount of cost or usage accrued during the time period.
	Total map[string]*MetricValue `type:"map"`
}

// String returns the string representation
func (s ResultByTime) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResultByTime) GoString() string {
	return s.String()
}

// SetEstimated sets the Estimated field's value.
func (s *ResultByTime) SetEstimated(v bool) *ResultByTime {
	s.Estimated = &v
	return s
}

// SetGroups sets the Groups field's value.
func (s *ResultByTime) SetGroups(v []*Group) *ResultByTime {
	s.Groups = v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *ResultByTime) SetTimePeriod(v *DateInterval) *ResultByTime {
	s.TimePeriod = v
	return s
}

// SetTotal sets the Total field's value.
func (s *ResultByTime) SetTotal(v map[string]*MetricValue) *ResultByTime {
	s.Total = v
	return s
}

// Hardware specifications for the service that you want recommendations for.
type ServiceSpecification struct {
	_ struct{} `type:"structure"`

	// The EC2 hardware specifications that you want AWS to provide recommendations
	// for.
	EC2Specification *EC2Specification `type:"structure"`
}

// String returns the string representation
func (s ServiceSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceSpecification) GoString() string {
	return s.String()
}

// SetEC2Specification sets the EC2Specification field's value.
func (s *ServiceSpecification) SetEC2Specification(v *EC2Specification) *ServiceSpecification {
	s.EC2Specification = v
	return s
}

// The values that are available for a tag.
type TagValues struct {
	_ struct{} `type:"structure"`

	// The key for a tag.
	Key *string `type:"string"`

	// The specific value of a tag.
	Values []*string `type:"list"`
}

// String returns the string representation
func (s TagValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagValues) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagValues) SetKey(v string) *TagValues {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *TagValues) SetValues(v []*string) *TagValues {
	s.Values = v
	return s
}

// The amount of utilization, in hours.
type UtilizationByTime struct {
	_ struct{} `type:"structure"`

	// The groups that are included in this utilization result.
	Groups []*ReservationUtilizationGroup `type:"list"`

	// The period of time over which this utilization was used.
	TimePeriod *DateInterval `type:"structure"`

	// The total number of RI hours that were used.
	Total *ReservationAggregates `type:"structure"`
}

// String returns the string representation
func (s UtilizationByTime) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UtilizationByTime) GoString() string {
	return s.String()
}

// SetGroups sets the Groups field's value.
func (s *UtilizationByTime) SetGroups(v []*ReservationUtilizationGroup) *UtilizationByTime {
	s.Groups = v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *UtilizationByTime) SetTimePeriod(v *DateInterval) *UtilizationByTime {
	s.TimePeriod = v
	return s
}

// SetTotal sets the Total field's value.
func (s *UtilizationByTime) SetTotal(v *ReservationAggregates) *UtilizationByTime {
	s.Total = v
	return s
}

const (
	// AccountScopePayer is a AccountScope enum value
	AccountScopePayer = "PAYER"
)

const (
	// ContextCostAndUsage is a Context enum value
	ContextCostAndUsage = "COST_AND_USAGE"

	// ContextReservations is a Context enum value
	ContextReservations = "RESERVATIONS"
)

const (
	// DimensionAz is a Dimension enum value
	DimensionAz = "AZ"

	// DimensionInstanceType is a Dimension enum value
	DimensionInstanceType = "INSTANCE_TYPE"

	// DimensionLinkedAccount is a Dimension enum value
	DimensionLinkedAccount = "LINKED_ACCOUNT"

	// DimensionOperation is a Dimension enum value
	DimensionOperation = "OPERATION"

	// DimensionPurchaseType is a Dimension enum value
	DimensionPurchaseType = "PURCHASE_TYPE"

	// DimensionRegion is a Dimension enum value
	DimensionRegion = "REGION"

	// DimensionService is a Dimension enum value
	DimensionService = "SERVICE"

	// DimensionUsageType is a Dimension enum value
	DimensionUsageType = "USAGE_TYPE"

	// DimensionUsageTypeGroup is a Dimension enum value
	DimensionUsageTypeGroup = "USAGE_TYPE_GROUP"

	// DimensionRecordType is a Dimension enum value
	DimensionRecordType = "RECORD_TYPE"

	// DimensionOperatingSystem is a Dimension enum value
	DimensionOperatingSystem = "OPERATING_SYSTEM"

	// DimensionTenancy is a Dimension enum value
	DimensionTenancy = "TENANCY"

	// DimensionScope is a Dimension enum value
	DimensionScope = "SCOPE"

	// DimensionPlatform is a Dimension enum value
	DimensionPlatform = "PLATFORM"

	// DimensionSubscriptionId is a Dimension enum value
	DimensionSubscriptionId = "SUBSCRIPTION_ID"

	// DimensionLegalEntityName is a Dimension enum value
	DimensionLegalEntityName = "LEGAL_ENTITY_NAME"

	// DimensionDeploymentOption is a Dimension enum value
	DimensionDeploymentOption = "DEPLOYMENT_OPTION"

	// DimensionDatabaseEngine is a Dimension enum value
	DimensionDatabaseEngine = "DATABASE_ENGINE"

	// DimensionCacheEngine is a Dimension enum value
	DimensionCacheEngine = "CACHE_ENGINE"

	// DimensionInstanceTypeFamily is a Dimension enum value
	DimensionInstanceTypeFamily = "INSTANCE_TYPE_FAMILY"
)

const (
	// GranularityDaily is a Granularity enum value
	GranularityDaily = "DAILY"

	// GranularityMonthly is a Granularity enum value
	GranularityMonthly = "MONTHLY"
)

const (
	// GroupDefinitionTypeDimension is a GroupDefinitionType enum value
	GroupDefinitionTypeDimension = "DIMENSION"

	// GroupDefinitionTypeTag is a GroupDefinitionType enum value
	GroupDefinitionTypeTag = "TAG"
)

const (
	// LookbackPeriodInDaysSevenDays is a LookbackPeriodInDays enum value
	LookbackPeriodInDaysSevenDays = "SEVEN_DAYS"

	// LookbackPeriodInDaysThirtyDays is a LookbackPeriodInDays enum value
	LookbackPeriodInDaysThirtyDays = "THIRTY_DAYS"

	// LookbackPeriodInDaysSixtyDays is a LookbackPeriodInDays enum value
	LookbackPeriodInDaysSixtyDays = "SIXTY_DAYS"
)

const (
	// OfferingClassStandard is a OfferingClass enum value
	OfferingClassStandard = "STANDARD"

	// OfferingClassConvertible is a OfferingClass enum value
	OfferingClassConvertible = "CONVERTIBLE"
)

const (
	// PaymentOptionNoUpfront is a PaymentOption enum value
	PaymentOptionNoUpfront = "NO_UPFRONT"

	// PaymentOptionPartialUpfront is a PaymentOption enum value
	PaymentOptionPartialUpfront = "PARTIAL_UPFRONT"

	// PaymentOptionAllUpfront is a PaymentOption enum value
	PaymentOptionAllUpfront = "ALL_UPFRONT"
)

const (
	// TermInYearsOneYear is a TermInYears enum value
	TermInYearsOneYear = "ONE_YEAR"

	// TermInYearsThreeYears is a TermInYears enum value
	TermInYearsThreeYears = "THREE_YEARS"
)
