// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package gamelift_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/gamelift"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleGameLift_CreateAlias() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.CreateAliasInput{
		Name: aws.String("NonBlankAndLengthConstraintString"), // Required
		RoutingStrategy: &gamelift.RoutingStrategy{ // Required
			FleetId: aws.String("FleetId"),
			Message: aws.String("FreeText"),
			Type:    aws.String("RoutingStrategyType"),
		},
		Description: aws.String("NonZeroAndMaxString"),
	}
	resp, err := svc.CreateAlias(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_CreateBuild() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.CreateBuildInput{
		Name:            aws.String("NonZeroAndMaxString"),
		OperatingSystem: aws.String("OperatingSystem"),
		StorageLocation: &gamelift.S3Location{
			Bucket:  aws.String("NonEmptyString"),
			Key:     aws.String("NonEmptyString"),
			RoleArn: aws.String("NonEmptyString"),
		},
		Version: aws.String("NonZeroAndMaxString"),
	}
	resp, err := svc.CreateBuild(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_CreateFleet() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.CreateFleetInput{
		BuildId:         aws.String("BuildId"),             // Required
		EC2InstanceType: aws.String("EC2InstanceType"),     // Required
		Name:            aws.String("NonZeroAndMaxString"), // Required
		Description:     aws.String("NonZeroAndMaxString"),
		EC2InboundPermissions: []*gamelift.IpPermission{
			{ // Required
				FromPort: aws.Int64(1),                 // Required
				IpRange:  aws.String("NonBlankString"), // Required
				Protocol: aws.String("IpProtocol"),     // Required
				ToPort:   aws.Int64(1),                 // Required
			},
			// More values...
		},
		LogPaths: []*string{
			aws.String("NonZeroAndMaxString"), // Required
			// More values...
		},
		NewGameSessionProtectionPolicy: aws.String("ProtectionPolicy"),
		ResourceCreationLimitPolicy: &gamelift.ResourceCreationLimitPolicy{
			NewGameSessionsPerCreator: aws.Int64(1),
			PolicyPeriodInMinutes:     aws.Int64(1),
		},
		RuntimeConfiguration: &gamelift.RuntimeConfiguration{
			ServerProcesses: []*gamelift.ServerProcess{
				{ // Required
					ConcurrentExecutions: aws.Int64(1),                      // Required
					LaunchPath:           aws.String("NonZeroAndMaxString"), // Required
					Parameters:           aws.String("NonZeroAndMaxString"),
				},
				// More values...
			},
		},
		ServerLaunchParameters: aws.String("NonZeroAndMaxString"),
		ServerLaunchPath:       aws.String("NonZeroAndMaxString"),
	}
	resp, err := svc.CreateFleet(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_CreateGameSession() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.CreateGameSessionInput{
		MaximumPlayerSessionCount: aws.Int64(1), // Required
		AliasId:                   aws.String("AliasId"),
		CreatorId:                 aws.String("NonZeroAndMaxString"),
		FleetId:                   aws.String("FleetId"),
		GameProperties: []*gamelift.GameProperty{
			{ // Required
				Key:   aws.String("GamePropertyKey"),   // Required
				Value: aws.String("GamePropertyValue"), // Required
			},
			// More values...
		},
		GameSessionId: aws.String("IdStringModel"),
		Name:          aws.String("NonZeroAndMaxString"),
	}
	resp, err := svc.CreateGameSession(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_CreateGameSessionQueue() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.CreateGameSessionQueueInput{
		Name: aws.String("GameSessionQueueName"), // Required
		Destinations: []*gamelift.GameSessionQueueDestination{
			{ // Required
				DestinationArn: aws.String("ArnStringModel"),
			},
			// More values...
		},
		TimeoutInSeconds: aws.Int64(1),
	}
	resp, err := svc.CreateGameSessionQueue(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_CreatePlayerSession() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.CreatePlayerSessionInput{
		GameSessionId: aws.String("ArnStringModel"),      // Required
		PlayerId:      aws.String("NonZeroAndMaxString"), // Required
		PlayerData:    aws.String("PlayerData"),
	}
	resp, err := svc.CreatePlayerSession(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_CreatePlayerSessions() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.CreatePlayerSessionsInput{
		GameSessionId: aws.String("ArnStringModel"), // Required
		PlayerIds: []*string{ // Required
			aws.String("NonZeroAndMaxString"), // Required
			// More values...
		},
		PlayerDataMap: map[string]*string{
			"Key": aws.String("PlayerData"), // Required
			// More values...
		},
	}
	resp, err := svc.CreatePlayerSessions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_DeleteAlias() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.DeleteAliasInput{
		AliasId: aws.String("AliasId"), // Required
	}
	resp, err := svc.DeleteAlias(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_DeleteBuild() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.DeleteBuildInput{
		BuildId: aws.String("BuildId"), // Required
	}
	resp, err := svc.DeleteBuild(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_DeleteFleet() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.DeleteFleetInput{
		FleetId: aws.String("FleetId"), // Required
	}
	resp, err := svc.DeleteFleet(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_DeleteGameSessionQueue() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.DeleteGameSessionQueueInput{
		Name: aws.String("GameSessionQueueName"), // Required
	}
	resp, err := svc.DeleteGameSessionQueue(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_DeleteScalingPolicy() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.DeleteScalingPolicyInput{
		FleetId: aws.String("FleetId"),             // Required
		Name:    aws.String("NonZeroAndMaxString"), // Required
	}
	resp, err := svc.DeleteScalingPolicy(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_DescribeAlias() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.DescribeAliasInput{
		AliasId: aws.String("AliasId"), // Required
	}
	resp, err := svc.DescribeAlias(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_DescribeBuild() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.DescribeBuildInput{
		BuildId: aws.String("BuildId"), // Required
	}
	resp, err := svc.DescribeBuild(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_DescribeEC2InstanceLimits() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.DescribeEC2InstanceLimitsInput{
		EC2InstanceType: aws.String("EC2InstanceType"),
	}
	resp, err := svc.DescribeEC2InstanceLimits(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_DescribeFleetAttributes() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.DescribeFleetAttributesInput{
		FleetIds: []*string{
			aws.String("FleetId"), // Required
			// More values...
		},
		Limit:     aws.Int64(1),
		NextToken: aws.String("NonZeroAndMaxString"),
	}
	resp, err := svc.DescribeFleetAttributes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_DescribeFleetCapacity() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.DescribeFleetCapacityInput{
		FleetIds: []*string{
			aws.String("FleetId"), // Required
			// More values...
		},
		Limit:     aws.Int64(1),
		NextToken: aws.String("NonZeroAndMaxString"),
	}
	resp, err := svc.DescribeFleetCapacity(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_DescribeFleetEvents() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.DescribeFleetEventsInput{
		FleetId:   aws.String("FleetId"), // Required
		EndTime:   aws.Time(time.Now()),
		Limit:     aws.Int64(1),
		NextToken: aws.String("NonZeroAndMaxString"),
		StartTime: aws.Time(time.Now()),
	}
	resp, err := svc.DescribeFleetEvents(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_DescribeFleetPortSettings() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.DescribeFleetPortSettingsInput{
		FleetId: aws.String("FleetId"), // Required
	}
	resp, err := svc.DescribeFleetPortSettings(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_DescribeFleetUtilization() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.DescribeFleetUtilizationInput{
		FleetIds: []*string{
			aws.String("FleetId"), // Required
			// More values...
		},
		Limit:     aws.Int64(1),
		NextToken: aws.String("NonZeroAndMaxString"),
	}
	resp, err := svc.DescribeFleetUtilization(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_DescribeGameSessionDetails() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.DescribeGameSessionDetailsInput{
		AliasId:       aws.String("AliasId"),
		FleetId:       aws.String("FleetId"),
		GameSessionId: aws.String("ArnStringModel"),
		Limit:         aws.Int64(1),
		NextToken:     aws.String("NonZeroAndMaxString"),
		StatusFilter:  aws.String("NonZeroAndMaxString"),
	}
	resp, err := svc.DescribeGameSessionDetails(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_DescribeGameSessionPlacement() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.DescribeGameSessionPlacementInput{
		PlacementId: aws.String("IdStringModel"), // Required
	}
	resp, err := svc.DescribeGameSessionPlacement(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_DescribeGameSessionQueues() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.DescribeGameSessionQueuesInput{
		Limit: aws.Int64(1),
		Names: []*string{
			aws.String("GameSessionQueueName"), // Required
			// More values...
		},
		NextToken: aws.String("NonZeroAndMaxString"),
	}
	resp, err := svc.DescribeGameSessionQueues(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_DescribeGameSessions() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.DescribeGameSessionsInput{
		AliasId:       aws.String("AliasId"),
		FleetId:       aws.String("FleetId"),
		GameSessionId: aws.String("ArnStringModel"),
		Limit:         aws.Int64(1),
		NextToken:     aws.String("NonZeroAndMaxString"),
		StatusFilter:  aws.String("NonZeroAndMaxString"),
	}
	resp, err := svc.DescribeGameSessions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_DescribeInstances() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.DescribeInstancesInput{
		FleetId:    aws.String("FleetId"), // Required
		InstanceId: aws.String("InstanceId"),
		Limit:      aws.Int64(1),
		NextToken:  aws.String("NonZeroAndMaxString"),
	}
	resp, err := svc.DescribeInstances(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_DescribePlayerSessions() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.DescribePlayerSessionsInput{
		GameSessionId:             aws.String("ArnStringModel"),
		Limit:                     aws.Int64(1),
		NextToken:                 aws.String("NonZeroAndMaxString"),
		PlayerId:                  aws.String("NonZeroAndMaxString"),
		PlayerSessionId:           aws.String("PlayerSessionId"),
		PlayerSessionStatusFilter: aws.String("NonZeroAndMaxString"),
	}
	resp, err := svc.DescribePlayerSessions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_DescribeRuntimeConfiguration() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.DescribeRuntimeConfigurationInput{
		FleetId: aws.String("FleetId"), // Required
	}
	resp, err := svc.DescribeRuntimeConfiguration(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_DescribeScalingPolicies() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.DescribeScalingPoliciesInput{
		FleetId:      aws.String("FleetId"), // Required
		Limit:        aws.Int64(1),
		NextToken:    aws.String("NonZeroAndMaxString"),
		StatusFilter: aws.String("ScalingStatusType"),
	}
	resp, err := svc.DescribeScalingPolicies(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_GetGameSessionLogUrl() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.GetGameSessionLogUrlInput{
		GameSessionId: aws.String("ArnStringModel"), // Required
	}
	resp, err := svc.GetGameSessionLogUrl(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_GetInstanceAccess() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.GetInstanceAccessInput{
		FleetId:    aws.String("FleetId"),    // Required
		InstanceId: aws.String("InstanceId"), // Required
	}
	resp, err := svc.GetInstanceAccess(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_ListAliases() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.ListAliasesInput{
		Limit:               aws.Int64(1),
		Name:                aws.String("NonEmptyString"),
		NextToken:           aws.String("NonEmptyString"),
		RoutingStrategyType: aws.String("RoutingStrategyType"),
	}
	resp, err := svc.ListAliases(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_ListBuilds() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.ListBuildsInput{
		Limit:     aws.Int64(1),
		NextToken: aws.String("NonEmptyString"),
		Status:    aws.String("BuildStatus"),
	}
	resp, err := svc.ListBuilds(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_ListFleets() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.ListFleetsInput{
		BuildId:   aws.String("BuildId"),
		Limit:     aws.Int64(1),
		NextToken: aws.String("NonZeroAndMaxString"),
	}
	resp, err := svc.ListFleets(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_PutScalingPolicy() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.PutScalingPolicyInput{
		ComparisonOperator:    aws.String("ComparisonOperatorType"), // Required
		EvaluationPeriods:     aws.Int64(1),                         // Required
		FleetId:               aws.String("FleetId"),                // Required
		MetricName:            aws.String("MetricName"),             // Required
		Name:                  aws.String("NonZeroAndMaxString"),    // Required
		ScalingAdjustment:     aws.Int64(1),                         // Required
		ScalingAdjustmentType: aws.String("ScalingAdjustmentType"),  // Required
		Threshold:             aws.Float64(1.0),                     // Required
	}
	resp, err := svc.PutScalingPolicy(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_RequestUploadCredentials() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.RequestUploadCredentialsInput{
		BuildId: aws.String("BuildId"), // Required
	}
	resp, err := svc.RequestUploadCredentials(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_ResolveAlias() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.ResolveAliasInput{
		AliasId: aws.String("AliasId"), // Required
	}
	resp, err := svc.ResolveAlias(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_SearchGameSessions() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.SearchGameSessionsInput{
		AliasId:          aws.String("AliasId"),
		FilterExpression: aws.String("NonZeroAndMaxString"),
		FleetId:          aws.String("FleetId"),
		Limit:            aws.Int64(1),
		NextToken:        aws.String("NonZeroAndMaxString"),
		SortExpression:   aws.String("NonZeroAndMaxString"),
	}
	resp, err := svc.SearchGameSessions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_StartGameSessionPlacement() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.StartGameSessionPlacementInput{
		GameSessionQueueName:      aws.String("GameSessionQueueName"), // Required
		MaximumPlayerSessionCount: aws.Int64(1),                       // Required
		PlacementId:               aws.String("IdStringModel"),        // Required
		DesiredPlayerSessions: []*gamelift.DesiredPlayerSession{
			{ // Required
				PlayerData: aws.String("PlayerData"),
				PlayerId:   aws.String("NonZeroAndMaxString"),
			},
			// More values...
		},
		GameProperties: []*gamelift.GameProperty{
			{ // Required
				Key:   aws.String("GamePropertyKey"),   // Required
				Value: aws.String("GamePropertyValue"), // Required
			},
			// More values...
		},
		GameSessionName: aws.String("NonZeroAndMaxString"),
		PlayerLatencies: []*gamelift.PlayerLatency{
			{ // Required
				LatencyInMilliseconds: aws.Float64(1.0),
				PlayerId:              aws.String("NonZeroAndMaxString"),
				RegionIdentifier:      aws.String("NonZeroAndMaxString"),
			},
			// More values...
		},
	}
	resp, err := svc.StartGameSessionPlacement(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_StopGameSessionPlacement() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.StopGameSessionPlacementInput{
		PlacementId: aws.String("IdStringModel"), // Required
	}
	resp, err := svc.StopGameSessionPlacement(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_UpdateAlias() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.UpdateAliasInput{
		AliasId:     aws.String("AliasId"), // Required
		Description: aws.String("NonZeroAndMaxString"),
		Name:        aws.String("NonBlankAndLengthConstraintString"),
		RoutingStrategy: &gamelift.RoutingStrategy{
			FleetId: aws.String("FleetId"),
			Message: aws.String("FreeText"),
			Type:    aws.String("RoutingStrategyType"),
		},
	}
	resp, err := svc.UpdateAlias(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_UpdateBuild() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.UpdateBuildInput{
		BuildId: aws.String("BuildId"), // Required
		Name:    aws.String("NonZeroAndMaxString"),
		Version: aws.String("NonZeroAndMaxString"),
	}
	resp, err := svc.UpdateBuild(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_UpdateFleetAttributes() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.UpdateFleetAttributesInput{
		FleetId:     aws.String("FleetId"), // Required
		Description: aws.String("NonZeroAndMaxString"),
		Name:        aws.String("NonZeroAndMaxString"),
		NewGameSessionProtectionPolicy: aws.String("ProtectionPolicy"),
		ResourceCreationLimitPolicy: &gamelift.ResourceCreationLimitPolicy{
			NewGameSessionsPerCreator: aws.Int64(1),
			PolicyPeriodInMinutes:     aws.Int64(1),
		},
	}
	resp, err := svc.UpdateFleetAttributes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_UpdateFleetCapacity() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.UpdateFleetCapacityInput{
		FleetId:          aws.String("FleetId"), // Required
		DesiredInstances: aws.Int64(1),
		MaxSize:          aws.Int64(1),
		MinSize:          aws.Int64(1),
	}
	resp, err := svc.UpdateFleetCapacity(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_UpdateFleetPortSettings() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.UpdateFleetPortSettingsInput{
		FleetId: aws.String("FleetId"), // Required
		InboundPermissionAuthorizations: []*gamelift.IpPermission{
			{ // Required
				FromPort: aws.Int64(1),                 // Required
				IpRange:  aws.String("NonBlankString"), // Required
				Protocol: aws.String("IpProtocol"),     // Required
				ToPort:   aws.Int64(1),                 // Required
			},
			// More values...
		},
		InboundPermissionRevocations: []*gamelift.IpPermission{
			{ // Required
				FromPort: aws.Int64(1),                 // Required
				IpRange:  aws.String("NonBlankString"), // Required
				Protocol: aws.String("IpProtocol"),     // Required
				ToPort:   aws.Int64(1),                 // Required
			},
			// More values...
		},
	}
	resp, err := svc.UpdateFleetPortSettings(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_UpdateGameSession() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.UpdateGameSessionInput{
		GameSessionId:             aws.String("ArnStringModel"), // Required
		MaximumPlayerSessionCount: aws.Int64(1),
		Name: aws.String("NonZeroAndMaxString"),
		PlayerSessionCreationPolicy: aws.String("PlayerSessionCreationPolicy"),
		ProtectionPolicy:            aws.String("ProtectionPolicy"),
	}
	resp, err := svc.UpdateGameSession(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_UpdateGameSessionQueue() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.UpdateGameSessionQueueInput{
		Name: aws.String("GameSessionQueueName"), // Required
		Destinations: []*gamelift.GameSessionQueueDestination{
			{ // Required
				DestinationArn: aws.String("ArnStringModel"),
			},
			// More values...
		},
		TimeoutInSeconds: aws.Int64(1),
	}
	resp, err := svc.UpdateGameSessionQueue(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleGameLift_UpdateRuntimeConfiguration() {
	sess := session.Must(session.NewSession())

	svc := gamelift.New(sess)

	params := &gamelift.UpdateRuntimeConfigurationInput{
		FleetId: aws.String("FleetId"), // Required
		RuntimeConfiguration: &gamelift.RuntimeConfiguration{ // Required
			ServerProcesses: []*gamelift.ServerProcess{
				{ // Required
					ConcurrentExecutions: aws.Int64(1),                      // Required
					LaunchPath:           aws.String("NonZeroAndMaxString"), // Required
					Parameters:           aws.String("NonZeroAndMaxString"),
				},
				// More values...
			},
		},
	}
	resp, err := svc.UpdateRuntimeConfiguration(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
