/**********************************************************************
 ** modules - this is where the code for conversion modules will go
 **
 **
 **********************************************************************/

#ifndef MODULES_C
#define MODULES_C

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "modules.h"
#include "../../include/strings.h"
#include "../../include/lexer.h"
#include "../../include/config.h"
#include "../../include/mudtypes.h"
#include "../../include/sysdep.h"

/***********************************************************************
 ** verify_version - verifies that the version given has a module to
 **                  convert from it
 **
 ** Parameters: the_version - the version we are checking for
 **
 ** Returns: 1 for found, 0 for not found
 **
 ***********************************************************************/

int verify_version(char *the_version)
{
   int i = 0;

   while (mod_list[i].module_name != NULL)
   {
      if (!STRCASECMP(the_version, mod_list[i].module_name))
         return 1;
      i++;
   }
   return 0;
}


/***********************************************************************
 ** ask_version - asks the player for the version since we can't seem to
 **               detect the version
 **
 ** Parameters: the_str - the string object to write the version into
 **
 ** Returns: 1 for found, 0 for nothing found
 **
 ***********************************************************************/

int ask_version(Strings *the_str)
{
   int  i = 0;
   int  count = 0;
   char user_input[10];
   int  answer = -1;
   int  user_num;

   printf("                        Available Versions\n");
   printf("----------------------------------------------------------------------\n\n");

   while (mod_list[i].module_name != NULL)
   {
      printf("%d. %-20s   ", i, mod_list[i].module_name);
      count++;
      if (count == 3)
      {
         printf("\n");
         count = 0;
      }
      i++;
   }
   if (count == 3)
      printf("\n");

   printf("%d. None\n\n\n", i);

   while (answer == -1)
   {
      printf("Please select a version: ");
      fflush(stdout);

      fgets(user_input, 10, stdin);
      if (!isdigit(user_input[0]))
      {
         printf("You must select a number, 0-%d.\n", i);
         continue;
      }
      
      user_num = atoi(user_input);
      if ((user_num < 0) || (user_num > i))
      {
         printf("You must select a number, 0-%d.\n", i);
         continue;
      }

      answer = user_num;
   }
   
   if (answer == i)
      the_str->str_copy("none");
   else
      the_str->str_copy(mod_list[answer].module_name);

   return 0;
}


/***********************************************************************
 ** convert_file - the function that calls the appropriate conversion
 **                file based on what we are converting from
 **
 ** Parameters: read_file - the file to read in from
 **             write_filename - the filename to write the converted data to
 **             format - the format, if any, we are forcing recognition of
 **
 ** Returns: 1 for success, 0 for no convert needed, -1 for an error
 **
 ***********************************************************************/

int convert_file(FILE *read_file, char *write_filename, char *format, 
                                                            char *filename)
{
   Strings the_version;
   token_record *the_token;
   FILE *write_file;
   int results;

   if ((format != NULL) && strncmp(format, "AIME Version 0.", 15))
   {
      the_version = format;
      if (!STRCASECMP(the_version.str_show(), FULLVERSION))
      {
         printf("\nVersion already current.\n");
         return 0;
      }

      if (!verify_version(the_version.str_show()))
      {
#ifdef WIN32
		  AfxMessageBox("The stated version is not supported");
		  return -1;
#else
         printf("\n\nThe stated version '%s' is not supported.\n\n",
                                            the_version.str_show());
         ask_version(&the_version);
#endif
      }

      if ((write_file = fopen(write_filename, "w")) == NULL)
      {
         printf("Could not open write file '%s'\n", write_filename);
         return -1;
      }

      results = execute_convert(the_version.str_show(), read_file, write_file,
                                                                filename);   
	  fclose(write_file);
	  return results;
   }   

   /* next read in the version number this template converts to */
   the_token = get_token(read_file, '\0');
   if (the_token->token_type != T_CARROT)
   {
#ifdef WIN32
	   AfxMessageBox("No version detected in file.");
	   return -1;
#else
      printf("No version detected.\n");
      ask_version(&the_version);
#endif
      if (!STRCASECMP(the_version.str_show(), "none"))
         return 0;

      if ((write_file = fopen(write_filename, "w")) == NULL)
      {
         printf("Could not open write file '%s'\n", write_filename);
         return -1;
      }

      results = execute_convert(the_version.str_show(), read_file, write_file,
                                                               filename);
	  fclose(write_file);
	  return results;
   }
   the_token = get_token(read_file, '^');
   the_version = the_token->the_string;

   if (the_version.str_show() == NULL)
   {
#ifdef WIN32
	  AfxMessageBox("The detected version is not supported.\n");
	  return 0;
#else
      printf("No version was detected.\n");
      ask_version(&the_version);
#endif
   }
   else if (!verify_version(the_version.str_show()))
   {
      the_version = format;
      if (!STRCASECMP(the_version.str_show(), FULLVERSION))
      {
         printf("\nVersion already current.\n");
         return 0;
      }

#ifndef WIN32
      printf("The detected version '%s' is not supported.\n", 
                                                 the_version.str_show());
      ask_version(&the_version);
#else
	  AfxMessageBox("The detected version is not supported.\n");
	  return 0;
#endif
   }

   printf("Version detected: %s\n", the_version.str_show());

   if ((write_file = fopen(write_filename, "w")) == NULL)
   {
      printf("Could not open write file '%s'\n", write_filename);
      return -1;
   }

   results = execute_convert(the_version.str_show(), read_file, write_file,
                                                                 filename);
   fclose(write_file);
   return results;
}


/***********************************************************************
 ** execute_convert - the function that calls the appropriate convert
 **                   function based on the version
 **
 ** Parameters: the_version - the version for the file we are reading in
 **             read_file - the file to read in from
 **             write_file - the file to write the converted data to
 **
 ** Returns: 1 for success, -1 for failure
 **
 ***********************************************************************/

int execute_convert(char *the_version, FILE *read_file, FILE *write_file,
                                                        char *filename)
{
   int i = 0;

   while (mod_list[i].module_name != NULL)
   {
      if (!STRCASECMP(the_version, mod_list[i].module_name))
         break;
      i++;
   }

   if (mod_list[i].module_name == NULL)
      return -1;

   printf("Converting file...\n");
   return mod_list[i].the_func(read_file, write_file, filename, mod_list[i].number);
}


/***********************************************************************
 ** convert_all - converts all files in the aime directory
 **
 ** Parameters: format - the format, if any, we are forcing recognition of
 **
 ** Returns: a pointer to the created string
 **
 ***********************************************************************/

int convert_all(char *format)
{
   Strings filename;
   char    tmp_file[(MAXNAMELEN*2)];
   FILE    *listfile;
   FILE    *read_file;
   char    *tmp_char;
   char    *last_slash = NULL;

   printf("Converting old files to: ../backup.\n");
   system("mkdir ../backup");
 
   //   system("cp ../areas/*.area ../backup");

   //   system("cp ../data/*.dat ../backup");

   printf("Getting directory of all files to convert.\n");
   system("ls ../data/*.dat > ../backup/listdat");

   system("ls ../areas/*.area > ../backup/listarea");

   printf("Converting all \033[1;37mdata\033[40m\033[0m files.\n");
   filename.sprintf("../backup/listdat");
   if ((listfile = fopen(filename.str_show(), "r")) == NULL)
   {
      printf("Could not get list of data files...failed.\n");
      return -1;
   }

   while (fgets(tmp_file, (MAXNAMELEN*2)-1, listfile) != NULL)
   {
      tmp_char = &tmp_file[0];
      while ((*tmp_char) && (*tmp_char != '\n'))
         tmp_char++;

      if (*tmp_char)
         *tmp_char = '\0';

      if ((read_file = fopen(tmp_file, "r")) == NULL)
      {
         printf("Could not open read file '%s'\n", tmp_file);
         continue;
      }

      tmp_char = &tmp_file[0];
      while (*tmp_char)
      {
         if (*tmp_char == '/')
            last_slash = tmp_char;
         tmp_char++;
      }

      last_slash++;

      filename.sprintf("../backup/%s", last_slash);

      printf("Converting file: %s\n", last_slash);
      if (convert_file(read_file, filename.str_show(), format, last_slash) < 0)
         exit(0);

      if (read_file != NULL)
         fclose(read_file);
   }

   printf("Converting all \033[1;37marea\033[40m\033[0m files.\n");
   filename.sprintf("../backup/listarea");
   if ((listfile = fopen(filename.str_show(), "r")) == NULL)
   {
      printf("Could not get list of area files...failed.\n");
      return -1;
   }

   while (fgets(tmp_file, (MAXNAMELEN*2)-1, listfile) != NULL)
   {
      tmp_char = &tmp_file[0];
      while ((*tmp_char) && (*tmp_char != '\n'))
         tmp_char++;

      if (*tmp_char)
         *tmp_char = '\0';

      if ((read_file = fopen(tmp_file, "r")) == NULL)
      {
         printf("Could not open read file '%s'\n", tmp_file);
         continue;
      }

      tmp_char = &tmp_file[0];
      while (*tmp_char)
      {
         if (*tmp_char == '/')
            last_slash = tmp_char;
         tmp_char++;
      }

      last_slash++;

      filename.sprintf("../backup/%s", last_slash);

      printf("Converting file: %s\n", last_slash);
      if (convert_file(read_file, filename.str_show(), format, last_slash) <= 0)
         exit(0);
   }

   printf("Conversion of all files complete!\n");
   printf("Copying converted files to main files.\n");
   
   system("mv ../backup/*.area ../areas");

   system("mv ../backup/*.dat ../data");

   //   system("rm -r ../backup");
   printf("Successful!\n");

#ifndef WIN32
   sleep(5);
#endif
   return 1;
}


#endif



