
#ifndef GENERATOR_H
#define GENERATOR_H

#include <time.h>
#include "../../include/strings.h"
#include "../../include/lexer.h"
#include "../../include/ability.h"

struct conv_MudObject {
   Strings name;
   Strings title;
   Strings altname;
   Strings clones;
   Strings location;
   Strings special_str;
   Strings desc;
   int     capacity;
};

struct conv_Item {
   Strings guard;
   long    flag[2];
   conv_MudObject *the_mudobj;
};

struct conv_Moveable {
   Strings brief[2];
   int     size;
   int     weight;
   int     num_allowed;
   int     percent_allowed;
   conv_Item *the_item;
};

#define DEF_ROOM_SIZE 10
#define DEF_TERRAIN    4
#define DEF_LIGHTING   3

struct conv_Location {
   Strings exit[10];
   Strings extra_dir;
   Strings listen;
   Strings smell;
   Strings extra_desc[2];
   int     room_size;
   int     terrain;
   int     lighting;
   long    flag[2];
   conv_MudObject *tmp_mudobj;
};

#define DOOR_MAXSTATE 3

struct conv_Door {
   Strings key_names;
   int     door_state;
   Strings inside_brief[DOOR_MAXSTATE+1];
   Strings outside_loc;
   Strings outside_desc;
   Strings outside_brief[DOOR_MAXSTATE+1];
   int     distance;
   Strings rope_name;
   conv_Item *tmp_item;
};

struct conv_Book {
   Strings subject;
   conv_Moveable *tmp_move;
};


struct conv_Com_List {
   Strings  the_keywords;
   Strings  the_reply;
   conv_Com_List *next_com;
};

struct conv_shop_item {
   Strings itemname;
   Strings alias;
   int     value;
   int     item_type;
   int     number_of;
   Strings desc;
   conv_shop_item *next_item;
};

struct conv_Shop {
   Strings name;
   Strings currency;
   conv_shop_item *item_list;
};

struct conv_Mobile {
   Strings brief;
   Strings subarea;
   Strings start_wield[2];
   Strings start_wear;
   Strings bare_weapon;
   int     strength;
   int     dexterity;
   int     constitution;
   int     intel;
   int     wisdom;
   int     charisma;
   long    flag[2];
   int     speed;
   int     aggression;
   conv_Com_List *com_list;
   conv_Shop *the_shop;
   conv_MudObject *the_mudobj;
};

struct conv_Weapon {
   Strings weapon_class;
   int     damage;
   int     dep_strength;
   int     dep_dex;
   int     wield_type;
   conv_Moveable *the_move;
};

struct conv_Wearable {
   int     armor;
   long    flag;
   conv_Moveable *the_move;
};

struct conv_Merger {
   int     number_of;
   conv_Moveable *the_move;
};

struct conv_Food {
   int     energy;
   conv_Merger *the_merger;
};

struct conv_Specials {
   Strings name;
   Strings trigger;
   time_t  activation;
   time_t  interval;
   int     num_times;
   long    counter;
   Strings code;
   Strings comments;
};

struct conv_Money {
   int money_index;
   conv_Merger *the_merger;
};

struct conv_dependency {
	depend_type		 the_type;
	int				 num_value;
	Strings          str_value;
	conv_dependency  *next_depend;
};

struct conv_Ability {
   Strings name;
   Strings acting_str[3];
   Strings success_str[3];
   Strings fail_str[3];
   Strings special_name;
   Strings succ_trig;
   Strings fail_trig;
   Strings attempt_trig;
   int     drain;
   conv_dependency *depend_list;
   conv_MudObject *the_mudobj;
};

struct conv_Spell {
   long    flag;
   conv_Ability *the_abil;
};

struct conv_Skill {
   long    flag;
   conv_Ability *the_abil;
};

struct conv_Action {
   Strings name;
   Strings actor;
   Strings crowd;
   Strings target;
   Strings sender;
   Strings bystander;
   long    flag;
};

#define DEF_DEATH_LOC  "needloc@needarea"
#define DEF_DEATH_TEXT "No death text"
#define DEF_INIT_LOC   "needloc@needarea"

struct conv_tutorial {
   Strings  name;
   int      sequence;
   Strings  prompt;
   Strings  tutorial_special;
   int      mandatory;
   conv_tutorial *next_tut;
};

struct conv_Race {
   Strings name;
   Strings description;
   Strings init_desc;
   Strings init_brief;
   Strings init_ability;
   Strings init_location;
   Strings death_location;
   Strings death_text;
   Strings allow_incl;
   Strings allow_talent;
   int     init_str;
   int     init_dex;
   int     init_intel;
   int     init_con;
   int     init_wis;
   int    init_cha;
   conv_tutorial *tutorial_list;
};

struct conv_Boat {
   Strings move_str;
   Strings water_brief;
   conv_Moveable *tmp_move;
};

struct conv_Rope {
   int     rope_len;
   conv_Moveable *tmp_move;
};

struct conv_Quest {
   Strings name;
   Strings description;
   int     difficulty;
   int     puzzles;
   int     combat;
   int     qpoints;
   int     required;
};

struct conv_Level {
   Strings name;
   Strings chain_name;
   Strings award_str;
   Strings level_str;
   int     lvl_num;
   int     min_str;
   int     min_dex;
   int     min_intel;
   int     min_exp;
   int     min_con;
   int     min_wis;
   int     min_cha;
   Strings req_abilities;
   Strings special_req_str;
   Strings when_awarded_str;
   long    flag;
};

struct conv_Mask {
   Strings name;
   long    comflag[6];
   long    adminflag[6];
};

struct conv_Inclination {
   Strings name;
   Strings desc;
   Strings special;
   int     str_offset;
   int     dex_offset;
   int     con_offset;
   int     intel_offset;
   int     wisdom_offset;
   int     charisma_offset;
};

struct conv_Talent {
   Strings name;
   Strings desc;
   Strings special;
   int     cost;
   int     allowed;
};

struct conv_Header {
	Strings read_deny;
	Strings write_allow;
	long flag1;
	long flag2;
	long reload_secs;
};

struct conv_ChatLine {
  Strings name;
  Strings lead_in_actor;
  Strings lead_in_crowd;
  Strings text_color;
  Strings border;
  long flag1;
};

class Generator
{
public:
	int generate_element(FILE *the_file);
	Generator(FILE *write_to, int is_long_header);

private:
   void write_mudobj_fields(char *objtype, conv_MudObject *the_mudobj);
   void write_item_fields(conv_Item *the_item);
   void write_moveable_fields(conv_Moveable *the_move);
   void write_merger_fields(conv_Merger *the_merger);
   void write_ability_fields(char *objtype, conv_Ability *the_ability);

   int read_ml_string(FILE *the_file, Strings *the_string);
   int check_mudobj_fields(FILE *the_file, token_record *the_token, 
			   conv_MudObject *tmp_mudobj);
   int check_item_fields(FILE *the_file, token_record *the_token, 
			  conv_Item *tmp_item);
   int check_moveable_fields(FILE *the_file, token_record *the_token, 
			     conv_Moveable *tmp_move);
   int check_merger_fields(FILE *the_file, token_record *the_token, 
			   conv_Merger *tmp_merger);
   int check_ability_fields(FILE *the_file, token_record *the_token, 
			    conv_Ability *tmp_ability);

   long read_long(FILE *the_file);
   int read_int(FILE *the_file);
   int read_sl_string(FILE *the_file, Strings *the_string);

   void delete_mobile(conv_Mobile *the_mob);
   void delete_moveable(conv_Moveable *the_move);
   void delete_ability(conv_Ability *the_ability);
   void delete_race(conv_Race *the_race);

   void init_mudobject(conv_MudObject *the_mudobj);
   void init_item(conv_Item *the_item);
   void init_moveable(conv_Moveable *the_move);
   void init_merger(conv_Merger *the_merger);
   void init_ability(conv_Ability *the_ability);

   conv_Header *read_header(FILE *the_file);
   conv_Location *read_location(FILE *the_file);
   conv_Mobile * read_mobile(FILE *the_file);
   conv_Door * read_door(FILE *the_file);
   conv_Book * read_book(FILE *the_file);
   conv_Weapon * read_weapon(FILE *the_file);
   conv_Wearable * read_wearable(FILE *the_file);
   conv_Merger *read_merger(FILE *the_file);
   conv_Food * read_food(FILE *the_file);
   conv_Money * read_money(FILE *the_file);
   conv_Specials * read_specials(FILE *the_file);
   conv_Spell * read_spell(FILE *the_file);
   conv_Skill * read_skill(FILE *the_file);
   conv_Item *read_marker(FILE *the_file);
   conv_Boat *read_boat(FILE *the_file);
   conv_Rope *read_rope(FILE *the_file);	
   conv_Action *read_action(FILE *the_file);
   conv_Race *read_race(FILE *the_file);
   conv_Quest *read_quest(FILE *the_file);
   conv_Mask *read_mask(FILE *the_file);
   conv_Inclination *read_inclination(FILE *the_file);
   conv_Talent *read_talent(FILE *the_file);
   conv_Level *read_level(FILE *the_file);
   conv_ChatLine *read_chatline(FILE *the_file);
   conv_Moveable *read_moveable(FILE *the_file);

   void write_location(conv_Location *the_loc);
   void write_mobile(conv_Mobile *the_mob);
   void write_header(conv_Header *the_header);
   void write_weapon(conv_Weapon *the_weapon);
   void write_marker(conv_Item *the_marker);
   void write_wearable(conv_Wearable *the_wearable);
   void write_door(conv_Door *the_door);
   void write_book(conv_Book *the_book);
   void write_merger(conv_Merger *the_merger);
   void write_food(conv_Food *the_food);
   void write_money(conv_Money *the_money);
   void write_special(conv_Specials *the_special);
   void write_rope(conv_Rope *the_rope);
   void write_boat(conv_Boat *the_boat);
   void write_skill(conv_Skill *the_skill);
   void write_spell(conv_Spell *the_spell);
   void write_action(conv_Action *the_action);
   void write_race(conv_Race *the_race);
   void write_quest(conv_Quest *the_quest);
   void write_levels(conv_Level *the_levels);
   void write_mask(conv_Mask *the_mask);
   void write_inclination(conv_Inclination *the_incl);
   void write_talent(conv_Talent *the_talent);
   void write_chatline(conv_ChatLine *the_chatline);
   void write_moveable(conv_Moveable *the_moveable);

   void ignore_entry(FILE *the_file);

   int long_header;
   FILE *write_file;
};

#endif

