/**********************************************************************
 ** DirRead class: Reads in a directory and provides methods for displaying
 **                elements in a directory
 **
 **
 **
 ** Last reviewed:
 **
 **
 ** Copyright (C) 2000, 2001 George Noel (Slate)
 **
 **   This program is free software; you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as
 **   published by the Free Software Foundation; either version 2 of the 
 **   License, or any later version. 
 **
 **   This program is distributed in the hope that it will be useful, but 
 **   WITHOUT ANY WARRANTY; without even the implied warranty of 
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 **   General Public License for more details. 
 ** 
 **   You should have received a copy of the GNU General Public License 
 **   along with this program (in the docs dir); if not, write to the Free
 **   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 **
 **********************************************************************/

#ifndef DIRREAD_C
#define DIRREAD_C

#include <string.h>
#include <dirent.h>
#include "dirread.h"

/***********************************************************************
 ** DirRead (constructor) - Opens the directory
 **
 ** Parameters: None
 **
 ** Returns: Nothing
 **
 ***********************************************************************/

DirRead::DirRead(char *dirname)
{
   valid = 0;
   if ((dirptr = opendir(dirname)) == NULL)
     return;

   valid = 1;
}


/***********************************************************************
 ** ~DirRead (destructor) - closes the directory
 **
 ** Parameters: None
 **
 ** Returns: Nothing
 **
 ***********************************************************************/

DirRead::~DirRead()
{ 
   closedir(dirptr);
}


/***********************************************************************
 ** get_next - gets the next file in the directory
 **
 ** Parameters: pattern - the pattern to search for in a filename
 **
 ** Returns: pointer to the filename if success
 **
 ***********************************************************************/

char *DirRead::get_next(char *pattern)
{
  dirent *ent_ptr;
  char *strptr1;
  char *strptr2;
  int found = 0;
  char *foundptr;

  strptr1 = pattern;
  strptr2 = pattern;
  while ((strptr2) && (*strptr2 != '\0') && (*strptr2 != '*'))
    strptr2++;

  if ((strptr2) && (*strptr2 != '\0'))
  {
     *strptr2 = '\0';
     strptr2++;
  }

  // Search through the directories while the pattern doesn't match
  while (!found)
  {
    if ((ent_ptr = readdir(dirptr)) == NULL)
      return NULL;

    if (pattern == NULL)
      return ent_ptr->d_name;

    if ((foundptr = strstr(ent_ptr->d_name, strptr1)) != NULL)
    {
      if ((!strptr2) || (*strptr2 == '\0') || 
	  ((foundptr = strstr(ent_ptr->d_name, strptr2)) != NULL))
      {
	if (!strcmp(foundptr, pattern))
	   return ent_ptr->d_name;
      }
    }
  }
}

char *DirRead::get_next()
{
  return get_next(NULL);
}


/***********************************************************************
 ** is_valid - is the log valid (no errors opening, etc) 
 **
 ** Returns: 1 for valid, 0 for not
 **
 ***********************************************************************/

int DirRead::is_valid()
{
  return valid;
}


/***********************************************************************
 ** rewind - start the directory at the beginning
 **
 ***********************************************************************/

void DirRead::rewind()
{
  rewinddir(dirptr);
}


#endif


