#ifndef _SPECIALS_H
#define _SPECIALS_H

#include <stdlib.h>
#include <time.h>

#include "entity.h"

class Builder;
class Code;
class ErrLog;

#define VAR_TYPE_STRING  1
#define VAR_TYPE_INT     2
#define VAR_TYPE_OBJNAME 3
#define VAR_TYPE_CODE    4
#define VAR_TYPE_GOTO    5
#define VAR_TYPE_VAR     6


/* the union to hold the parameter in whatever type it is */
union var_ptrs {
   Strings *a_string;
   long    *an_int;
   Code    *a_code;
   Code    **goto_code;
};


/* holds a variable */
struct vars {
   Strings   varname;
   int       vartype;
   var_ptrs  the_ptr;
   vars      *next_var;
};


/* this is the special execution environment, stores all information pertinant
   to a particular execution */
struct special_env {
   Strings trig_used;
   Strings target_str;
   int  counter;
   int  store_int;
   vars *exec_vars;
   Code *stack_pointer;
};


class Specials : public Entity {
public:
   Specials(char *spec_name, char *the_area);
   virtual ~Specials();
   int set_trigger(char *the_trigger);
   char *get_trigger();
   void set_activation_date(time_t the_time);
   void set_interval(time_t the_time);
   void set_num_times(int the_num);
   int  is_expired(void);

   int read_code(FILE *the_file, ErrLog *the_log, int is_build_port);

   int run_special(Player *the_player, in_params *the_params, 
                                                   special_env *environment);
   vars *get_var(char *the_var_name);
   // void set_stack_pointer(Code *the_code);

   int set_code_str(char *the_string);
   char *get_code_str();
   int edit_code_str(Builder *the_builder);
   int edit_comments(Builder *the_builder);
   time_t get_activation();
   time_t get_interval();
   int get_num_times();
   void set_counter(long the_val);
   long get_counter();
   void set_comments(char *the_str);
   char *get_comments();
   int  set_attrib_comments(Builder *the_builder);

   virtual void write_object(FILE *the_file, int build_format);
   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_player);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);
   virtual int copy_object(Entity *copy_obj);

   Code *copy_code();
   vars *copy_var_list();

   int set_attrib_trigger(Parse *the_parsed, Builder *the_builder);
   int set_special(Builder *the_builder, Parse *the_parsed);
   int set_special_counter(Builder *the_builder, Parse *the_parsed);

   int set_special(Builder *the_builder);
   int read_specials_attrib(FILE *read_file, ErrLog *error_log, 
                                      int build_format, int is_build_port);
   virtual int get_mem_size();
   virtual int get_mem_size_dynamic();
   void disp_time_stats(Player *the_player);

private:

   char *read_code_type(FILE *read_file);
   int add_code(Code *new_code);
   int add_var(vars *new_var);

   Strings triggername;
   time_t  activation;
   time_t  interval;
   int     num_times;

   long    counter;   // can be used by the special, maybe to count down
                      // time left to burn for a torch or something

   Code    *the_code;
   vars    *var_list;

   Strings code_string;  // used for building the code in builder port

   Strings comments;     // so builders can comment their specials

   int     expired;

   /* time to loop through */
   long num_exe;
   long max_exe;
   long avg_exe;
   long min_exe;
};

#endif


