#ifndef _QUEST_H
#define _QUEST_H

#include "mudtypes.h"
#include "strings.h"
#include "errlog.h"
#include "parse.h"
#include "flags.h"
#include "entity.h"
#include "config.h"


class Player;
class Builder;

enum diff_type {Easy, Medium, Hard};
enum stat_type {NotStarted, Completed};

class Quest : public Entity {
 public:

   Quest();
   virtual ~Quest();
   Quest(char *quest_name);

   int set_description(char *the_string);
   char *get_description();
   void set_difficulty(diff_type new_diff);
   diff_type get_difficulty();

   void set_puzzles(int new_val);
   int  get_puzzles();
   void set_combat(int new_val);
   int  get_combat();
   void set_qpoints(int new_val);
   int  get_qpoints();
   void set_required(int new_val);
   int  get_required();

   int load_quest(FILE *the_file, ErrLog *error_log, int is_builder);
   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_player);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);
   virtual int copy_object(Entity *copy_obj);

   void write_object(FILE *the_file, int is_builder);
   int is_modified();
   void set_modified(int the_num);

   int display_qinfo(Player *the_player);
   virtual int get_mem_size();
   virtual int get_mem_size_dynamic();



 private:

   int       modified;

   Strings   description;

   diff_type difficulty;
   int       puzzles;
   int       combat;
   int       qpoints;
   int       required;

   stat_type status;
};


#endif
