#include "mailfilterdialog.h"

#include <qcombobox.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qtoolbutton.h>
#include <qwidgetstack.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>

#include <kconfig.h>
#include <klocale.h>


#include "clientvfs.h"

static const char* const image0_data[] = {
"22 22 145 2",
"Qt c None",
".j c #000000",
"#K c #020202",
"#i c #060606",
".i c #080808",
"#. c #0c0c0c",
".h c #101010",
".1 c #131313",
".u c #141414",
".g c #181818",
".U c #191919",
".N c #1f1f1f",
".f c #212121",
".H c #262626",
".e c #292929",
".B c #2c2c2c",
".d c #313131",
".A c #333333",
".x c #393939",
".c c #3a3a3a",
".y c #3e3e3e",
".w c #3f3f3f",
".b c #424242",
".q c #464646",
".a c #4a4a4a",
".k c #4c4c4c",
".# c #535353",
".G c #857f7a",
".p c #989898",
".M c #a09b97",
".o c #b4b4b4",
".F c #b8b1a9",
".T c #bbb2ab",
".0 c #c6b8ac",
".n c #c6c6c6",
"ao c #c7a081",
"ab c #c8a487",
"an c #c8a488",
"#3 c #c9a88d",
"am c #c9a88e",
".v c #c9c9c9",
"#V c #cbac93",
"al c #cbad94",
"#J c #ccb099",
"ak c #cdb09a",
"#D c #ceb49f",
"aj c #ceb5a0",
"#r c #cfb8a5",
"ai c #cfb8a6",
".E c #cfcbc4",
"#h c #d0bcab",
".L c #d0c8c1",
"ah c #d1bdac",
".9 c #d2c0b1",
"ag c #d2c0b2",
"af c #d4c4b8",
"ae c #d6c8be",
".m c #d6d6d6",
"ad c #d7ccc4",
"ac c #d8d0ca",
".l c #dedede",
".z c #e0e0e0",
".t c #e1e1e1",
".K c #e4e0db",
"aa c #e7c2a2",
"a# c #e8c5a6",
"#2 c #e9c5a6",
"a. c #eac9ac",
"#U c #eac9ad",
".S c #eadfd5",
"#9 c #eccdb3",
"#T c #ecceb4",
"#I c #ecceb5",
".s c #ececec",
"#1 c #eed2ba",
"#S c #eed2bb",
"#C c #eed3bc",
"#8 c #efd6c0",
"#R c #efd6c1",
"#0 c #efd7c1",
"#H c #efd8c2",
"#B c #efd8c3",
"#q c #f0d8c3",
".D c #f0eeec",
"#Z c #f1dac7",
"#7 c #f1dbc7",
"#Q c #f1dbc8",
"#A c #f1dcc9",
"#g c #f2ddcb",
"#6 c #f2dece",
"#P c #f2dfce",
"#Y c #f2e0cf",
"#z c #f3e0d0",
"#p c #f3e1d1",
".8 c #f3e1d2",
"#f c #f4e1d2",
"#5 c #f4e3d4",
"#X c #f4e3d5",
"#G c #f4e4d6",
"#y c #f5e5d7",
"#o c #f5e5d8",
"#e c #f5e6d8",
".Z c #f5e6d9",
"#4 c #f6e8db",
"#O c #f6e8dc",
"#x c #f6e8dd",
"#F c #f6e9dd",
".7 c #f6eadf",
"#n c #f7eade",
"#d c #f7eadf",
".Y c #f7ebe1",
"#N c #f7ece2",
"#m c #f8ede4",
"#w c #f8eee4",
".6 c #f8eee6",
".X c #f9efe7",
".R c #f9f0e8",
"#W c #f9f0e9",
"#M c #f9f0ea",
"#v c #faf2eb",
"#c c #faf2ec",
"#l c #faf3ec",
".5 c #faf3ed",
".W c #faf4ee",
".Q c #fbf3ee",
"#L c #fbf5f0",
"#u c #fbf6f1",
"#k c #fbf6f2",
".4 c #fbf7f3",
"#E c #fcf6f1",
"#b c #fcf7f3",
".P c #fcf8f5",
".J c #fdfaf7",
"#t c #fdfaf8",
"#j c #fdfbf9",
"#a c #fdfbfa",
".3 c #fdfcfa",
".C c #fdfdfd",
".V c #fefcfb",
".O c #fefdfb",
".I c #fefdfc",
"#s c #fefefd",
"## c #fefefe",
".2 c #fffefe",
".r c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQt.#.a.b.c.d.e.f.g.h.i.j.jQtQtQtQtQtQtQt",
"QtQtQt.k.l.l.l.l.l.l.m.n.o.j.p.jQtQtQtQtQtQt",
"QtQtQt.q.l.r.r.r.r.r.r.s.t.u.v.p.jQtQtQtQtQt",
"QtQtQt.w.l.r.r.r.r.r.r.r.s.e.r.v.p.jQtQtQtQt",
"QtQtQt.x.l.r.r.r.r.r.r.r.r.y.z.r.v.p.jQtQtQt",
"QtQtQt.A.l.r.r.r.r.r.r.r.r.#.y.e.u.j.jQtQtQt",
"QtQtQt.B.l.r.r.r.r.r.r.r.r.C.D.E.F.G.jQtQtQt",
"QtQtQt.H.l.r.r.r.r.r.r.r.r.I.J.K.L.M.jQtQtQt",
"QtQtQt.N.l.r.r.r.r.r.r.r.O.P.Q.R.S.T.jQtQtQt",
"QtQtQt.U.l.r.r.r.r.r.r.V.P.W.X.Y.Z.0.jQtQtQt",
"QtQtQt.1.l.r.r.r.r.2.3.4.5.6.7.Z.8.9.jQtQtQt",
"QtQtQt#..l.r.r.r###a#b#c.6#d#e#f#g#h.jQtQtQt",
"QtQtQt#i.l.r.r###j#k#l#m#n#o#p#g#q#r.jQtQtQt",
"QtQtQt#i.l.r.r###j#k#l#m#n#o#p#g#q#r.jQtQtQt",
"QtQtQt.j.l.r#s#t#u#v#w#x#y#z#A#B#C#D.jQtQtQt",
"QtQtQt.j.l.2.J#E#v#m#F#G#z#A#H#C#I#J.jQtQtQt",
"QtQtQt#K.l.J#L#M#N#O#G#P#Q#R#S#T#U#V.jQtQtQt",
"QtQtQt.j.l#L#W#N#O#X#Y#Z#0#1#T#U#2#3.jQtQtQt",
"QtQtQt.j.l.R.Y#4#5#6#7#8#1#9a.a#aaab.jQtQtQt",
"QtQtQt.jacacadaeafagahaiajakalamanao.jQtQtQt",
"QtQtQt.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.jQtQtQt"};

static const char* const image1_data[] = {
"22 22 106 2",
"Qt c None",
".3 c None",
"#e c None",
".5 c None",
".6 c None",
".4 c None",
"#d c None",
"#J c #010308",
"#N c #020207",
".2 c #030810",
".a c #040913",
".M c #040a15",
"#M c #040d17",
".7 c #050405",
".d c #050e1a",
".h c #050f1c",
".n c #05101c",
"#I c #05111e",
"#K c #051320",
"#L c #061221",
"#m c #061625",
"#C c #061727",
"#c c #07182a",
".# c #0c3651",
".X c #0d3d5c",
".I c #0e97bf",
".z c #0ea0c5",
"#H c #0f4364",
"#F c #0f5f84",
".H c #0f9ec2",
".W c #105375",
".V c #105c7f",
"#G c #106187",
".c c #106589",
".U c #107093",
".Q c #107195",
".L c #107ea3",
".0 c #1096bd",
".m c #10a2c7",
"#B c #116182",
"#v c #11658c",
"#j c #118eb0",
"#q c #1191b2",
"#t c #1191b3",
".T c #1192b2",
"## c #1197b9",
"#b c #13678e",
"#l c #136890",
"#z c #1397b8",
".S c #14b5d3",
"#A c #15bdd6",
".K c #15c1da",
".s c #15c2dc",
".g c #17a4c2",
".G c #17a9c8",
".J c #17abd0",
".y c #19b3ce",
".B c #1ca2c3",
".u c #1cb2cd",
"#u c #20c2d5",
".l c #21ccdc",
"#n c #234760",
"#E c #25678a",
".R c #25aecc",
".1 c #26c3d5",
".N c #294b6a",
"#D c #2c5371",
".P c #2d6284",
"#. c #32afcf",
".Z c #34b2cd",
"#f c #35566e",
".t c #3cd7e1",
".Y c #3f9dc0",
"#y c #40a2c3",
"#k c #43d5de",
"#a c #46d6df",
".O c #486789",
".A c #48dfe9",
".F c #59c3da",
"#x c #64b6d1",
".C c #6f9ab8",
".x c #71d1e0",
".b c #7495b3",
".r c #79cfe2",
"#s c #7bc5de",
".i c #7c9ab5",
".v c #809fbb",
".o c #819eba",
"#i c #81c9db",
".e c #83a7c2",
".9 c #96d8e9",
".8 c #98cfe1",
"#p c #99d3e4",
"#r c #a8e1ef",
".E c #a9cdde",
".k c #bcdeeb",
"#h c #c4eaf3",
"#o c #cbedf4",
"#w c #ccebf5",
".q c #dcedf3",
".f c #ddeff8",
".D c #dfeff8",
".w c #e1f0f4",
"#g c #e4f4f9",
".j c #fdfafd",
".p c #fdfcfd",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQt.#.aQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQt.#.b.c.dQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQt.#.e.f.g.c.hQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQt.#.i.j.k.l.m.c.nQtQtQtQtQtQtQt",
"QtQtQtQtQtQt.#.o.p.q.r.s.t.u.c.hQtQtQtQtQtQt",
"QtQtQtQtQt.#.v.p.w.x.y.z.s.A.B.c.hQtQtQtQtQt",
"QtQtQtQt.#.C.D.E.F.G.H.I.J.K.t.L.c.MQtQtQtQt",
"QtQtQt.#.N.O.P.Q.R.H.I.I.S.T.U.V.W.X.aQtQtQt",
"QtQt.#.X.X.X.X.X.Y.Z.H.0.1.T.X.X.X.X.X.2QtQt",
"QtQt.3.4.4.5.6.7.8.9#.###a#b#c#d.5.5#e.3QtQt",
"QtQtQtQtQtQtQt#f#g#h#i#j#k#l#mQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQt#n.j#o#p#q#a#l#mQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQt.#.j#r#s#t#u#v#mQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQt.##w#x#y#z#A#B#CQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQt.##D#E#F#G#G#H#IQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQt#J.d#K#L#K#K#M#NQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image2_data[] = {
"22 22 125 2",
"Qt c None",
".j c #000000",
"#s c #020202",
"#c c #060606",
".i c #080808",
"#. c #0c0c0c",
".h c #101010",
".3 c #131313",
".u c #141414",
".g c #181818",
".U c #191919",
".N c #1f1f1f",
".f c #212121",
".H c #262626",
".e c #292929",
".B c #2c2c2c",
".d c #313131",
".A c #333333",
".x c #393939",
".c c #3a3a3a",
".y c #3e3e3e",
".w c #3f3f3f",
".b c #424242",
".q c #464646",
".a c #4a4a4a",
".k c #4c4c4c",
".# c #535353",
".1 c #820202",
".G c #857f7a",
".p c #989898",
".M c #a09b97",
".o c #b4b4b4",
".F c #b8b1a9",
".T c #bbb2ab",
".0 c #c6b8ac",
".n c #c6c6c6",
"#6 c #c7a081",
"#T c #c8a487",
"#5 c #c8a488",
"#H c #c9a88d",
"#4 c #c9a88e",
".v c #c9c9c9",
"#x c #cbac93",
"#3 c #cbad94",
"#r c #ccb099",
"#2 c #cdb09a",
"#o c #ceb49f",
"#1 c #ceb5a0",
"#F c #ceb69d",
"#g c #cfb8a5",
"#0 c #cfb8a6",
".E c #cfcbc4",
"#b c #d0bcab",
".L c #d0c8c1",
"#Z c #d1bdac",
".9 c #d2c0b1",
"#Y c #d2c0b2",
"#X c #d4c4b8",
"#v c #d6c0af",
"#W c #d6c8be",
".m c #d6d6d6",
"#V c #d7ccc4",
"#U c #d8d0ca",
"#A c #d9cbc0",
".7 c #d9cec7",
".l c #dedede",
".z c #e0e0e0",
".t c #e1e1e1",
".K c #e4e0db",
"#S c #e7c2a2",
"#R c #e8c5a6",
"#G c #e9c5a6",
"#Q c #eac9ac",
"#w c #eac9ad",
".S c #eadfd5",
"#P c #eccdb3",
"#q c #ecceb5",
".s c #ececec",
"#O c #eed2ba",
"#n c #eed3bc",
"#N c #efd6c0",
"#E c #efd7c1",
"#m c #efd8c3",
"#f c #f0d8c3",
".D c #f0eeec",
"#D c #f1dac7",
"#M c #f1dbc7",
"#l c #f1dcc9",
"#a c #f2ddcb",
"#L c #f2dece",
"#u c #f2dfce",
"#C c #f2e0cf",
"#e c #f3e1d1",
".8 c #f3e1d2",
"## c #f4e1d2",
"#K c #f4e3d4",
"#B c #f4e3d5",
"#t c #f4e4d6",
"#i c #f5e5d8",
".Z c #f5e6d9",
"#J c #f6e8db",
"#I c #f7ebe1",
".R c #f9f0e8",
".Y c #faaea3",
".4 c #fad2ce",
".X c #faf4ee",
".Q c #fbf3ee",
"#y c #fbf5f0",
".6 c #fbf7f3",
".P c #fcf8f5",
".J c #fdfaf7",
"#k c #fdfaf8",
"#h c #fdfbf9",
".5 c #fdfcfa",
".C c #fdfdfd",
".2 c #fe0202",
"#z c #fe7e7a",
".V c #febebe",
".W c #fefcfb",
".O c #fefdfb",
".I c #fefdfc",
"#j c #fefefd",
"#d c #fefefe",
"#p c #fffefe",
".r c #ffffff",
"QtQtQt.#.a.b.c.d.e.f.g.h.i.j.jQtQtQtQtQtQtQt",
"QtQtQt.k.l.l.l.l.l.l.m.n.o.j.p.jQtQtQtQtQtQt",
"QtQtQt.q.l.r.r.r.r.r.r.s.t.u.v.p.jQtQtQtQtQt",
"QtQtQt.w.l.r.r.r.r.r.r.r.s.e.r.v.p.jQtQtQtQt",
"QtQtQt.x.l.r.r.r.r.r.r.r.r.y.z.r.v.p.jQtQtQt",
"QtQtQt.A.l.r.r.r.r.r.r.r.r.#.y.e.u.j.jQtQtQt",
"QtQtQt.B.l.r.r.r.r.r.r.r.r.C.D.E.F.G.jQtQtQt",
"QtQtQt.H.l.r.r.r.r.r.r.r.r.I.J.K.L.M.jQtQtQt",
"QtQtQt.N.l.r.r.r.r.r.r.r.O.P.Q.R.S.T.jQtQtQt",
"QtQtQt.U.l.r.V.r.r.r.r.W.P.X.Y.V.Z.0.jQtQtQt",
"QtQtQt.U.l.r.1.2.r.r.r.W.P.Y.2.1.Z.0.jQtQtQt",
"QtQtQt.3.l.r.z.1.2.4.5.6.Y.2.1.7.8.9.jQtQtQt",
"QtQtQt#..l.r.r.z.1.2.4.4.2.1.7###a#b.jQtQtQt",
"QtQtQt#c.l.r.r#d.z.1.2.2.1.7#e#a#f#g.jQtQtQt",
"QtQtQt#c.l.r.r#d#h.4.2.2.Y#i#e#a#f#g.jQtQtQt",
"QtQtQt.j.l.r#j#k.4.2.1.1.2.Y#l#m#n#o.jQtQtQt",
"QtQtQt.j.l#p.J.4.2.1.7.7.1.2.Y#n#q#r.jQtQtQt",
"QtQtQt#s.l.J.4.2.1.7#t#u#v.1.2.Y#w#x.jQtQtQt",
"QtQtQt.j.l#y#z.1#A#B#C#D#E#F.1#z#G#H.jQtQtQt",
"QtQtQt.j.l.R#I#J#K#L#M#N#O#P#Q#R#S#T.jQtQtQt",
"QtQtQt.j#U#U#V#W#X#Y#Z#0#1#2#3#4#5#6.jQtQtQt",
"QtQtQt.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.jQtQtQt"};

static const char* const image3_data[] = {
"22 22 73 2",
"Qt c None",
".F c None",
".G c None",
".H c None",
".k c #010001",
"#e c #010101",
".# c #0d3652",
".O c #0d3d5c",
".a c #0e3753",
".y c #0e87a9",
".C c #0e8bae",
".1 c #0e8fb6",
"#. c #0e91b7",
".0 c #0e91b8",
".L c #0e94b9",
".u c #0e95b7",
".2 c #0e97bf",
".S c #0e9dc2",
"#d c #0e9ec3",
".9 c #0e9fc4",
".K c #0eadcb",
".3 c #0eb0cd",
".U c #0f90b5",
".5 c #106589",
".E c #116c92",
".N c #137194",
".q c #14678d",
".T c #15c1da",
"## c #17abd0",
".I c #1a415b",
".d c #1b415c",
".4 c #1ca2c3",
".j c #1f779c",
".v c #20c2d5",
".R c #24a9cb",
".b c #254a63",
".M c #26c3d5",
".c c #30536b",
".V c #337f9e",
".t c #3db9d3",
".z c #40d1db",
".B c #44c0d7",
".D c #46dbe6",
"#a c #48dfe9",
".8 c #59c3da",
".x c #5fc0d6",
".Q c #6bbed8",
".J c #7bc6de",
".o c #7cc9de",
".n c #7fbdd5",
".W c #80b6d0",
".m c #8fcada",
".p c #8fcce2",
".e c #94c1d5",
".Y c #96c3d7",
".X c #98c7d9",
".Z c #a7d7e7",
".7 c #a9cdde",
".A c #b5deec",
"#f c #bcdeeb",
".s c #bce2ec",
".P c #c0dfee",
".f c #cde1ec",
".w c #cee9f2",
".i c #d3e5f0",
".l c #daedf7",
"#c c #dcedf3",
"#g c #ddeff8",
".h c #dfebf5",
".6 c #dfeff8",
".g c #e1ebf2",
"#b c #fdfcfd",
".r c #fefbfe",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQt.#.a.b.c.d.#.#.#QtQtQtQtQtQtQt",
"QtQtQtQtQtQtQt.#.e.f.g.h.i.j.kQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQt.#.l.m.n.o.p.q.kQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQt.#.r.s.t.u.v.q.kQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQt.#.r.w.x.y.z.q.kQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQt.#.r.A.B.C.D.E.kQtQtQtQtQtQtQt",
"QtQt.F.F.F.G.H.I.r.J.K.L.M.N.kQtQtQtQtQtQtQt",
"QtQt.#.O.O.O.O.O.P.Q.R.S.T.U.O.O.O.O.O.OQtQt",
"QtQtQt.k.V.W.X.Y.Z.K.0.1.T.2.3.4.V.5.kQtQtQt",
"QtQtQtQt.k.V.6.7.8.9#..2##.T#a.4.5.kQtQtQtQt",
"QtQtQtQtQt.k.V#b#c.8#d.2.T#a.4.5.kQtQtQtQtQt",
"QtQtQtQtQtQt#e.V#b#c.8.8#a.4.5.kQtQtQtQtQtQt",
"QtQtQtQtQtQtQt.k.V#b#f#a.4.5.kQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQt.k.V#g.4.5.kQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQt.k.V.5.kQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQt.k.kQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};


extern const char* mailFilterLogicNames[];
extern const char* mailFilterFunctionNames[];
extern const char* mailFilterActionNames[];
extern const char* mailFilterFieldNames[];

/*
static const char* mailFilterLogicNames[] =
{ "ignore", "and", "unless", "or", NULL };
static const char* mailFilterFunctionNames[] =
{ "equals", "not-equal", "contains", "contains-not", "regexp",
"not-regexp", NULL };
static const char* mailFilterActionNames[] =
{ "<nothing>", "transfer", "copy", NULL };
static const char* mailFilterFieldNames[] =
{ "", "Subject", "To", "CC", "From", "Body", NULL };
*/

/*
 *  Constructs a MailFilterDialog which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
MailFilterDialog::MailFilterDialog( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    QPixmap image0( ( const char** ) image0_data );
    QPixmap image1( ( const char** ) image1_data );
    QPixmap image2( ( const char** ) image2_data );
    QPixmap image3( ( const char** ) image3_data );
    if ( !name )
	setName( "MailFilterDialog" );
    resize( 594, 314 );
    setCaption( i18n( "Filter Rules" ) );
    MailFilterDialogLayout = new QGridLayout( this );
    MailFilterDialogLayout->setSpacing( 6 );
    MailFilterDialogLayout->setMargin( 11 );

    leftLayout = new QGridLayout;
    leftLayout->setSpacing( 6 );
    leftLayout->setMargin( 0 );

    buttonNew = new QToolButton( this, "buttonNew" );
    buttonNew->setMaximumSize( QSize( 32, 32 ) );
    buttonNew->setAutoRaise(true);
    buttonNew->setText( i18n( "" ) );
    buttonNew->setPixmap( image0 );

    leftLayout->addWidget( buttonNew, 1, 3 );

    list = new QListBox( this, "list" );
    list->setMinimumSize( QSize( 200, 0 ) );

    leftLayout->addMultiCellWidget( list, 0, 0, 0, 5 );

    buttonUp = new QToolButton( this, "buttonUp" );
    buttonUp->setMaximumSize( QSize( 32, 32767 ) );
    buttonUp->setAutoRaise(true);
    buttonUp->setText( i18n( "" ) );
    buttonUp->setPixmap( image1 );

    leftLayout->addWidget( buttonUp, 1, 1 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    leftLayout->addItem( spacer, 1, 0 );

    buttonDelete = new QToolButton( this, "buttonDelete" );
    buttonDelete->setMaximumSize( QSize( 32, 32 ) );
    buttonDelete->setAutoRaise(true);
    buttonDelete->setText( i18n( "" ) );
    buttonDelete->setPixmap( image2 );

    leftLayout->addWidget( buttonDelete, 1, 4 );
    QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    leftLayout->addItem( spacer_2, 1, 5 );

    buttonDown = new QToolButton( this, "buttonDown" );
    buttonDown->setMaximumSize( QSize( 32, 32 ) );
    buttonDown->setAutoRaise(true);
    buttonDown->setText( i18n( "" ) );
    buttonDown->setPixmap( image3 );

    leftLayout->addWidget( buttonDown, 1, 2 );

    MailFilterDialogLayout->addMultiCellLayout( leftLayout, 0, 1, 0, 0 );

    bottomLayout = new QHBoxLayout;
    bottomLayout->setSpacing( 6 );
    bottomLayout->setMargin( 0 );
    QSpacerItem* spacer_3 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    bottomLayout->addItem( spacer_3 );

    buttonOk = new QPushButton( this, "buttonOk" );
    buttonOk->setText( i18n( "Ok" ) );
    bottomLayout->addWidget( buttonOk );

    buttonCancel = new QPushButton( this, "buttonCancel" );
    buttonCancel->setText( i18n( "Cancel" ) );
    bottomLayout->addWidget( buttonCancel );

    MailFilterDialogLayout->addMultiCellLayout( bottomLayout, 2, 2, 0, 1 );

    rightTopLayout = new QGridLayout;
    rightTopLayout->setSpacing( 6 );
    rightTopLayout->setMargin( 0 );

    comboContext1 = new QLineEdit( this, "comboContext1" );
    comboContext1->setMinimumSize( QSize( 150, 0 ) );

    rightTopLayout->addWidget( comboContext1, 0, 2 );

    comboField1 = new QComboBox( FALSE, this, "comboField1" );
    comboField1->setMinimumSize( QSize( 100, 0 ) );
    comboField1->insertStrList(mailFilterFieldNames);

    rightTopLayout->addWidget( comboField1, 0, 0 );

    comboFunction2 = new QComboBox( FALSE, this, "comboFunction2" );
    comboFunction2->setMinimumSize( QSize( 100, 0 ) );
    comboFunction2->insertStrList(mailFilterFunctionNames);

    rightTopLayout->addWidget( comboFunction2, 2, 1 );

    comboLogic = new QComboBox( FALSE, this, "comboLogic" );
    comboLogic->setMinimumSize( QSize( 150, 0 ) );
    comboLogic->insertStrList(mailFilterLogicNames);

    rightTopLayout->addMultiCellWidget( comboLogic, 1, 1, 0, 1 );

    comboContext2 = new QLineEdit( this, "comboContext2" );
    comboContext2->setMinimumSize( QSize( 150, 0 ) );

    rightTopLayout->addWidget( comboContext2, 2, 2 );

    comboField2 = new QComboBox( FALSE, this, "comboField2" );
    comboField2->setMinimumSize( QSize( 100, 0 ) );
    comboField2->insertStrList(mailFilterFieldNames);

    rightTopLayout->addWidget( comboField2, 2, 0 );

    comboFunction1 = new QComboBox( FALSE, this, "comboFunction1" );
    comboFunction1->setMinimumSize( QSize( 100, 0 ) );
    comboFunction1->insertStrList(mailFilterFunctionNames);

    rightTopLayout->addWidget( comboFunction1, 0, 1 );

    MailFilterDialogLayout->addLayout( rightTopLayout, 0, 1 );

    rightBottomLayout = new QGridLayout;
    rightBottomLayout->setSpacing( 6 );
    rightBottomLayout->setMargin( 0 );

    comboAction5 = new QComboBox( FALSE, this, "comboAction5" );
    comboAction5->setMaximumSize( QSize( 150, 32767 ) );
    comboAction5->insertStrList(mailFilterActionNames);

    rightBottomLayout->addWidget( comboAction5, 4, 0 );

    comboAction4 = new QComboBox( FALSE, this, "comboAction4" );
    comboAction4->setMaximumSize( QSize( 150, 32767 ) );
    comboAction4->insertStrList(mailFilterActionNames);

    rightBottomLayout->addWidget( comboAction4, 3, 0 );

    comboAction3 = new QComboBox( FALSE, this, "comboAction3" );
    comboAction3->setMaximumSize( QSize( 150, 32767 ) );
    comboAction3->insertStrList(mailFilterActionNames);

    rightBottomLayout->addWidget( comboAction3, 2, 0 );

    comboAction2 = new QComboBox( FALSE, this, "comboAction2" );
    comboAction2->setMaximumSize( QSize( 150, 32767 ) );
    comboAction2->insertStrList(mailFilterActionNames);

    rightBottomLayout->addWidget( comboAction2, 1, 0 );
    QSpacerItem* spacer_4 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    rightBottomLayout->addItem( spacer_4, 5, 0 );

    comboAction1 = new QComboBox( FALSE, this, "comboAction1" );
    comboAction1->setMaximumSize( QSize( 150, 32767 ) );
    comboAction1->insertStrList(mailFilterActionNames);

    rightBottomLayout->addWidget( comboAction1, 0, 0 );

    MailFilterDialogLayout->addLayout( rightBottomLayout, 1, 1 );

    connect(buttonNew,   SIGNAL(clicked()),SLOT(slotNew()));
    connect(buttonDelete,SIGNAL(clicked()),SLOT(slotDelete()));
    connect(buttonUp,    SIGNAL(clicked()),SLOT(slotUp()));
    connect(buttonDown,  SIGNAL(clicked()),SLOT(slotDown()));

    connect(comboField1,  SIGNAL(activated(int)),  SLOT(slotChanged()));
    connect(comboContext1,SIGNAL(textChanged(const QString &)),SLOT(slotChanged()));

    connect(list,        SIGNAL(selectionChanged()),SLOT(slotUpdate()));

    connect(buttonOk,    SIGNAL(clicked()),SLOT(accept()));
    connect(buttonCancel,SIGNAL(clicked()),SLOT(reject()));

    acel1 = new QComboBox(false,this);
    acel2 = new QComboBox(false,this);
    acel3 = new QComboBox(false,this);
    acel4 = new QComboBox(false,this);
    acel5 = new QComboBox(false,this);

    rightBottomLayout->addWidget( acel1, 0, 1 );
    rightBottomLayout->addWidget( acel2, 1, 1 );
    rightBottomLayout->addWidget( acel3, 2, 1 );
    rightBottomLayout->addWidget( acel4, 3, 1 );
    rightBottomLayout->addWidget( acel5, 4, 1 );

    connect(comboAction1,SIGNAL(activated(int)),SLOT(slotAc1Changed()));
    connect(comboAction2,SIGNAL(activated(int)),SLOT(slotAc2Changed()));
    connect(comboAction3,SIGNAL(activated(int)),SLOT(slotAc3Changed()));
    connect(comboAction4,SIGNAL(activated(int)),SLOT(slotAc4Changed()));
    connect(comboAction5,SIGNAL(activated(int)),SLOT(slotAc5Changed()));

    lastind=0;
}

void MailFilterDialog::slotNew()
{
   disconnect(comboField1,  SIGNAL(activated(int)),this,SLOT(slotChanged()));
   disconnect(comboContext1,SIGNAL(textChanged(const QString &)),this,SLOT(slotChanged()));
   disconnect(list,         SIGNAL(selectionChanged()),this,SLOT(slotUpdate()));

   slotUpdate();

   disconnect(comboField1,  SIGNAL(activated(int)),this,SLOT(slotChanged()));
   disconnect(comboContext1,SIGNAL(textChanged(const QString &)),this,SLOT(slotChanged()));

   list->insertItem("New",0);
   list->setSelected(0,true);

   comboField1   ->setCurrentItem(0);
   comboFunction1->setCurrentItem(0);
   comboContext1 ->setText("");
   comboLogic    ->setCurrentItem(0);
   comboField2   ->setCurrentItem(0);
   comboFunction2->setCurrentItem(0);
   comboContext2 ->setText("");
   comboAction1  ->setCurrentItem(0);
   comboAction2  ->setCurrentItem(0);
   comboAction3  ->setCurrentItem(0);
   comboAction4  ->setCurrentItem(0);
   comboAction5  ->setCurrentItem(0);

   qDebug("ind %i",list->currentItem());

   filterList.prepend(new FilterEl(
                      comboField1->currentText(),
                      comboFunction1->currentText(),
                      comboContext1->text(),
                      comboLogic->currentText(),
                      comboField2->currentText(),
                      comboFunction2->currentText(),
                      comboContext2->text(),
                      comboAction1->currentText(),
                      comboAction2->currentText(),
                      comboAction3->currentText(),
                      comboAction4->currentText(),
                      comboAction5->currentText(),
                      "","","","",""
                      ));

  lastind=-1;
  slotUpdate();

  connect(list,         SIGNAL(selectionChanged()),SLOT(slotUpdate()));
  connect(comboField1,  SIGNAL(activated(int)),  SLOT(slotChanged()));
  connect(comboContext1,SIGNAL(textChanged(const QString &)),SLOT(slotChanged()));
}

void MailFilterDialog::slotDelete()
{
  disconnect(comboField1,  SIGNAL(activated(int)),this,SLOT(slotChanged()));
  disconnect(comboContext1,SIGNAL(textChanged(const QString &)),this,SLOT(slotChanged()));
  disconnect(list,         SIGNAL(selectionChanged()),this,SLOT(slotUpdate()));

  slotUpdate();

  int ind = list->currentItem();
  if ( ind == -1 ) return;
  FilterEl *el;

  int i=0;
  for ( el=filterList.first(); el != 0; el=filterList.next() )
  {
    if (i==ind)
    {
      list->removeItem(ind);
      filterList.setAutoDelete(true);
      filterList.removeRef(el);
      if (ind==int(list->count())) list->setSelected(list->count()-1,true);
      else list->setSelected(ind,true);
      break;
    }
    i++;
  }

  lastind=-1;
  slotUpdate();

  connect(list,         SIGNAL(selectionChanged()),SLOT(slotUpdate()));
  connect(comboField1,  SIGNAL(activated(int)),  SLOT(slotChanged()));
  connect(comboContext1,SIGNAL(textChanged(const QString &)),SLOT(slotChanged()));

  if ( filterList.count() < 1 ) slotNew();
}

void MailFilterDialog::slotUp()
{
  disconnect(comboField1,  SIGNAL(activated(int)),this,SLOT(slotChanged()));
  disconnect(comboContext1,SIGNAL(textChanged(const QString &)),this,SLOT(slotChanged()));
  disconnect(list,         SIGNAL(selectionChanged()),this,SLOT(slotUpdate()));

  slotUpdate();

  int ind = list->currentItem();
  if ( ind == -1 ) return;
  FilterEl *el;

  int i=0;
  for ( el=filterList.first(); el != 0; el=filterList.next() )
  {
    if (i==ind && ind>0)
    {
      filterList.setAutoDelete(false);
      filterList.remove();
      filterList.insert(ind-1,el);

      break;
    }
    i++;
  }

  lastind=-1;
  slotUpdate();

  list->setSelected(ind,true);
  slotChanged();
  list->setSelected(ind-1,true);
  slotChanged();

  connect(list,         SIGNAL(selectionChanged()),SLOT(slotUpdate()));
  connect(comboField1,  SIGNAL(activated(int)),  SLOT(slotChanged()));
  connect(comboContext1,SIGNAL(textChanged(const QString &)),SLOT(slotChanged()));
}

void MailFilterDialog::slotDown()
{
  disconnect(comboField1,  SIGNAL(activated(int)),this,SLOT(slotChanged()));
  disconnect(comboContext1,SIGNAL(textChanged(const QString &)),this,SLOT(slotChanged()));
  disconnect(list,         SIGNAL(selectionChanged()),this,SLOT(slotUpdate()));

  slotUpdate();

  int ind = list->currentItem();
  if ( ind == -1 ) return;
  FilterEl *el;

  int i=0;
  for ( el=filterList.first(); el != 0; el=filterList.next() )
  {
    if (i==ind && ind<int(filterList.count()-1))
    {
      filterList.setAutoDelete(false);
      filterList.remove();
      filterList.insert(ind+1,el);

      break;
    }
    i++;
  }

  lastind=-1;
  slotUpdate();

  list->setSelected(ind,true);
  slotChanged();
  list->setSelected(ind+1,true);
  slotChanged();

  connect(list,         SIGNAL(selectionChanged()),SLOT(slotUpdate()));
  connect(comboField1,  SIGNAL(activated(int)),  SLOT(slotChanged()));
  connect(comboContext1,SIGNAL(textChanged(const QString &)),SLOT(slotChanged()));
}

void MailFilterDialog::slotUpdate()
{
  int ind = list->currentItem();
  FilterEl *el;

  disconnect(comboField1,  SIGNAL(activated(int)),this,SLOT(slotChanged()));
  disconnect(comboContext1,SIGNAL(textChanged(const QString &)),this,SLOT(slotChanged()));

  int i=0;
  for ( el=filterList.first(); el != 0; el=filterList.next() )
  {
    if (i==lastind)
    {
      el->rule1field   = comboField1   ->currentText();
      el->rule1function= comboFunction1->currentText();
      el->rule1context = comboContext1 ->text();
      el->rulelogic    = comboLogic    ->currentText();
      el->rule2field   = comboField2   ->currentText();
      el->rule2function= comboFunction2->currentText();
      el->rule2context = comboContext2 ->text();

      el->action1= comboAction1->currentText();
      el->action2= comboAction2->currentText();
      el->action3= comboAction3->currentText();
      el->action4= comboAction4->currentText();
      el->action5= comboAction5->currentText();

      el->actionparam1= acel1->currentText();
      el->actionparam2= acel2->currentText();
      el->actionparam3= acel3->currentText();
      el->actionparam4= acel4->currentText();
      el->actionparam5= acel5->currentText();
    }
    i++;
  }

  comboField1   ->setCurrentItem(0);
  comboFunction1->setCurrentItem(0);
  comboContext1 ->setText("");
  comboLogic    ->setCurrentItem(0);
  comboField2   ->setCurrentItem(0);
  comboFunction2->setCurrentItem(0);
  comboContext2 ->setText("");
  comboAction1  ->setCurrentItem(0);
  comboAction2  ->setCurrentItem(0);
  comboAction3  ->setCurrentItem(0);
  comboAction4  ->setCurrentItem(0);
  comboAction5  ->setCurrentItem(0);

  i=0;
  for ( el=filterList.first(); el != 0; el=filterList.next() )
  {
    if (i==ind)
    {
      setCombo(comboField1,   el->rule1field   );
      setCombo(comboFunction1,el->rule1function);
      comboContext1->setText(el->rule1context  );
      setCombo(comboLogic,    el->rulelogic    );
      setCombo(comboField2,   el->rule2field   );
      setCombo(comboFunction2,el->rule2function);
      comboContext2->setText(el->rule2context  );
      setCombo(comboAction1, el->action1);
      setCombo(comboAction2, el->action2);
      setCombo(comboAction3, el->action3);
      setCombo(comboAction4, el->action4);
      setCombo(comboAction5, el->action5);

      slotAc1Changed();
      slotAc2Changed();
      slotAc3Changed();
      slotAc4Changed();
      slotAc5Changed();

      setCombo(acel1, el->actionparam1);
      setCombo(acel2, el->actionparam2);
      setCombo(acel3, el->actionparam3);
      setCombo(acel4, el->actionparam4);
      setCombo(acel5, el->actionparam5);
    }
    i++;
  }
  lastind=ind;

  connect(comboField1,  SIGNAL(activated(int)),  SLOT(slotChanged()));
  connect(comboContext1,SIGNAL(textChanged(const QString &)),SLOT(slotChanged()));
}

void MailFilterDialog::slotChanged()
{
  int ind = list->currentItem();
  FilterEl *el;

  int i=0;
  for ( el=filterList.first(); el != 0; el=filterList.next() )
  {
    if (i==ind)
    {
      disconnect(list,SIGNAL(selectionChanged()),this,SLOT(slotUpdate()));
      if ( (comboField1->currentText()+comboContext1->text()).isEmpty() )
        list->changeItem("New",ind);
      else
        list->changeItem(comboField1->currentText()+":"+comboContext1->text(),ind);
      connect(list,   SIGNAL(selectionChanged()),SLOT(slotUpdate()));
    }
    i++;
  }
}

void MailFilterDialog::setCombo(QComboBox *box,QString text)
{
  if (!box->editable())
  {
    box->setCurrentItem(0);
    for (int i=0;i<box->count();i++)
    {
      if ( box->text(i) == text ) box->setCurrentItem(i);
    }
  }
  else {
    box->setEditText(text);
  }
}

void MailFilterDialog::slotAc1Changed(){setAcCombo(comboAction1,acel1);}
void MailFilterDialog::slotAc2Changed(){setAcCombo(comboAction2,acel2);}
void MailFilterDialog::slotAc3Changed(){setAcCombo(comboAction3,acel3);}
void MailFilterDialog::slotAc4Changed(){setAcCombo(comboAction4,acel4);}
void MailFilterDialog::slotAc5Changed(){setAcCombo(comboAction5,acel5);}

void MailFilterDialog::setAcCombo(QComboBox *box,QComboBox *acel)
{
  if ( box->currentText() == "<nothing>" ) {
    acel->clear();
    acel->setEnabled(false);
  } else if ( box->currentText() == "transfer" ) {
    acel->setEnabled(true);
    acel->setEditable(false);
    acel->clear();
    acel->insertStringList(getFolderList());
  } else {
    acel->setEnabled(true);
    acel->setEditable(true);
    acel->clear();
  }
}

// internal funct, ret recursively folders list
QStringList MailFilterDialog::longFoldersList( QString folder ) {

    QStringList folders = ClientVFS::thisInstance()->folderList( folder);
    QStringList newFolders;

    for ( QStringList::Iterator it = folders.begin(); it != folders.end(); ++it ) {
      newFolders.append( *it );
      newFolders += longFoldersList( *it );
    }

    return newFolders;
}

QStringList MailFilterDialog::getFolderList()
{

  //QStringList folders = ClientVFS::thisInstance()->folderList("/Magellan/Mail");

  QStringList folders = longFoldersList("/Magellan/Mail");

  for ( QStringList::Iterator it = folders.begin(); it != folders.end(); ++it ) {
     (*it).remove(0, QString("/Magellan/Mail/").length() );
  }

  return folders;
}

/*
 *  Destroys the object and frees any allocated resources
 */
MailFilterDialog::~MailFilterDialog()
{
   // no need to delete child widgets, Qt does it all for us
}

extern KConfig *GlobalConfig;

void MailFilterDialog::load()
{
  // remove old conf
  filterList.clear();

  KConfig *config = GlobalConfig;

  config->setGroup("MailFilters");
  int count = config->readNumEntry("filters_count",0);
  for (int i=0;i<count;i++)
  {
    if ( !(config->readEntry("filter_"+QString::number(i)+"_rule1_field")).isEmpty() )
    {
      filterList.append(new FilterEl(
        config->readEntry("filter_"+QString::number(i)+"_rule1_field"),
        config->readEntry("filter_"+QString::number(i)+"_rule1_function"),
        config->readEntry("filter_"+QString::number(i)+"_rule1_context"),
        config->readEntry("filter_"+QString::number(i)+"_rule_logic"),
        config->readEntry("filter_"+QString::number(i)+"_rule2_field"),
        config->readEntry("filter_"+QString::number(i)+"_rule2_function"),
        config->readEntry("filter_"+QString::number(i)+"_rule2_context"),
        config->readEntry("filter_"+QString::number(i)+"_action0"),
        config->readEntry("filter_"+QString::number(i)+"_action1"),
        config->readEntry("filter_"+QString::number(i)+"_action2"),
        config->readEntry("filter_"+QString::number(i)+"_action3"),
        config->readEntry("filter_"+QString::number(i)+"_action4"),
        config->readEntry("filter_"+QString::number(i)+"_action0_param"),
        config->readEntry("filter_"+QString::number(i)+"_action1_param"),
        config->readEntry("filter_"+QString::number(i)+"_action2_param"),
        config->readEntry("filter_"+QString::number(i)+"_action3_param"),
        config->readEntry("filter_"+QString::number(i)+"_action4_param")
        ));
      list->insertItem(config->readEntry("filter_"+QString::number(i)+"_rule1_field")+":"+
                       config->readEntry("filter_"+QString::number(i)+"_rule1_context"));

      FilterEl *el = filterList.last();
      qDebug("Read filter %s:%s",(el->rule1field).data(),(el->rule1context).data());
    }
  }
  lastind=-1;
  list->setSelected(0,true);

  if (filterList.count()<1) slotNew();
}

void MailFilterDialog::sync()
{
  KConfig *config = GlobalConfig;

  int count = filterList.count();
  config->setGroup("MailFilters");
  config->writeEntry("filters_count",count);

  slotUpdate();

  FilterEl *el;
  int i=0;
  for ( el=filterList.first(); el != 0; el=filterList.next() )
  {
    qDebug("Write filter %s:%s",(el->rule1field).data(),(el->rule1context).data());
    config->writeEntry("filter_"+QString::number(i)+"_rule1_field",   el->rule1field   );
    config->writeEntry("filter_"+QString::number(i)+"_rule1_function",el->rule1function);
    config->writeEntry("filter_"+QString::number(i)+"_rule1_context", el->rule1context );
    config->writeEntry("filter_"+QString::number(i)+"_rule_logic",    el->rulelogic    );
    config->writeEntry("filter_"+QString::number(i)+"_rule2_field",   el->rule2field   );
    config->writeEntry("filter_"+QString::number(i)+"_rule2_function",el->rule2function);
    config->writeEntry("filter_"+QString::number(i)+"_rule2_context", el->rule2context );
    config->writeEntry("filter_"+QString::number(i)+"_action0",       el->action1);
    config->writeEntry("filter_"+QString::number(i)+"_action1",       el->action2);
    config->writeEntry("filter_"+QString::number(i)+"_action2",       el->action3);
    config->writeEntry("filter_"+QString::number(i)+"_action3",       el->action4);
    config->writeEntry("filter_"+QString::number(i)+"_action4",       el->action5);
    config->writeEntry("filter_"+QString::number(i)+"_action0_param", el->actionparam1);
    config->writeEntry("filter_"+QString::number(i)+"_action1_param", el->actionparam2);
    config->writeEntry("filter_"+QString::number(i)+"_action2_param", el->actionparam3);
    config->writeEntry("filter_"+QString::number(i)+"_action3_param", el->actionparam4);
    config->writeEntry("filter_"+QString::number(i)+"_action4_param", el->actionparam5);
    i++;
  }
  config->sync();
}

