/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef HAS_VTIMEZONE_H
	#define HAS_VTIMEZONE_H

#include <vtimezonecomponent.h>
#include <vidlist.h>
#include <qdict.h>

#define VTZ_OK													0
#define VTZ_ERROR_TZID									1
#define VTZ_ERROR_LAST_MODIFIED					2
#define VTZ_ERROR_VTC_ERROR							3
#define VTZ_EXPIRED_COMPONENT						4
#define VTZ_ERROR_INVALID					8

#define VTZ_WARNING_NO_LAST_MODIFIED		1


class VTimeZone
{
	int queryYear;
	int errorCode;
	int warningCode;
	/**
	 *	This will contain all the STANDARD/DAYLIGHT components of the TIMEZONE
	 */
	VIdList list; 					// VTC_UID -> tzData
	QDict<QString> namesList; // name -> VTC_UID
	/**
	 *	The timezone name.
	 */
	QString tzId;
	QDateTime lastModified;
	
	void setupTZID(MetaObject *object);
	void setupLastModified(MetaObject *object);
	void parse(MetaObject *object);
public:
	VTimeZone(MetaObject *object=NULL, int year=-1);
	~VTimeZone();
	QString getTZID() 					{ return tzId; };
	QDateTime getLastModified() { return lastModified; }
	int getError()							{ return errorCode; }
	int getWarning() 						{ return warningCode; }
	QString getErrorText();
	QString getWarningText();
	/**
	 *	When you have a reference returns the offset. The adequate situation is:
	 *	- you know the timezone has the name TZID
	 *	- you want to find the offset to GMT for the specific date/time
	 */
	long operator[](QDateTime reference);
	/**
	 *	When you have the zone name, returns the offset. Situation:
	 *		- you have the short name (EDT/GMT/Whatever)
	 *		- you want to know the offset for that period of time.
	 */
	long operator[](QString name);
	/**
	 * returns true if it contains the short name (like 'EDT'). If extended
	 * parameter is set to true, then it checks against the TZID too.
	 */
	bool containsName(QString name, bool extended=false);
	/**
	 *	Debug function really
	 */
	 void show(void);
	/**
	 *		Returns a QStringList with all the tznames!
	 */
	QStringList getTzNames();
};


#endif








