/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef __ContentsWidget__
#define __ContentsWidget__

#include <qwidget.h>
#include <qwidgetstack.h>
#include <qlayout.h>
#include <maillistview.h>
#include <qsplitter.h>
#include <mailview.h>
#include <khtml_part.h>

class VFolder;

class FolderStatus
{
  public:
    enum  FOLDER_STATE { NO_STATE=0, MOUNT, UMOUNT};

    FolderStatus(const QString &name, const QString &type, const QString &viewType, const unsigned state);
    /** Change the current folder status.*/
    void changeStatus(const QString &name, const QString &type, const QString &viewType, const unsigned state);
    /** Reset the current folder status.*/
    void reset();

    /** The current folder name.*/
    QString _name;
    /** The current folder name.*/
    QString _type;
    /** The current folder name.*/
    QString _viewType;
    /** The current folder name.*/
    unsigned  _state;
};


class ContentsWidget : public QWidget
{
	Q_OBJECT
	public:
		ContentsWidget(QWidget *parent);
		~ContentsWidget();
		static ContentsWidget *ref();
		
		void initViews();
		void createFolderView(VFolder *);
		
		// message navigation; "mode" can be: "last", "top", "bottom", "priority", "unread", "next", "flag"
		// "direction" makes sense only for "priority", "next", "flag" or "unread" modes; "true" is down
		void showNext(const QString &mode, bool direction);
		
		/** current folder.*/
		QString getCurrentFolder();
		/** delete the current folder. */
	  void deleteCurrentFolder();
		
		/** current view.*/
		QWidget *getCurrentView();
		
		/** update current view.*/
		void updateCurrentView();
		
	public slots:
		void showFolder(QString);
		void createVInstanceView(QString);
		void createVInstanceView(QStringList&);
		void showMessage(QListViewItem *);
		void showMessage(IndexMailItem *);
		void showMessage(QString);
		
		void markAsRead();
		void markAsRead(const QString &);
		void markAsRead(const QStringList &);
		void markAsUnread(const QString &);
		void markAsUnread(const QStringList &);
	signals:
		void viewChanged(QWidget *);
	private:
		// instance pointer
		static ContentsWidget *inst;
		
	  int lastID, lastMailID;
		
		// current view
		QWidget *currentView;
	
		// stack of folder views
		QWidgetStack *viewStack;
		
		// stack of mail folder views
		QWidgetStack *mailviewStack;
		
		// "Welcome to Magellan" view
		KHTMLPart *welcomeView;
		
		// the main layout
		QVBoxLayout *mainLayout;
		
		// the mail view splitter
		QSplitter *mailSplitter;
		
		// the mail view
		MailView *mailView;
		
		/** The KOrganizer plug in view.*/
		QWidget *korganizerView;
		
		// current folder
		FolderStatus *currentFolder;
		
		// current message displayed in the mail view; QString::null means "Nothing to display"
		QString currentMessage;
		QString lastReadMessage;
		
		void updateMailListView(MailListView *);
		int enumType(QString);
		QString strType(int);
		void updateWelcomeView();
		QString buildUnreadMessagesTable(QString, QString);
		QString getDate();
};

#endif



