/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <clipboard.h>
#include <qapplication.h>
#include <qclipboard.h>
#include <qmime.h>

ClipboardWrapper *ClipboardWrapper::inst;

ClipboardWrapper::ClipboardWrapper():QObject()
{
  lastID=0;
  hList.setAutoDelete(false);
	cutOperation=false;
  connect(QApplication::clipboard(), SIGNAL(dataChanged()), this, SLOT(dataChanged()));
}

ClipboardWrapper::~ClipboardWrapper()
{
  // nothing here yet
}

void ClipboardWrapper::registerDataHandler(DataHandler *h)
{
  hList.append(h);
}

void ClipboardWrapper::unregisterDataHandler(DataHandler *d)
{
	while(hList.removeRef(d));
}

QMimeSource *ClipboardWrapper::data()
{
	return QApplication::clipboard()->data();
}

QMimeSource *ClipboardWrapper::pasteData()
{
  DataHandler *t=hList.first();
  while(t)
  {
    t->clipboardOperationCompleted(lastID);
    t=hList.next();
  }
  lastID=-1;
  return QApplication::clipboard()->data();
}

void ClipboardWrapper::cancelClipboardOperation(int id)
{
  if(id!=lastID) return;
  lastID=-1;
  QApplication::clipboard()->clear();
}

void ClipboardWrapper::dataChanged()
{
}

int ClipboardWrapper::copyData(QMimeSource *s)
{
	cutOperation=false;
  QApplication::clipboard()->setData(s);
  return ++lastID;
}

int ClipboardWrapper::cutData(QMimeSource *s)
{
	cutOperation=true;
  QApplication::clipboard()->setData(s);
  return ++lastID;
}

ClipboardWrapper* ClipboardWrapper::thisInstance()
{
	return inst?inst:inst=new ClipboardWrapper;
}
