/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <stdio.h>
#include <lscondition.h>
#include <qregexp.h>

#ifdef IDSTRING
#undef IDSTRING
#endif

#define IDSTRING "mailCondition: "

// #define DEBUG_MAIL_CONDITION
// #define DEBUG_MAIL
// #define DEBUG_IF
// #define DEBUG_DATE
// #define DEBUG_NUM
// #define DEBUG_URL

#define ID_MAIL			0x100
#define ID_DATETIME	0x101
#define ID_NUMERIC	0x102
#define ID_URL			0x103
#define ID_STRING		0x104

#define ID_IN				0x201
#define ID_NOT_IN		0x202
#define ID_GT				0x203
#define ID_LT				0x204
#define ID_EQ				0x205
#define ID_NE				0x206
#define ID_LE				0x207
#define ID_GE				0x208

bool MailCondition::inOperator(QValueList<QString> left, QValueList<QString> right)
{
	unsigned c1, c2;
	for(c1=0; c1<left.count(); c1++)
	{
		bool tempresult=false;
		for(c2=0; c2<right.count(); c2++)
		{
			#ifdef DEBUG_MAIL_CONDITION
				printf(IDSTRING"inOperator: \'%s\' vs \'%s\'\n",
					(const char *)left[c1],(const char *)right[c2]);
			#endif
			if(left[c1]==right[c2])
				tempresult=true;
		}
		if(!tempresult) return false;
	}
	return true;
}

////////////////////////////// EQ operators
bool MailCondition::eqOperator (QValueList<QString> left, QValueList<QString> right)
{
	if(left.count()!=right.count()) return false;
	return inOperator(left,right);
}
bool MailCondition::eqOperator	(QString left, QString right)
{
	return left==right;
}
bool MailCondition::eqOperator	(double left, double right)
{
	return left==right;
}
bool MailCondition::eqOperator (QDateTime left, QDateTime right)
{
	return left==right;
}
////////////////////////////// LT operators
bool MailCondition::ltOperator	(QString left, QString right)
{
	return left<right;
}
bool MailCondition::ltOperator	(double left, double right)
{
	return left<right;
}
bool MailCondition::ltOperator (QDateTime left, QDateTime right)
{
	return left<right;
}
////////////////////////////// GT operators
bool MailCondition::gtOperator	(QString left, QString right)
{
	return left>right;
}
bool MailCondition::gtOperator	(double left, double right)
{
	return left>right;
}
bool MailCondition::gtOperator (QDateTime left, QDateTime right)
{
	return left>right;
}

void MailCondition::split(QString src, QString lSep, QString rSep, int dx,
		QString &left, QString &mid, QString &right)
{
	#ifdef DEBUG_MAIL_CONDITION
		printf(IDSTRING"split: %s\n",(const char *)src);
	#endif
	bool result=true;
	unsigned pos=0;
	unsigned beginPos=0;
	unsigned bracketCount=0;
	bool myflag=false;
	while(result)
	{
		if(src[pos]==lSep[0] && !myflag)
		{
			bracketCount++;
			pos++;
			myflag=true;
		}
		if(src[pos]==rSep[0])
			bracketCount--;
		if(bracketCount==0 || pos==src.length())
			result=false;
		pos++;
	}
	left=src.mid(beginPos+dx,pos-beginPos-1-dx).stripWhiteSpace();
	beginPos=src.find(' ',pos+1);
	mid=src.mid(pos, beginPos-pos).stripWhiteSpace();
	#ifdef DEBUG_MAIL_CONDITION
		printf(IDSTRING"MAIL: [c]: %s\n",(const char *)mid);
	#endif
	beginPos++;
	right=src.mid(beginPos+dx,src.length()-beginPos-1-dx).stripWhiteSpace();
	
}

bool MailCondition::testMailCondition(QString condition)
{
	QString leftStr;
	QString midStr;
	QString rightStr;
	QValueList<QString> left;
	QValueList<QString> right;
	QString temp;
	
	split(condition,"(",")",1,leftStr,midStr,rightStr);
	leftStr+=",";
	rightStr+=",";
	for(int pos=0,oldpos;pos!=-1;)
	{
		oldpos=pos;
		pos=leftStr.find(QRegExp("[,; ]"),pos+1);
		temp=leftStr.mid(oldpos, pos-oldpos).stripWhiteSpace();
		if(temp[temp.length()-1]==',') temp.remove(temp.length()-1,1);
		if(temp[temp.length()-1]==';') temp.remove(temp.length()-1,1);
		if(temp[temp.length()-1]==' ') temp.remove(temp.length()-1,1);
		if(!temp.isEmpty())
		{
			#ifdef DEBUG_MAIL
				printf(IDSTRING"MAIL: [element][L]: %s\n",(const char *)temp);
			#endif
			left.append(temp);
		}
	}
	// Generating the list of right mails...
	for(int pos=0,oldpos;pos!=-1;)
	{
		oldpos=pos;
		pos=rightStr.find(QRegExp("[,; ]"),pos+1);
		temp=rightStr.mid(oldpos, pos-oldpos).stripWhiteSpace();
		if(temp[temp.length()-1]==',') temp.remove(temp.length()-1,1);
		if(temp[temp.length()-1]==';') temp.remove(temp.length()-1,1);
		if(temp[temp.length()-1]==' ') temp.remove(temp.length()-1,1);
		if(!temp.isEmpty())
		{
			#ifdef DEBUG_MAIL
				printf(IDSTRING"MAIL: [element][R]: %s\n",(const char *)temp);
			#endif
			right.append(temp);
		}
	}
	// now that I have both lists, let's call some operators :)
	int id=0;
	if(!id && (midStr.find("in",0,false)==0))
		id=ID_IN;
	if(!id && (midStr.find("not-in",0,false)==0))
		id=ID_NOT_IN;
	if(!id && (midStr.find("==",0,false)==0))
		id=ID_EQ;
	if(!id && (midStr.find("!=",0,false)==0))
		id=ID_NE;
	switch (id)
	{
		case ID_IN:
			#ifdef DEBUG_IF
				printf(IDSTRING" if: [in] encountered\n");
			#endif
			return inOperator(left,right);
		case ID_NOT_IN:
			#ifdef DEBUG_IF
				printf(IDSTRING" if: [not-in] encountered\n");
			#endif
			return !inOperator(left,right);
		case ID_EQ:
			#ifdef DEBUG_IF
				printf(IDSTRING" if: [==] encountered\n");
			#endif
			return eqOperator(left,right);
		case ID_NE:
			#ifdef DEBUG_IF
				printf(IDSTRING" if: [!=] encountered\n");
			#endif
			return !eqOperator(left,right);
		default:
			return false;
	}
}
bool MailCondition::testDateTimeCondition(QString condition)
{
	QString leftStr;
	QString midStr;
	QString rightStr;
	split(condition,"(",")",1,leftStr,midStr,rightStr);
	QDateTime d1;
	QDateTime d2;
	int dy,mo,yr,hr,mn,sc,ml;
	sscanf((const char *)leftStr,"%d-%d-%d:%d:%d:%d.%d", &dy, &mo, &yr, &hr, &mn, &sc, &ml);
	d1.setDate(QDate(yr,mo,dy));
	d1.setTime(QTime(hr,mn,sc,ml));
	#ifdef DEBUG_DATE
		printf(IDSTRING"DateTime: %s\n",(const char *)d1.toString());
	#endif
	sscanf((const char *)rightStr,"%d-%d-%d:%d:%d:%d.%d", &dy, &mo, &yr, &hr, &mn, &sc, &ml);
	d2.setDate(QDate(yr,mo,dy));
	d2.setTime(QTime(hr,mn,sc,ml));
	#ifdef DEBUG_DATE
		printf(IDSTRING"DateTime: %s\n",(const char *)d2.toString());
	#endif
	// now that I have both lists, let's call some operators :)
	int id=0;
	if(!id && (midStr.find("<=",0,false)==0))
		id=ID_LE;
	if(!id && (midStr.find(">=",0,false)==0))
		id=ID_GE;
	if(!id && (midStr.find("<",0,false)==0))
		id=ID_LT;
	if(!id && (midStr.find(">",0,false)==0))
		id=ID_GT;
	if(!id && (midStr.find("==",0,false)==0))
		id=ID_EQ;
	if(!id && (midStr.find("!=",0,false)==0))
		id=ID_NE;
	switch (id)
	{
		case ID_EQ:
			#ifdef DEBUG_DATE
				printf(IDSTRING" if: [==] encountered\n");
			#endif
			return eqOperator(d1,d2);
		case ID_NE:
			#ifdef DEBUG_DATE
				printf(IDSTRING" if: [!=] encountered\n");
			#endif
			return !eqOperator(d1,d2);
		case ID_LT:
			#ifdef DEBUG_DATE
				printf(IDSTRING" if: [<] encountered\n");
			#endif
			return ltOperator(d1,d2);
		case ID_LE:
			#ifdef DEBUG_DATE
				printf(IDSTRING" if: [<=] encountered\n");
			#endif
			return ltOperator(d1,d2) || eqOperator(d1,d2);
		case ID_GT:
			#ifdef DEBUG_DATE
				printf(IDSTRING" if: [>] encountered\n");
			#endif
			return gtOperator(d1,d2);
		case ID_GE:
			#ifdef DEBUG_DATE
				printf(IDSTRING" if: [>=] encountered\n");
			#endif
			return gtOperator(d1,d2) || eqOperator(d1,d2);
		default:
			return false;
	}
}
bool MailCondition::testNumericCondition(QString condition)
{
	QString leftStr;
	QString midStr;
	QString rightStr;
	split(condition,"(",")",1,leftStr,midStr,rightStr);
	double d1,d2;
	d1=leftStr.toDouble();
	d2=rightStr.toDouble();
	#ifdef DEBUG_NUM
		printf(IDSTRING"numericCondition: %f %f \n",d1,d2);
	#endif
	// now that I have both lists, let's call some operators :)
	int id=0;
	if(!id && (midStr.find("<=",0,false)==0)) id=ID_LE;
	if(!id && (midStr.find(">=",0,false)==0)) id=ID_GE;
	if(!id && (midStr.find("<",0,false)==0)) id=ID_LT;
	if(!id && (midStr.find(">",0,false)==0)) id=ID_GT;
	if(!id && (midStr.find("==",0,false)==0)) id=ID_EQ;
	if(!id && (midStr.find("!=",0,false)==0)) id=ID_NE;
	switch (id)
	{
		case ID_EQ: return eqOperator(d1,d2);
		case ID_NE: return !eqOperator(d1,d2);
		case ID_LT: return ltOperator(d1,d2);
		case ID_LE: return ltOperator(d1,d2) || eqOperator(d1,d2);
		case ID_GT: return gtOperator(d1,d2);
		case ID_GE: return gtOperator(d1,d2) || eqOperator(d1,d2);
		default: return false;
	}
}
bool MailCondition::testStringCondition(QString condition)
{
	QString leftStr;
	QString midStr;
	QString rightStr;
	int id=0;

	split(condition,"\"","\"",1,leftStr,midStr,rightStr);
	if(!id && (midStr.find("<=",0,false)==0)) id=ID_LE;
	if(!id && (midStr.find(">=",0,false)==0)) id=ID_GE;
	if(!id && (midStr.find("<",0,false)==0)) id=ID_LT;
	if(!id && (midStr.find(">",0,false)==0)) id=ID_GT;
	if(!id && (midStr.find("==",0,false)==0)) id=ID_EQ;
	if(!id && (midStr.find("!=",0,false)==0)) id=ID_NE;
	switch (id)
	{
		case ID_EQ: return eqOperator(leftStr,rightStr);
		case ID_NE: return !eqOperator(leftStr,rightStr);
		case ID_LT: return ltOperator(leftStr,rightStr);
		case ID_LE: return ltOperator(leftStr,rightStr) || eqOperator(leftStr,rightStr);
		case ID_GT: return gtOperator(leftStr,rightStr);
		case ID_GE: return gtOperator(leftStr,rightStr) || eqOperator(leftStr,rightStr);
		default: return false;
	}
}
bool MailCondition::testURLCondition(QString condition)
{
	
}



bool MailCondition::testCondition(QString condition)
{
	QString restCondition;
	QString firstWord;
	int firstSpace=condition.find(' ');
	firstWord=condition.left(firstSpace);
	#ifdef DEBUG_MAIL_CONDITION
		printf(IDSTRING" TYPE: \'%s\'\n",(const char *)firstWord);
	#endif
	int id=0;
	if(!id && (firstWord.find("mail",0,false)==0))
		id=ID_MAIL;
	if(!id && (firstWord.find("date",0,false)==0))
		id=ID_DATETIME;
	if(!id && (firstWord.find("number",0,false)==0))
		id=ID_NUMERIC;
	if(!id && (firstWord.find("url",0,false)==0))
		id=ID_URL;
	if(!id && (firstWord.find("string",0,false)==0))
		id=ID_STRING;
	firstWord=condition.mid(firstSpace,condition.length()-firstSpace).stripWhiteSpace();
	#ifdef DEBUG_MAIL_CONDITION
		printf(IDSTRING" Condition: \'%s\'\n",(const char *)firstWord);
	#endif
	switch(id)
	{
	case ID_MAIL:
		return testMailCondition(firstWord);
	case ID_DATETIME:
		return testDateTimeCondition(firstWord);
	case ID_NUMERIC:
		return testNumericCondition(firstWord);
	case ID_URL:
		return testURLCondition(firstWord);
	case ID_STRING:
		return testStringCondition(firstWord);
	default:
		break;
	}
}




