/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <welcomeframe.h>
#include <videotoolbox.h>
#include <definedmessages.h>

extern VideoToolBox vtb;

WelcomeFrame::WelcomeFrame(QWidget *parent, QString name,
	int x, int y, int dx, int dy, int idx) :
	QFrame(parent, name)
{
	index=idx;
	setGeometry(x, y, dx, dy);
	setFrameStyle(0);
	// Creating the continue-cancel buttons
	// The buttons are going to be in the bottom right
	int h,w;
	w=dx-180;
	h=dy-vtb.fontHeight();
	int x,y;
	x=dx-180, y=dy-vtb.fontHeight();
	continueButton=vtb.setUpQPushButton(this,"&Continue",
		80, vtb.fontHeight(), &x, &y);
	continueButton->setDefault(true);
	x=dx-80, y=dy-vtb.fontHeight();
	finishButton=vtb.setUpQPushButton(this,"C&ancel",
		80, vtb.fontHeight(), &x, &y);
	// create the frame!
	int DX=0, DY=0;
	welcomeView= vtb.setUpTextView(this, 0, backgroundColor(),
		"<center><b><font size=+1>Welcome to"
		" <font color=#101080>Aethera</font>'s wizard.</font></b></center><br><br>"
		"&nbsp;&nbsp;&nbsp;&nbsp;This wizard will guide you through the steps of"
		" creating your own <font color=#101080>Aethera</font> profile.<br><br>"
		"&nbsp;&nbsp;&nbsp;&nbsp;If you can't answer all the mail related questions"
		" please ask your system administrator for assistance.<br><br>"
		"&nbsp;&nbsp;&nbsp;&nbsp;Please click <b>Continue</b> to go to the next"
		" step or <b>Cancel</b> to exit this wizard..",
		dx,dy-vtb.fontHeight()-vtb.offsetY(),DX,DY);
	welcomeView->setHScrollBarMode(QScrollView::AlwaysOff);
	connect(continueButton, SIGNAL(clicked()), this, SLOT(continueClicked()));
	connect(finishButton, SIGNAL(clicked()), this, SLOT(finishClicked()));
}
void WelcomeFrame::continueClicked()
{
	QStringList rez;
	rez.append("[Welcome]");
	emit result(ContinueMessage,index, rez);
	close();
}

void WelcomeFrame::finishClicked()
{
	emit result(CancelMessage,index, QStringList(""));
	close();
}

