/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __DataCollection__
#define __DataCollection__

#include <qstring.h>
#include <qcstring.h>
#include <qlist.h>
#include <qstringlist.h>
#include <qdatetime.h>
#include <qdict.h>

class DataCollection;

class ObjectReference
{
	public:
    bool dirty;
		bool isNewObject;
		QString filename, id;
		int offset, length;
		QByteArray rawData;
    QDateTime lastModified;
		DataCollection *collection;
};

class DataCollection
{
	public:
    DataCollection(QString prefix=QString::null);
    virtual ~DataCollection();
    
		// data
		QString storageDevice;
		QList<ObjectReference> objectList;
		enum CollectionType { FileStorage=0, FolderStorage };
    enum AddressingMode { Sequential=0, Indexed };
    CollectionType type;
		
		QString idPrefix;
		unsigned long lastIDNum;
		virtual QString nextID();
		virtual QString lastID();
		virtual bool isValidID(QString);
		
		// methods
		virtual void buildEntryList()=0;
		QStringList getEntryList();
    QDict<ObjectReference> getEntryDict();
		virtual QString addEntry();
		virtual QString addEntry(ObjectReference *);
		virtual bool removeEntry(QString id, bool sync=true)=0;
    ObjectReference *ref(QString id);
};

#endif
