/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <dateclass.h>
#include <qtextstream.h>

DateClass::DateClass(const QCString &d)
{
  int pos;
  QTextStream txt(d, IO_ReadOnly);
  QCString t;
  char c;
  
  txt>>t;
  
  // check for the optional day name
  if((pos=t.find(","))!=-1)
  {
    day_of_week=t.left(pos);
    txt>>t;
  }
  
  day=t.toInt();
  
  txt>>month_of_year;
  txt>>year;
  
  // Y2K stuff; should work until 2080 :)
  if(year<80)
    year=2000+year;
  else if(year<100)
    year=1900+year;
 
  txt>>hour;
  txt>>c;
  txt>>minute;
  txt>>c;
  
  if(c==':')
  {
    txt>>sec;
    txt>>timezone;
  }
  else
  {
    sec=0;
    txt>>timezone;
    timezone.prepend((const char *)(QCString)c);
  }
  
  // compute the month number
  t=month_of_year.lower();
  if(t=="jan")
    month=1;
  else if(t=="feb")
    month=2;
  else if(t=="mar")
    month=3;
  else if(t=="apr")
    month=4;
  else if(t=="may")
    month=5;
  else if(t=="jun")
    month=6;
  else if(t=="jul")
    month=7;
  else if(t=="aug")
    month=8;
  else if(t=="sep")
    month=9;
  else if(t=="oct")
    month=10;
  else if(t=="nov")
    month=11;
  else if(t=="dec")
    month=12;
  
  // compute the day name, if necessary
  if(day_of_week.isEmpty())
  {
    QDate k(year, month, day);
    day_of_week=k.dayName(k.dayOfWeek());
  }
}

DateClass::DateClass(unsigned int date_t)
{
	QDateTime dateTime;
	if(date_t)
		dateTime.setTime_t(date_t);
	else
		dateTime=QDateTime::currentDateTime();
	
	QDate d=dateTime.date();
	QTime t=dateTime.time();
	
	day_of_week=d.dayName(d.dayOfWeek());
	month_of_year=d.monthName(d.month());
	timezone=""; // oops
	day=d.day();
	month=d.month();
	year=d.year();
	hour=t.hour();
	minute=t.minute();
	sec=t.second();
}

DateClass::DateClass(const QDateTime &d)
{
	day=d.date().day();
	month=d.date().month();
	year=d.date().year();
	hour=d.time().hour();
	minute=d.time().minute();
	sec=d.time().second();
	timezone=""; // oops
	day_of_week=d.date().dayName(d.date().dayOfWeek());
	month_of_year=d.date().monthName(month);
}

DateClass::operator QDate() const
{
  return QDate(year, month, day);
}

QDate DateClass::toQDate() const
{
	return operator QDate();
}

DateClass::operator QTime() const
{
  return QTime(hour, minute, sec);
}

QTime DateClass::toQTime() const
{
	return operator QTime();
}

DateClass::operator QCString() const
{
  QCString t;
  t.sprintf("%s, %02d %s %04d %02d:%02d", (const char *)day_of_week, day, (const char *)month_of_year, year, hour, minute);
  
  return t;
}

QCString DateClass::toQCString() const
{
	return operator QCString();
}

DateClass::operator QDateTime() const
{
  return QDateTime((QDate)(*this), (QTime)(*this));
}

QDateTime DateClass::toQDateTime() const
{
	return operator QDateTime();
}

QTextStream& operator<<(QTextStream &s, const DateClass &d)
{
  QCString t;
  t.sprintf("%s, %02d %s %04d %02d:%02d:%02d %s", (const char *)d.day_of_week, d.day, (const char *)d.month_of_year, d.year, d.hour,
      d.minute, d.sec, (const char *)d.timezone);
  s<<t;
  return s;
}

QDataStream& operator>>(QDataStream &s, DateClass &d)
{
	s>>d.day_of_week;
	s>>d.month_of_year;
	s>>d.timezone;
	s>>d.day;
	s>>d.month;
	s>>d.year;
	s>>d.hour;
	s>>d.minute;
	s>>d.sec;
	return s;
}

QDataStream& operator<<(QDataStream &s, const DateClass &d)
{
	s<<d.day_of_week;
	s<<d.month_of_year;
	s<<d.timezone;
	s<<d.day;
	s<<d.month;
	s<<d.year;
	s<<d.hour;
	s<<d.minute;
	s<<d.sec;
	return s;
}
