/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <qpopupmenu.h>
#include <kmenubar.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qlayout.h>
#include <qfont.h>
#include <qlist.h>
#include <qfontmetrics.h>
#include <carddialog.h>
#include <carddialogwidget.h>
#include <etoolbarbutton.h>
#include <toolbarseparator.h>
#include <ebutton.h>
#include <pixlibrary.h>
#include <miscfunctions.h>
#include <qmessagebox.h>

// #define DEBUG_CARDDIALOG


CardDialog::CardDialog(ContactObject *contact, QWidget *parent, bool *saved, const char *name) : KMainWindow(parent, name)//, WType_Modal)
{
	_tile=0;
	_fields=0;
	_newCard=false;
	initToolBar();
	// buttons enable/disable
	upArrowButton->setDisabled(true);
	downArrowButton->setDisabled(true);
	clearButton->setDisabled(true);
	helpButton->setDisabled(true);
	sendMailButton->setDisabled(true);
	printButton->setDisabled(true);
	saveButton->setDisabled(false);
	addToGroupButton->setDisabled(true);
	// the widget
	dialogWidget = new CardDialogWidget(contact, this);
	if(contact)
		setCaption(contact->fn());
	setMenu();
	// disabling by default some of them
	setToolbar();
	
	setCentralWidget(dialogWidget);
	layout()->setResizeMode(QLayout::FreeResize);
	connect(dialogWidget, SIGNAL(newHeight(int)), this, SLOT(setNewHeight(int)));
}

void CardDialog::setCaption(QString str, bool modified)
{
	if(modified!=_modified || str!=_str)
	{
		KMainWindow::setPlainCaption(QString("Contact: ")+str + ((modified)?" (*)":""));
		_modified=modified;
		_str=str;
	}
}


void CardDialog::setMenu()
{
	QPopupMenu *file = new QPopupMenu(this);
	file->insertItem("&Save and Close", dialogWidget, SLOT(saveCloseCard()), CTRL+Key_W);
	file->insertItem("S&ave", dialogWidget, SLOT(saveCard()), CTRL+Key_S);
	file->insertItem("&Clear", dialogWidget, SLOT(clearCard()));
	file->insertSeparator();
	file->insertItem("&Print", dialogWidget, SLOT(printCard()));
	file->insertSeparator();
	file->insertItem("C&lose", this, SLOT(close()));
	QPopupMenu *tools = new QPopupMenu(this);
	tools->insertItem("Send E-mail to...", dialogWidget, SLOT(sendCard()));
	tools->insertItem("Add to group", dialogWidget, SLOT(groupCard()));
	tools->insertSeparator();
	tools->insertItem("Previous", dialogWidget, SLOT(prevCard()));
	tools->insertItem("Next", dialogWidget, SLOT(nextCard()));
	QPopupMenu *help = new QPopupMenu(this);
	help->insertItem("Index", dialogWidget, SLOT(helpCard()));

	KMenuBar *bar=menuBar();
	bar->insertItem("Card", file);
	bar->insertItem("Tools",tools);
	bar->insertSeparator();
	bar->insertItem("Help",help);
	bar->show();
}

void CardDialog::initToolBar()
{
	QFontMetrics fm(QFont("Helvetica",10,QFont::Normal));
	toolBar()->setBarPos(KToolBar::Top);
	EToolBarButton *b = new  EToolBarButton(PixLibrary::thisInstance()->pixmap(PixLibrary::SaveIcon), toolBar());
	saveButton = b;
	b->setText("Save");

	b = new  EToolBarButton(PixLibrary::thisInstance()->pixmap(PixLibrary::NewIcon), toolBar());
	clearButton = b;
	b->setText("New");
	toolBar()->insertWidget(2, 30 + fm.width("New"), b);

	b = new  EToolBarButton(PixLibrary::thisInstance()->pixmap(PixLibrary::PrintIcon), toolBar());
	printButton = b;
	b->setText("Print");

	b = new  EToolBarButton(PixLibrary::thisInstance()->pixmap(PixLibrary::SendMailIcon), toolBar());
	sendMailButton = b;
	b->setText("Send mail to...");

	b = new  EToolBarButton(PixLibrary::thisInstance()->pixmap(PixLibrary::GroupIcon), toolBar());
	addToGroupButton = b;
	b->setText("Add to group");

	ToolBarSeparator *ts = new ToolBarSeparator(toolBar());

	b = new  EToolBarButton(toolBar());
	downArrowButton = b;
	b->setNormalPixmap(PixLibrary::thisInstance()->pixmap(PixLibrary::ArrowDownNormalIcon));
	b->setFocusPixmap(PixLibrary::thisInstance()->pixmap(PixLibrary::ArrowDownFocusIcon));
	b->setClickedPixmap(PixLibrary::thisInstance()->pixmap(PixLibrary::ArrowDownFocusIcon));

	b = new  EToolBarButton(toolBar());
	upArrowButton = b;
	b->setNormalPixmap(PixLibrary::thisInstance()->pixmap(PixLibrary::ArrowUpNormalIcon));
	b->setFocusPixmap(PixLibrary::thisInstance()->pixmap(PixLibrary::ArrowUpFocusIcon));
	b->setClickedPixmap(PixLibrary::thisInstance()->pixmap(PixLibrary::ArrowUpFocusIcon));

	ts = new ToolBarSeparator(toolBar());

	b = new  EToolBarButton(toolBar());
	helpButton = b;
	b->setNormalPixmap(PixLibrary::thisInstance()->pixmap(PixLibrary::HelpNormalIcon));
	b->setFocusPixmap(PixLibrary::thisInstance()->pixmap(PixLibrary::HelpFocusIcon));
	b->setClickedPixmap(PixLibrary::thisInstance()->pixmap(PixLibrary::HelpFocusIcon));
	b->setFixedWidth(b->width());
}

void CardDialog::setToolbar()
{
	connect(saveButton, SIGNAL(clicked()), dialogWidget, SLOT(saveCard()));
	connect(clearButton, SIGNAL(clicked()), dialogWidget, SLOT(newCard()));
	connect(printButton, SIGNAL(clicked()), dialogWidget, SLOT(printCard()));
	connect(sendMailButton, SIGNAL(clicked()), dialogWidget, SLOT(sendCard()));
	connect(addToGroupButton, SIGNAL(clicked()), dialogWidget, SLOT(groupCard()));
	connect(downArrowButton, SIGNAL(clicked()), dialogWidget, SLOT(nextCard()));
	connect(upArrowButton, SIGNAL(clicked()), dialogWidget, SLOT(prevCard()));
	connect(helpButton, SIGNAL(clicked()), dialogWidget, SLOT(helpCard()));
}

void CardDialog::setNewHeight(int h)
{
	resize(dialogWidget->width(), h+ toolBar()->height());
#ifdef DEBUG_CARDDIALOG
	printf("Height: %d, real: %d\n", h, height());
#endif
}

void CardDialog::setTile(CardTileView *item)
{
	_tile=item;
}

void CardDialog::setFields(QStringList *item)
{
	_fields=item;
}
void CardDialog::setNewCard(bool nc)
{
	_newCard=nc;
}

CardTileView *CardDialog::tile() { return _tile; }
QStringList *CardDialog::fields() { return _fields; }
bool CardDialog::newCard() { return _newCard; }

CardDialog::~CardDialog()
{
	if(dialogWidget->card()->fn().isEmpty())
	{
		if(!BrokerInterface::thisInstance()->remove(dialogWidget->card()->path()))
		{
			QMessageBox::information(0, "Delete failed",
				QString("Could not delete object.\nReason: ")+
				BrokerInterface::thisInstance()->lastError(), 1);
		}
	}
	emit(dialogClosed(dialogWidget->card()->path()));
}
