/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __CommConversions__
#define __CommConversions__

#include <qstring.h>
#include <qcstring.h>
#include <qstringlist.h>
#include <qstrlist.h>
#include <qfont.h>
#include <qpoint.h>
#include <qsize.h>
#include <any.h>
#include <rmicalldata.h>
#include <qmap.h>

int 				_narrowInt(const QByteArray &d);
QString 		_narrowQString(const QByteArray &d);
bool 				_narrowBool(const QByteArray &d);
QStringList _narrowQStringList(const QByteArray &d);
QCString 		_narrowQCString(const QByteArray &d);
QStrList 		_narrowQStrList(const QByteArray &d);
QDateTime	  _narrowQDateTime(const QByteArray &d);
QFont 		  _narrowQFont(const QByteArray &d);
QPoint 		  _narrowQPoint(const QByteArray &d);
QSize 		  _narrowQSize(const QByteArray &d);
Any         _narrowAny(const QByteArray &d);
RMICallData _narrowRMICallData(const QByteArray &d);


QByteArray _stream(const QString &t);
QByteArray _stream(const QCString &t);
QByteArray _stream(const QStringList &t);
QByteArray _stream(const QStrList &t);
QByteArray _stream(const QDateTime &t);
QByteArray _stream(const QFont &t);
QByteArray _stream(const QPoint &t);
QByteArray _stream(const QSize &t);
QByteArray _stream(int t);
QByteArray _stream(bool t);
QByteArray _stream(const Any &t);
QByteArray _stream(const RMICallData &t);
QByteArray _stream(const QMap<QString, QByteArray> &);

#endif

