/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __ContactObject__
#define __ContactObject__

#include <clientvfs.h>
#include <qstring.h>
#include <qfont.h>
#include <qsize.h>
#include <qpoint.h>
#include <qdatetime.h>
#include <vobject.h>
#include <vobjectfactory.h>
#include <queryprocessor.h>
#include <any.h>
#include <qstringlist.h>

/**
 * the contact (business card) object class
 */

class ContactObject : public VObject
{
	/**
	 * always include ClientVFS as a friend class, since we use the 
	 * _new or _ref ClientVFS template methods to create any kind of VObjects
	 */
	friend class ClientVFS;
	protected:
		/**
		 * the contructor is always protected or private
		 */
		ContactObject(QString _path, QByteArray &_data);
		ContactObject(QString _path);
	public:
		/**
		 *	The types for the security
		 */
		enum { Private=0, Public=1, Confidential=2 };
		/**
		 *	The types for the phones (these are fixed)
		 */
		enum { Work=0, Home=1};
		enum { Normal=0, Pref=1>>1};
		enum { Voice=0, Msg=1>>2, Fax=1>>3, Cell=1>>4, Pager=1>>5, 
					Bbs=1>>6, Modem=1>>7, Car=1>>8, Isdn=1>>9, Pcs=1>>10, Video=1>>11 };
		
		/**
		 * the destructor
		 */
		~ContactObject();
		/**
		 *	Phone type conversion method:
		 */
		static unsigned long convertPhoneType(QString);
		/**
		 * get/set methods for internal properties
		 */
		void setFn(QString);
		QString fn();
		void setN(QStringList);
		QStringList n();
		void setHomeAdr(QStringList);
		QStringList homeAdr();
		void setPhone(QStringList);
		QStringList phone();
		void setPhoneType(QStringList);
		QStringList phoneType();
		void setWorkAdr(QStringList);
		QStringList workAdr();
		void setEmails(QStringList);
		QStringList emails();
		void setDefaultEmail(int);
		int defaultEmail();
		void setNotes(QString);
		QString notes();
		void setURLs(QStringList);
		QStringList URLs();
		void setNick(QString);
		QString nick();
		void setSecurity(int newSecurity=Private);
		int security();
		void setBday(QString);
		QString bday();
		void setOrg(QString);
		QString org();
		void setRole(QString);
		QString role();
		void setTitle(QString);
		QString title();
		void setPos(QString);
		QString pos();
		void setClassCard(QString);
		QString classCard();
		void setCategories(QString);
		QString categories();
		void setVcard2(QString);
		QString vcard2();
		void setVcard3(QString);
		QString vcard3();
		void setCategory(QString);
		QString category();
		void setRelatedObjectList(const QStringList &);
		QStringList relatedObjectList();
		
		/**
		 * object marshalling methods (overloaded from VObject, so that 
		 * save() and sync() work)
		 */
		QByteArray _stream();
		void _narrow(const QByteArray &);
		/**
		 * query handling
		 */
		virtual bool getProperty(const QString &query, Any &property);
		virtual bool setProperty(const QString &query, Any &property);
		virtual QueryProcessor::QueryType queryType(const QString &query);
	private:
		/**
		 * internal data
		 */
		QString _fn;
		QStringList _n;
		QStringList _homeAdr;
		QStringList _workAdr;
		QStringList _phone;
		QStringList _phoneType;
		QStringList _emails;
		int _defaultEmail;
		QString _notes;
		QStringList _URLs;
		QString _nick;
		QString _bday;
		QString _org;
		QString _role;
		QString _title;
		QString _classCard;
		QString _categories;
		QString _category;
		int _security;
		QStringList _relatedObjectList;
		QByteArray _extraData;
};

// the contact object factory

class ContactObjectFactory : public VObjectFactory
{
	public:
		ContactObject *_new(QString _path);
		ContactObject *_new(QString _path, QByteArray& _data);
};

#endif
