/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <kconfig.h>

#include <srconfigbase.h>
#include <srconfig.h>

extern KConfig *GlobalConfig;

SendReceiveConfig::SendReceiveConfig(QWidget *parent, const char *name=0)
{
	load();
}

void SendReceiveConfig::load()
{
	GlobalConfig->setGroup("Misc Mail");
	saveSentCheck->setChecked(GlobalConfig->readEntry("Permanent delete")=="No");
	displayProgressCheck->setChecked(GlobalConfig->readEntry("Display progress")=="Yes");
	GlobalConfig->setGroup("Receive Options");
	checkEdit->setText(GlobalConfig->readEntry("Interval"));
	GlobalConfig->setGroup("Folder Management");
	wastedEdit->setText(GlobalConfig->readEntry("Waste"));
	GlobalConfig->setGroup("Accelerators");
	f5AccelGroup->setButton((GlobalConfig->readEntry("F5", "all")=="all")?0:1);
}
void SendReceiveConfig::sync(bool visible=false)
{
	bool doSync=(!visible && isVisible()) | (visible);
	if(!doSync)
		return;
	GlobalConfig->setGroup("Accelerators");
	GlobalConfig->writeEntry("F5",(RadioButton2->isChecked())?"default":"all");
	GlobalConfig->setGroup("Misc Mail");
	GlobalConfig->writeEntry("Permanent delete", ((saveSentCheck->isChecked())?"No":"Yes"));
	GlobalConfig->writeEntry("Display progress", ((displayProgressCheck->isChecked())?"Yes":"No"));
	GlobalConfig->setGroup("Receive Options");
	if(checkEdit->text().toInt()<60)
		checkEdit->setText("60");
	GlobalConfig->writeEntry("Interval", checkEdit->text().toInt());
	GlobalConfig->setGroup("Folder Management");
	if(checkEdit->text().toInt()<60)
		checkEdit->setText("60");
	GlobalConfig->writeEntry("Interval", checkEdit->text().toInt());
	emit(noChanged());
}

void SendReceiveConfig::f5AccelChanged(int)
{
	emit(changed());
}

void SendReceiveConfig::checkMessagesChanged(const QString &)
{
	emit(changed());
}

void SendReceiveConfig::displayProgressClicked()
{
	emit(changed());
}

void SendReceiveConfig::wastedChanged(const QString &)
{
	emit(changed());
}

void SendReceiveConfig::saveSentClicked()
{
	emit(changed());
}
