#! /bin/sh
#
# command_enum.sh
#
#-------------------------------------------------------------------------------
# Copyright (C) 2004, 2005, 2006 Sylvain Fourmanoit <syfou@users.sourceforge.net>
#  
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to
# deal in the Software without restriction, including without limitation the
# rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
# sell copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#  
# The above copyright notice and this permission notice shall be included in
# all copies of the Software and its documentation and acknowledgment shall be
# given in the documentation and software packages that this Software was
# used.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
# THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
# IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
#
#-------------------------------------------------------------------------------
# Quick and dirty but hopefully portable script to generate
# command list from const COMMAND COMMANDS[] in command.c
#
# Usage: command_enum.sh [--with-help]
#
# Note: Only tested with GNU sed 4.0.9. Will anyway probably only work
# with it, since we make use of many GNU extensions.
#
#-------------------------------------------------------------------------------

name_and_description () {
    sed -n '/const COMMAND/,/NULL, NULL/p' command.c | \
    sed '1d;$d' | \
    sed 's/[^"]*"\([^"]\+\)"[^"]*/\1\n/g' | \
    sed '/^$/d' | \
    sed '/^[a-z]/{s/.*/CMD_\U&/;h;d};/^[A-Z]/{x;G;s/\n/\t/}'
}

if test "x$1" != "x--with-help" ; then
cat<<EOF
/* Automatically generated by `basename $0` 
   on `date` */
EOF
name_and_description | sed 's/\(.*\)\t.*/\1/;1s/$/=0/;s/$/,/'
echo "CMD_UNKNOWN"
else
name_and_description
fi
