(in-package "ACL2")

;see flooreric-proofs for all proofs (and todos?)

(local (include-book "flooreric-proofs"))


;;
;; Behavior of floor when its guards are violated
;;

(defthm floor-with-i-not-rational
  (implies (not (rationalp i))
           (equal (floor i j)
                  (if (and (complex-rationalp i) (complex-rationalp j) (rationalp (/ i j)))
                      (floor (/ i j) 1)
                    0))))

(defthm floor-with-j-not-rational
  (implies (not (rationalp j))
           (equal (floor i j)
                  (if (and (complex-rationalp i) (complex-rationalp j) (rationalp (/ i j)))
                      (floor (/ i j) 1)
                    0))))

;special case of floor-with-i-not-rational but contains no if
(defthm floor-with-i-not-rational-but-j-rational
  (implies (and (not (rationalp i))
                (rationalp j)
                )
           (equal (floor i j)
                  0)))

;special case of floor-with-j-not-rational but contains no if
(defthm floor-with-j-not-rational-but-i-rational
  (implies (and (not (rationalp i))
                (rationalp j)
                )
           (equal (floor i j)
                  0)))

;;
;; type prescriptions
;;

; (thm (rationalp (floor i j)))) goes through

(defthm floor-non-negative-rationalp-type-prescription
  (implies (and (<= 0 i)
                (<= 0 j)
                (case-split (not (complex-rationalp j)))
                )
           (and (<= 0 (floor i j))
                (rationalp (floor i j))))
  :rule-classes (:type-prescription))




(defthm floor-non-negative
  (implies (and (<= 0 i)
                (<= 0 j)
                (case-split (rationalp i));drop?
                )
           (<= 0 (floor i j))))





(defthm floor-compare-to-zero
  (implies (and (case-split (rationalp i))
                (case-split (rationalp j)))
           (equal (< (floor i j) 0)
                  (or (and (< i 0) (< 0 j))
                      (and (< 0 i) (< j 0))
                      ))))

(defthm floor-of-non-acl2-number
  (implies (not (acl2-numberp i))
           (and (equal (floor i j)
                       0)
                (equal (floor j i)
                       0))))

;linear? how should it be phrased?
;too many hints.  without the frac-coeff rule, things worked out here
(defthm floor-upper-bound
    (implies (and (case-split (rationalp i))
                  (case-split (rationalp j))
                  )
	     (<= (floor i j) (/ i j)))
    :rule-classes (:rewrite (:linear :trigger-terms ((floor i j)))))



(defthm floor-equal-i-over-j-rewrite
  (implies (and (case-split (rationalp i))
                ;(case-split (not (equal i 0)))
                (case-split (not (equal j 0)))
                (case-split (rationalp j))
                )
           (equal (EQUAL (* J (FLOOR I J)) I)
                  (integerp (* i (/ j))))))
;move
(defthm dumb
  (equal (< x x)
         nil))

(defthm floor-with-j-zero
  (equal (floor i 0)
         0))


;(defthm floor-greater-than-zero-rewrite
 ; (equal (< 0 (fl i j))
  ;       (

(defthm floor-upper-bound-2
  (implies (and (<= 0 j)
                (case-split (rationalp i))
                (case-split (rationalp j))
                (case-split (not (equal j 0)))
                )
           (<= (* j (floor i j)) i))
  :rule-classes (:rewrite (:linear :trigger-terms ((floor i j)))))


(defthm floor-upper-bound-3
  (implies (and (<= j 0)
                (case-split (rationalp i))
                (case-split (rationalp j))
                (case-split (not (equal j 0)))
                )
           (<= i (* j (floor i j))))
  :rule-classes (:rewrite (:linear :trigger-terms ((floor i j)))))


(defthm floor-lower-bound
  (implies (and (case-split (rationalp i))
                (case-split (rationalp j))
                )
           (< (+ -1 (* i (/ j))) (floor i j)))
  :rule-classes (:rewrite (:linear :trigger-terms ((floor i j)))))


(defthm floor-lower-bound
  (implies (and (case-split (rationalp i))
                (case-split (rationalp j))
                )
           (< (+ -1 (* i (/ j))) (floor i j)))
  :rule-classes (:rewrite (:linear :trigger-terms ((floor i j)))))


(defthm floor-when-arg-quotient-isnt-rational
  (IMPLIES (NOT (RATIONALP (* i (/ j))))
           (EQUAL (FLOOR i j) 0)))

(defthm floor-of-non-rational-by-one
  (implies (not (rationalp i))
           (equal (floor i 1)
                  0)))

(defthm floor-of-rational-and-complex
  (implies (and (rationalp i)
                (not (rationalp j))
                (case-split (acl2-numberp j)))
           (and (equal (floor i j)
                       0)
                (equal (floor j i)
                       0))))

#|
(defthm floor-of-two-complexes
  (implies (and (complex-rationalp i)
                (complex-rationalp j))
           (equal (floor i j)
                  (if (rationalp (/ i j))
                      (floor (/ i j) 1)
                    0)))
  :hints (("Goal" :in-theory (enable floor))))
|#


(defthm floor-of-zero
  (equal (floor 0 j)
         0))

