// -*- C++ -*-

//=============================================================================
/**
 *  @file FTRT_ClientORB_Initializer.h
 *
 *  FTRT_ClientORB_Initializer.h,v 1.5 2005/06/14 08:54:59 jwillemsen Exp
 *
 *  @author Huang-Ming Huang <hh1@cse.wustl.edu>
 */
//=============================================================================


#ifndef FTRT_CLIENTORB_INITIALIZER_H
#define FTRT_CLIENTORB_INITIALIZER_H

#include /**/ "ace/pre.h"

#include "tao/LocalObject.h"


#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include "tao/PI/PI.h"

// This is to remove "inherits via dominance" warnings from MSVC.
// MSVC is being a little too paranoid.
#if defined(_MSC_VER)
#pragma warning(push)
#pragma warning(disable:4250)
#endif /* _MSC_VER */

/// RTCORBA ORB initializer.
class FTRT_ClientORB_Initializer :
  public virtual PortableInterceptor::ORBInitializer,
  public virtual TAO_Local_RefCounted_Object
{
public:
  /// Priority mapping types
  FTRT_ClientORB_Initializer (int transaction_depth);

  virtual void pre_init (PortableInterceptor::ORBInitInfo_ptr info
                         ACE_ENV_ARG_DECL_WITH_DEFAULTS)
    ACE_THROW_SPEC ((CORBA::SystemException));

  virtual void post_init (PortableInterceptor::ORBInitInfo_ptr info
                          ACE_ENV_ARG_DECL_WITH_DEFAULTS)
    ACE_THROW_SPEC ((CORBA::SystemException));
private:
  PortableInterceptor::ClientRequestInterceptor_var client_interceptor_;
};

#if defined(_MSC_VER)
#pragma warning(pop)
#endif /* _MSC_VER */


#include /**/ "ace/post.h"

#endif /* FTRT_CLIENTORB_INITIALIZER_H */
