package org.jboss.test.remoting.transport.multiplex.ssl.serversocketrefresh;

import junit.framework.TestCase;

import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.security.SSLSocketBuilder;
import org.jboss.remoting.transport.multiplex.MultiplexInvokerConstants;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Michael Voss
 *
 */
public class TestClient extends TestCase{
	
   private static Logger log = Logger.getLogger(TestClient.class);
	private String localHost="127.0.0.1";
	private String keyStorePath="src/tests/org/jboss/test/remoting/transport/multiplex/ssl/serversocketrefresh/certificate/clientKeyStore";
	private String trustStorePath="src/tests/org/jboss/test/remoting/transport/multiplex/ssl/serversocketrefresh/certificate/clientTrustStore";
	private String keyStorePassword="testpw";
	private String trustStorePassword="testpw";
	private String localPort="2002";
	InvokerLocator locator;
	Client client;
	Map configuration;
	private boolean secondPass=false;
	
	public void setUp() throws Exception{
		
		locator=new InvokerLocator("sslmultiplex://localHost:2001");
		
		//the client side connection endpoint
		configuration = new HashMap();

      keyStorePath = this.getClass().getResource("certificate/clientKeyStore").getFile();
      trustStorePath = this.getClass().getResource("certificate/clientTrustStore").getFile();

//      configuration.put(MultiplexInvokerConstants.MULTIPLEX_BIND_HOST_KEY,localHost);
//		configuration.put(MultiplexInvokerConstants.MULTIPLEX_BIND_PORT_KEY,localPort);				
		
		
		configuration.put(SSLSocketBuilder.REMOTING_KEY_STORE_TYPE, "JKS");
		configuration.put(SSLSocketBuilder.REMOTING_KEY_STORE_FILE_PATH, keyStorePath);
		configuration.put(SSLSocketBuilder.REMOTING_KEY_STORE_PASSWORD, keyStorePassword);
		configuration.put(SSLSocketBuilder.REMOTING_KEY_STORE_ALGORITHM, "SunX509");
		
		configuration.put(SSLSocketBuilder.REMOTING_TRUST_STORE_TYPE, "JKS");
		configuration.put(SSLSocketBuilder.REMOTING_TRUST_STORE_FILE_PATH, trustStorePath);
		configuration.put(SSLSocketBuilder.REMOTING_TRUST_STORE_PASSWORD, trustStorePassword);
		configuration.put(SSLSocketBuilder.REMOTING_TRUST_STORE_ALGORITHM, "SunX509");
		
		client=new Client(locator,"Sample",configuration);				
		try{
			client.connect();		
		}catch(Exception e){
			if(secondPass) return;//unit test succeeds if client can not connect in second pass
			else throw e;
		}
		if(secondPass) throw new Exception("should not reach this point");//because client should not be accepted by new server truststore
	}
	
	public void tearDown() throws Exception{
       log.info("entering TestClient.tearDown()");
		Thread.sleep(10000);//let the server fetch his new truststore and refresh serversocket
		client.disconnect();
		Thread.sleep(5000);
//		localPort="1003";
		secondPass=true;
		setUp();//secondPass -> client is not accepted by new truststore
        log.info("TestClient.tearDown() done");
		
	}
	
	/**
	 * @throws Throwable
	 */
	public void test() throws Throwable{
		System.err.println("Invoking server with 'something'");
		System.err.println("Server answer is: "+client.invoke("something"));
	}
	
	
	
}
