/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.test.remoting.transport.multiplex.config;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

import junit.framework.TestCase;

import org.jboss.logging.Logger;


/**
 * 
 * @author <a href="mailto:ron.sigal@jboss.com">Ron Sigal</a>
 * @version $Revision$
 * <p>
 * Copyright (c) May 19, 2006
 * </p>
 */
public class ClientConfigurationTestClient extends TestCase
{
   protected static Logger log = Logger.getLogger(ClientConfigurationTestClient.class);
   protected static boolean connectorStarted;
   protected Socket syncSocket;
   protected OutputStream os;
   protected InputStream is;
   
   
   public void setUp()
   {
      Exception savedException = null;
      
      for (int i = 0; i < 5; i++)
      {
         try
         {
            syncSocket = new Socket(ClientConfigurationTestServer.syncHost, ClientConfigurationTestServer.syncPort);
            os = syncSocket.getOutputStream();
            is = syncSocket.getInputStream();
            
            if (!connectorStarted)
            {
               is.read();
               connectorStarted = true;
            }
            
            break;
         }
         catch (Exception e)
         {
            savedException = e;
            try
            {
               Thread.sleep(1000);
            }
            catch (InterruptedException ignored)
            {
            }
         }
      }
      
      if (syncSocket == null)
      {
         log.error(savedException);
      }
   }
}
