/* e_card1.cc
 *$Header: /al/acs/src/RCS/e_card1.cc,v 9.20 95/10/15 22:31:33 al Exp $
 * Base class for "cards" in the circuit description file
 * This file contains iterators -- functions that process a list of cards
 */
#include "error.h"
#include "e_card.h"
/*--------------------------------------------------------------------------*/
//	void	CARD::expand_group();
//	int	CARD::dotr_group();
//	void	CARD::trload_group();
//	void	CARD::trunload_group();
//	void	CARD::doac_group();
//	double	CARD::tr_review_group();
/*--------------------------------------------------------------------------*/
extern const char e_int[];
/*--------------------------------------------------------------------------*/
/* expand_group: expand (flatten) a list of components (subckts)
 * Scan component list.  Expand each subckt: create actual elements
 * for flat representation to use for simulation.
 * Recursive to allow for nested subckts.
 */
void CARD::expand_group()
{
  CARD *brh;
  brh = this;
  do {
    brh->expand();
    brh = brh->next();
  } while (brh != this);
}
/*--------------------------------------------------------------------------*/
/* dotr_group: evaluate a list of models
 * evaluates a list (or sublist), checks convergence, etc.
 * does not load the matrix
 * argument is the head of the netlist.
 * recursively called to evaluate subcircuits
 */
int CARD::dotr_group()
{
  int isconverged = TRUE;
  CARD *brh;
  brh = this;
  do {
    if (!brh->evaluated()){
      isconverged &= brh->dotr();
    }else{
      error(bDANGER, e_int, "double load");
    }
    brh = brh->next();
  } while (brh != this);
  return isconverged;
}
/*--------------------------------------------------------------------------*/
/* trload_group: load list of models to the matrix
 * recursively called to load subcircuits
 */
void CARD::trload_group()
{
  CARD *brh;
  brh = this;
  do {
    brh->trload();
    brh = brh->next();
  } while (brh != this);
}
/*--------------------------------------------------------------------------*/
/* trunload_group: remove a list of models from the matrix
 * recursively called to unevaluate subcircuits
 */
void CARD::trunload_group()
{
  CARD *brh;
  brh = this;
  do {
    brh->trunload();
    brh = brh->next();
  } while (brh != this);
}
/*--------------------------------------------------------------------------*/
void CARD::doac_group()
{
  CARD *brh;
  brh = this;
  do {
    if (!brh->evaluated())
      brh->doac();
    brh = brh->next();
  } while (brh != this);
}
/*--------------------------------------------------------------------------*/
double CARD::tr_review_group()
{
  double worsttime = BIGBIG;
  double thistime;
  CARD *brh;
  brh = this;
  do {
    thistime = brh->tr_review();
    if (thistime < worsttime){
      worsttime = thistime;
    }
    brh = brh->next();
  } while (brh != this);
  return worsttime;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
