'\"
'\" Copyright (c) 1990-1994 The Regents of the University of California.
'\" Copyright (c) 1994-1995 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) radiobutton.n 1.33 95/06/07 21:15:26
'\" 
.so man.macros
.TH radiobutton n 4.0 Tk "Tk Generic Methods"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
radiobutton \- Create and manipulate radiobutton widgets
.SH SYNOPSIS
\fI$radiobutton\fR = \fI$parent\fR->\fBRadiobutton\fR(\fR?\fIoptions\fR?\fR);
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.VS
\fBactiveBackground\fR	\fBcursor\fR	\fBhighlightThickness\fR	\fBtakeFocus\fR
\fBactiveForeground\fR	\fBdisabledForeground\fR	\fBimage\fR	\fBtext\fR
\fBanchor\fR	\fBfont\fR	\fBjustify\fR	\fBtextVariable\fR
\fBbackground\fR	\fBforeground\fR	\fBpadX\fR	\fBunderline\fR
\fBbitmap\fR	\fBhighlightColor\fR	\fBpadY\fR	\fBwrapLength\fR
.VE
\fBborderWidth\fR	\fBhighlightBackground\fR	\fBrelief\fR
.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.ta 4c
.LP
.nf
Name:	\fBcommand\fR
Class:	\fBCommand\fR
Configure Option:	\fB\-command\fR
.fi
.IP
Specifies a Tcl command to associate with the button.  This command
is typically invoked when mouse button 1 is released over the button
window.  The button's global variable (\fB\-variable\fR option) will
be updated before the command is invoked.
.LP
.nf
Name:	\fBheight\fR
Class:	\fBHeight\fR
Configure Option:	\fB\-height\fR
.fi
.IP
Specifies a desired height for the button.
If an image or bitmap is being displayed in the button then the value is in
screen units (i.e. any of the forms acceptable to \fBTk_GetPixels\fR);
for text it is in lines of text.
If this option isn't specified, the button's desired height is computed
from the size of the image or bitmap or text being displayed in it.
.LP
.nf
.VS
Name:	\fBindicatorOn\fR
Class:	\fBIndicatorOn\fR
Configure Option:	\fB\-indicatoron\fR
.fi
.IP
Specifies whether or not the indicator should be drawn.  Must be a
proper boolean value.  If false, the \fBrelief\fR option is
ignored and the widget's relief is always sunken if the widget is
selected and raised otherwise.
.LP
.nf
Name:	\fBselectColor\fR
Class:	\fBBackground\fR
Configure Option:	\fB\-selectcolor\fR
.fi
.IP
Specifies a background color to use when the button is selected.
If \fBindicatorOn\fR is true, the color applicies to the indicator.
If \fBindicatorOn\fR is false, this color is used as the background
for the entire widget, in place of \fBbackground\fR or \fBactiveBackground\fR,
whenever the widget is selected.
If specified as an empty string, no special color is used for
displaying when the widget is selected.
.LP
.nf
Name:	\fBselectImage\fR
Class:	\fBSelectImage\fR
Configure Option:	\fB\-selectimage\fR
.fi
.IP
Specifies an image to display (in place of the \fBimage\fR option)
when the radiobutton is selected.
This option is ignored unless the \fBimage\fR option has been
specified.
.VE
.LP
.nf
Name:	\fBstate\fR
Class:	\fBState\fR
Configure Option:	\fB\-state\fR
.fi
.IP
Specifies one of three states for the radiobutton:  \fBnormal\fR, \fBactive\fR,
or \fBdisabled\fR.  In normal state the radiobutton is displayed using the
\fBforeground\fR and \fBbackground\fR options.  The active state is
typically used when the pointer is over the radiobutton.  In active state
the radiobutton is displayed using the \fBactiveForeground\fR and
\fBactiveBackground\fR options.  Disabled state means that the radiobutton
.VS
should be insensitive:  the default bindings will refuse to activate
the widget and will ignore mouse button presses.
.VE
In this state the \fBdisabledForeground\fR and
\fBbackground\fR options determine how the radiobutton is displayed.
.LP
.nf
Name:	\fBvalue\fR
Class:	\fBValue\fR
Configure Option:	\fB\-value\fR
.fi
.IP
Specifies value to store in the button's associated variable whenever
this button is selected.
.LP
.nf
Name:	\fBvariable\fR
Class:	\fBVariable\fR
Configure Option:	\fB\-variable\fR
.fi
.IP
Specifies name of global variable to set whenever this button is
selected.  Changes in this variable also cause the button to select
or deselect itself.
Defaults to the value \fBselectedButton\fR.
.LP
.nf
Name:	\fBwidth\fR
Class:	\fBWidth\fR
Configure Option:	\fB\-width\fR
.fi
.IP
Specifies a desired width for the button.
If an image or bitmap is being displayed in the button, the value is in
screen units (i.e. any of the forms acceptable to \fBTk_GetPixels\fR);
for text it is in characters.
If this option isn't specified, the button's desired width is computed
from the size of the image or bitmap or text being displayed in it.
.BE

.SH DESCRIPTION
.PP
The \fBradiobutton\fR command creates a new window (given by the
$widget\fR argument) and makes it into a radiobutton widget.
Additional
options, described above, may be specified on the command line
or in the option database
to configure aspects of the radiobutton such as its colors, font,
text, and initial relief.  The \fBradiobutton\fR command returns its
$widget\fR argument.  At the time this command is invoked,
there must not exist a window named $widget\fR, but
$widget\fR's parent must exist.
.PP
A radiobutton is a widget
.VS
that displays a textual string, bitmap or image
and a diamond called an \fIindicator\fR.
If text is displayed, it must all be in a single font, but it
can occupy multiple lines on the screen (if it contains newlines
or if wrapping occurs because of the \fBwrapLength\fR option) and
one of the characters may optionally be underlined using the
\fBunderline\fR option.
.VE
A radiobutton has
all of the behavior of a simple button: it can display itself in either
of three different ways, according to the \fBstate\fR option;
it can be made to appear
raised, sunken, or flat; it can be made to flash; and it invokes
a Tcl command whenever mouse button 1 is clicked over the
check button.
.PP
In addition, radiobuttons can be \fIselected\fR.
.VS
If a radiobutton is selected, the indicator is normally
drawn with a sunken relief and a special color, and
a Tcl variable associated with the radiobutton is set to a particular
value.
If the radiobutton is not selected, the indicator is drawn with a
raised relief and no special color.
Typically, several radiobuttons share a single variable and the
value of the variable indicates which radiobutton is to be selected.
When a radiobutton is selected it sets the value of the variable to
indicate that fact;  each radiobutton also monitors the value of
the variable and automatically selects and deselects itself when the
variable's value changes.
By default the variable \fBselectedButton\fR
is used;  its contents give the name of the button that is
selected, or the empty string if no button associated with that
variable is selected.
The name of the variable for a radiobutton,
plus the variable to be stored into it, may be modified with options
on the command line or in the option database.
Configuration options may also be used to modify the way the
indicator is displayed (or whether it is displayed at all).
.VE
By default a radio
button is configured to select itself on button clicks.

.SH "WIDGET METHODS"
.PP
The \fBradiobutton\fR command creates a widget object whose
name is $widget\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fI$radiobutton\fR->\fBmethod\fR(?\fIarg arg ...\fR?)
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for radiobutton widgets:
.TP
\fI$radiobutton->\fBcget\fR(\fIoption\fR)
.VS
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBradiobutton\fR
command.
.VE
.TP
\fI$radiobutton->\fBconfigure\fR(?\fIoption\fR?, ?\fIvalue, option, value, ...\fR?\fR)
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for $widget\fR (see \fBconfigure\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBradiobutton\fR
command.
.TP
\fI$radiobutton->\fBdeselect\fR
Deselects the radiobutton and sets the associated variable to an
empty string.
If this radiobutton was not currently selected, the command has
no effect.
.TP
\fI$radiobutton->\fBflash\fR
Flashes the radiobutton.  This is accomplished by redisplaying the radiobutton
several times, alternating between active and normal colors.  At
the end of the flash the radiobutton is left in the same normal/active
state as when the command was invoked.
This command is ignored if the radiobutton's state is \fBdisabled\fR.
.TP
\fI$radiobutton->\fBinvoke\fR
Does just what would have happened if the user invoked the radiobutton
with the mouse: selects the button and invokes
its associated Tcl command, if there is one.
The return value is the return value from the Tcl command, or an
empty string if there is no command associated with the radiobutton.
This command is ignored if the radiobutton's state is \fBdisabled\fR.
.TP
\fI$radiobutton->\fBselect\fR
Selects the radiobutton and sets the associated variable to the
value corresponding to this widget.

.SH BINDINGS
.PP
Tk automatically creates class bindings for radiobuttons that give them
the following default behavior:
.IP [1]
The radiobutton activates whenever the mouse passes over it and deactivates
whenever the mouse leaves the radiobutton.
.IP [2]
.VS
When mouse button 1 is pressed over a radiobutton it is invoked (it
becomes selected and the command associated with the button is
invoked, if there is one).
.IP [3]
When a radiobutton has the input focus, the space key causes the radiobutton
to be invoked.
.VE
.PP
If the radiobutton's state is \fBdisabled\fR then none of the above
actions occur:  the radiobutton is completely non-responsive.
.PP
The behavior of radiobuttons can be changed by defining new bindings for
individual widgets or by redefining the class bindings.

.SH KEYWORDS
radiobutton, widget
